/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiDeleteHandler;
import com.maplesoft.mathdoc.model.WmiDeleteManager;
import com.maplesoft.mathdoc.model.WmiDeletePlaceholderModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;

public abstract class WmiAbstractMathDeleteHandler
implements WmiDeleteHandler {
    protected WmiCompositeModel model;

    protected abstract void processRestructure(WmiDeleteManager var1) throws WmiNoWriteAccessException, WmiNoReadAccessException, WmiModelIndexOutOfBoundsException;

    public void processDelete(WmiDeleteManager wmiDeleteManager) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        this.replaceNonEmptyPlaceholders(wmiDeleteManager);
        this.processRestructure(wmiDeleteManager);
    }

    protected boolean isNonEmptyPlaceholder(WmiModel wmiModel) throws WmiNoReadAccessException {
        boolean bl = false;
        if (wmiModel instanceof WmiDeletePlaceholderModel) {
            WmiDeletePlaceholderModel wmiDeletePlaceholderModel = (WmiDeletePlaceholderModel)wmiModel;
            WmiModel wmiModel2 = wmiDeletePlaceholderModel.getReplacedModel();
            bl = !WmiModelUtil.isEmptyModel(wmiModel2);
        }
        return bl;
    }

    protected void replaceNonEmptyPlaceholders(WmiDeleteManager wmiDeleteManager) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        int n = this.model.getChildCount();
        for (int i = 0; i < n; ++i) {
            if (!this.isNonEmptyPlaceholder(this.model.getChild(i))) continue;
            this.replaceWithEmptyIdentifier(wmiDeleteManager, i);
        }
    }

    protected void replaceWithEmptyIdentifier(WmiDeleteManager wmiDeleteManager, int n) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiMathDocumentModel wmiMathDocumentModel = this.model.getDocument();
        WmiDeletePlaceholderModel wmiDeletePlaceholderModel = (WmiDeletePlaceholderModel)this.model.getChild(n);
        WmiModel wmiModel = wmiDeletePlaceholderModel.getReplacedModel();
        WmiFontAttributeSet wmiFontAttributeSet = wmiModel.getAttributes() instanceof WmiFontAttributeSet ? (WmiFontAttributeSet)wmiModel.getAttributes() : new WmiMathAttributeSet();
        WmiMathContext wmiMathContext = new WmiMathContext(wmiFontAttributeSet);
        WmiMathTokenModel wmiMathTokenModel = WmiMathFactory.createMathIdentifierToken(wmiMathDocumentModel, "", wmiMathContext);
        this.model.replaceChild(wmiMathTokenModel, n);
        wmiDeleteManager.setModelToReposition(new WmiModelPosition(wmiMathTokenModel, 0));
    }

    public boolean forceDeleteHandling() {
        return false;
    }
}

