/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.xml;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.io.WmiImportAction;
import com.maplesoft.mathdoc.io.WmiImportParser;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import org.xml.sax.Attributes;

public abstract class WmiXMLBlockImportAction
implements WmiImportAction {
    protected WmiXMLBlockImportAction() {
    }

    protected boolean definesCharAttributes() {
        return false;
    }

    protected String[] getRelevantAttributeKeys() {
        return null;
    }

    public void processAttributes(WmiImportParser wmiImportParser, Attributes attributes, WmiModel wmiModel) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        try {
            String[] stringArray = this.getRelevantAttributeKeys();
            if (stringArray == null) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    wmiModel.addAttribute(attributes.getQName(i), attributes.getValue(i));
                }
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    String string2 = attributes.getValue(string);
                    if (string2 == null) continue;
                    wmiModel.addAttribute(string, string2);
                }
            }
        }
        catch (Exception exception) {
            WmiErrorLog.log(exception);
        }
    }

    public void beginAction(WmiImportParser wmiImportParser, Object object) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        try {
            if (wmiImportParser != null) {
                WmiModel wmiModel;
                WmiFontAttributeSet wmiFontAttributeSet = null;
                if (this.definesCharAttributes()) {
                    wmiFontAttributeSet = wmiImportParser.pushCharacterAttributes();
                }
                if ((wmiModel = this.createModel(wmiImportParser.getDocument())) != null) {
                    if (object instanceof Attributes) {
                        this.processAttributes(wmiImportParser, (Attributes)object, wmiModel);
                    }
                    if (wmiFontAttributeSet != null) {
                        wmiFontAttributeSet.addAttributes(wmiModel.getAttributes());
                    }
                    wmiImportParser.openModel(wmiModel);
                }
            }
        }
        catch (Exception exception) {
            WmiErrorLog.log(exception);
        }
    }

    public void endAction(WmiImportParser wmiImportParser, Object object) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        try {
            if (wmiImportParser != null) {
                wmiImportParser.closeModel(null);
                if (this.definesCharAttributes()) {
                    wmiImportParser.popCharacterAttributes();
                }
            }
        }
        catch (Exception exception) {
            WmiErrorLog.log(exception);
        }
    }

    public abstract WmiModel createModel(WmiMathDocumentModel var1);
}

