/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.mathml.export;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiFormatException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.io.WmiExportAction;
import com.maplesoft.mathdoc.io.html.WmiHTMLFormatter;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathFormatter;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLActionExportAction;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLAlignGroupExportAction;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLAlignMarkExportAction;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLDocumentExportAction;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLEncloseExportAction;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLErrorExportAction;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLExportAction;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLFencedExportAction;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLFractionExportAction;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLGlyphExportAction;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLIdentifierExportAction;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLMathExportAction;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLMultiscriptsExportAction;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLNumericExportAction;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLOperatorExportAction;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLOverExportAction;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLPaddedExportAction;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLParagraphExportAction;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLPhantomExportAction;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLRootExportAction;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLRowExportAction;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLSpaceExportAction;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLSqrtExportAction;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLStringExportAction;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLStyleExportAction;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLSubExportAction;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLSubSupExportAction;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLSupExportAction;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLTableExportAction;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLTextExportAction;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLUnderExportAction;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLUnderOverExportAction;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import java.io.IOException;
import java.util.HashMap;

public class WmiMathMLPresentationFormatter
extends WmiMathFormatter {
    public static final int LEFT_INDENT_SIZE = 15;
    public static HashMap mathmlActionTable = new HashMap();

    public WmiMathMLPresentationFormatter(WmiMathDocumentView wmiMathDocumentView, boolean bl) {
        super(wmiMathDocumentView, 1);
        WmiMathMLExportAction.exportAttributes = bl;
    }

    public WmiMathMLPresentationFormatter(WmiMathDocumentView wmiMathDocumentView) {
        super(wmiMathDocumentView, 1);
    }

    protected WmiExportAction getFormatAction(WmiModelTag wmiModelTag) {
        return (WmiExportAction)mathmlActionTable.get(wmiModelTag);
    }

    protected int format() throws IllegalArgumentException, WmiFormatException, WmiNoReadAccessException {
        WmiModel wmiModel = this.getRootModel();
        if (this.docView != null && this.docView.getModel().getDocument() != wmiModel.getDocument()) {
            throw new IllegalArgumentException("Model must be part ofthe same hierarchy as the MathDocumentView used forformatter initialization.");
        }
        int n = -1;
        try {
            this.processModel(wmiModel);
            this.flushBuffer();
            n = 0;
        }
        catch (IOException iOException) {
            this.throwFormatException(iOException);
        }
        return n;
    }

    public static int getMaxWidth() {
        double d = WmiHTMLFormatter.getMaxWidth();
        return (int)d;
    }

    public void writeMathModel(WmiMathModel wmiMathModel) throws WmiNoReadAccessException, IOException {
        try {
            this.rootModel = wmiMathModel;
            this.format();
        }
        catch (WmiFormatException wmiFormatException) {
            WmiErrorLog.log(wmiFormatException);
        }
    }

    static {
        mathmlActionTable.put(WmiModelTag.DOCUMENT, new WmiMathMLDocumentExportAction());
        mathmlActionTable.put(WmiModelTag.PARAGRAPH, new WmiMathMLParagraphExportAction());
        mathmlActionTable.put(WmiModelTag.MATH, new WmiMathMLMathExportAction());
        mathmlActionTable.put(WmiModelTag.MATH_IDENTIFIER, new WmiMathMLIdentifierExportAction());
        mathmlActionTable.put(WmiModelTag.MATH_NUMERIC, new WmiMathMLNumericExportAction());
        mathmlActionTable.put(WmiModelTag.MATH_OPERATOR, new WmiMathMLOperatorExportAction());
        mathmlActionTable.put(WmiModelTag.MATH_TEXT, new WmiMathMLTextExportAction());
        mathmlActionTable.put(WmiModelTag.MATH_SPACE, new WmiMathMLSpaceExportAction());
        mathmlActionTable.put(WmiModelTag.MATH_STRING, new WmiMathMLStringExportAction());
        mathmlActionTable.put(WmiModelTag.MATH_GLYPH, new WmiMathMLGlyphExportAction());
        mathmlActionTable.put(WmiModelTag.MATH_ROW, new WmiMathMLRowExportAction());
        mathmlActionTable.put(WmiModelTag.MATH_ENCLOSE, new WmiMathMLEncloseExportAction());
        mathmlActionTable.put(WmiModelTag.MATH_FRAC, new WmiMathMLFractionExportAction());
        mathmlActionTable.put(WmiModelTag.MATH_SQUARE_ROOT, new WmiMathMLSqrtExportAction());
        mathmlActionTable.put(WmiModelTag.MATH_NROOT, new WmiMathMLRootExportAction());
        mathmlActionTable.put(WmiModelTag.MATH_STYLE, new WmiMathMLStyleExportAction());
        mathmlActionTable.put(WmiModelTag.MATH_ERROR, new WmiMathMLErrorExportAction());
        mathmlActionTable.put(WmiModelTag.MATH_PADDED, new WmiMathMLPaddedExportAction());
        mathmlActionTable.put(WmiModelTag.MATH_PHANTOM, new WmiMathMLPhantomExportAction());
        mathmlActionTable.put(WmiModelTag.MATH_FENCED, new WmiMathMLFencedExportAction());
        mathmlActionTable.put(WmiModelTag.MATH_SUBSCRIPT, new WmiMathMLSubExportAction());
        mathmlActionTable.put(WmiModelTag.MATH_SUPERSCRIPT, new WmiMathMLSupExportAction());
        mathmlActionTable.put(WmiModelTag.MATH_SUB_SUP, new WmiMathMLSubSupExportAction());
        mathmlActionTable.put(WmiModelTag.MATH_UNDER, new WmiMathMLUnderExportAction());
        mathmlActionTable.put(WmiModelTag.MATH_OVER, new WmiMathMLOverExportAction());
        mathmlActionTable.put(WmiModelTag.MATH_UNDER_OVER, new WmiMathMLUnderOverExportAction());
        mathmlActionTable.put(WmiModelTag.MATH_MULTISCRIPTS, new WmiMathMLMultiscriptsExportAction());
        mathmlActionTable.put(WmiModelTag.MATH_PRESCRIPTS, new WmiMathMLMultiscriptsExportAction.WmiMathMLPrescriptExportAction());
        mathmlActionTable.put(WmiModelTag.MATH_NONE, new WmiMathMLMultiscriptsExportAction.WmiMathMLNoneExportAction());
        mathmlActionTable.put(WmiModelTag.MATH_TABLE, new WmiMathMLTableExportAction());
        mathmlActionTable.put(WmiModelTag.MATH_TABLE_ROW, new WmiMathMLTableExportAction.WmiMathMLTableRowExportAction());
        mathmlActionTable.put(WmiModelTag.MATH_TABLE_LABELED_ROW, new WmiMathMLTableExportAction.WmiMathMLTableLabeledRowExportAction());
        mathmlActionTable.put(WmiModelTag.MATH_TABLE_CELL, new WmiMathMLTableExportAction.WmiMathMLTableDataExportAction());
        mathmlActionTable.put(WmiModelTag.MATH_ALIGN_GROUP, new WmiMathMLAlignGroupExportAction());
        mathmlActionTable.put(WmiModelTag.MATH_ALIGN_MARK, new WmiMathMLAlignMarkExportAction());
        mathmlActionTable.put(WmiModelTag.MATH_ACTION, new WmiMathMLActionExportAction());
    }
}

