/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.mathml.export;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.io.WmiExportFormatter;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathFormatter;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLExportAction;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.util.WmiMathEntityNameMapper;
import java.io.IOException;

public class WmiMathMLOperatorExportAction
extends WmiMathMLExportAction {
    public void openModel(WmiExportFormatter wmiExportFormatter, WmiModel wmiModel) throws IOException {
        WmiMathOperatorModel wmiMathOperatorModel = (WmiMathOperatorModel)wmiModel;
        wmiExportFormatter.writeBinary("<mo");
        try {
            wmiExportFormatter.writeText(this.exportAttributes(WmiMathAttributeSet.MATHML_ATTR_KEYS, (WmiAbstractArrayAttributeSet)((WmiMathAttributeSet)wmiMathOperatorModel.getAttributes())));
            wmiExportFormatter.writeText(this.exportAttributes(WmiMathOperatorModel.WmiMathOperatorAttributeSet.ATTRIBUTES, (WmiAbstractArrayAttributeSet)((WmiMathOperatorModel.WmiMathOperatorAttributeSet)wmiMathOperatorModel.getAttributes())));
            String string = wmiMathOperatorModel.getSemanticLabel();
            if (string.equals("&uminus0;")) {
                string = "&minus;";
            } else if (string.equals(" ")) {
                string = "&#32;";
            }
            if (string.length() == 0) {
                wmiExportFormatter.writeBinary(">");
                wmiExportFormatter.writeText(wmiMathOperatorModel.getTokenContents());
            } else if (string.length() > 1 || WmiMathEntityNameMapper.getEntityName(string.charAt(0)) == null) {
                if (string.length() == 1 && (string.charAt(0) == '\u23a2' || string.charAt(0) == '\u23a5')) {
                    wmiExportFormatter.writeBinary(">|");
                } else if (string.length() == 1 && string.charAt(0) == '\u0305') {
                    wmiExportFormatter.writeBinary(">&macr;");
                } else if (string.equals("<>")) {
                    wmiExportFormatter.writeBinary(">&lt;&gt;");
                } else if (string.equals("<=")) {
                    wmiExportFormatter.writeBinary(">&lt;&equals;");
                } else if (string.equals(">=")) {
                    wmiExportFormatter.writeBinary(">&gt;&equals;");
                } else {
                    wmiExportFormatter.writeBinary(">" + string);
                }
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                WmiMathFormatter.makeHTMLSafe(WmiMathEntityNameMapper.getEntityName(string.charAt(0)), stringBuffer);
                wmiExportFormatter.writeBinary(">&" + stringBuffer + ";");
            }
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
    }

    protected boolean enableExport(String string, Object object) {
        boolean bl = super.enableExport(string, object);
        if (bl) {
            bl = !object.toString().equals("unset");
        }
        return bl;
    }

    public void closeModel(WmiExportFormatter wmiExportFormatter, WmiModel wmiModel) throws IOException {
        wmiExportFormatter.writeBinary("</mo>");
    }
}

