/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.mathml;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.io.WmiImportParser;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportAction;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import java.awt.Color;
import org.xml.sax.Attributes;

public abstract class WmiMathMLTokenImportAction
extends WmiMathMLImportAction {
    public abstract WmiModel createModel(WmiMathDocumentModel var1);

    public static Color parseColor(String string, Color color) {
        Color color2;
        block9: {
            color2 = null;
            if (!string.startsWith("#")) {
                try {
                    String string2 = WmiMathAttributeSet.getColour(string.toLowerCase());
                    if (!string2.equals("")) {
                        color2 = Color.decode(string2);
                        break block9;
                    }
                    color2 = color;
                }
                catch (NumberFormatException numberFormatException) {
                    color2 = color;
                }
            } else {
                try {
                    if (string.length() == 4) {
                        String string3 = string.substring(1, 2) + "0" + string.substring(2, 3) + "0" + string.substring(3, 4) + "0";
                        color2 = Color.decode("0x" + string3);
                    } else {
                        color2 = Color.decode("0x" + string.substring(1));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    color2 = color;
                }
            }
        }
        return color2;
    }

    public void processAttributes(WmiImportParser wmiImportParser, Attributes attributes, WmiModel wmiModel) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        super.processAttributes(wmiImportParser, attributes, wmiModel);
        WmiAttributeSet wmiAttributeSet = wmiModel.getAttributes();
        WmiMathAttributeSet wmiMathAttributeSet = null;
        if (wmiAttributeSet instanceof WmiMathAttributeSet) {
            wmiMathAttributeSet = (WmiMathAttributeSet)wmiAttributeSet;
        }
        if (wmiMathAttributeSet != null) {
            String string;
            String string2;
            Object object;
            Object object2;
            String string3 = attributes.getValue("mathcolor");
            if (string3 == null) {
                string3 = attributes.getValue("color");
            }
            if (string3 != null) {
                string3 = string3.toLowerCase();
                object2 = WmiMathMLTokenImportAction.parseColor(string3, Color.BLACK);
                wmiMathAttributeSet.setForeground(((Color)object2).getRGB());
                if (wmiModel instanceof WmiAbstractMathTokenModel) {
                    ((WmiAbstractMathTokenModel)wmiModel).setModifiedFlag(1);
                }
            }
            if ((object2 = attributes.getValue("mathbackground")) != null) {
                object2 = ((String)object2).toLowerCase();
                object = WmiMathMLTokenImportAction.parseColor((String)object2, Color.WHITE);
                wmiMathAttributeSet.setBackground(((Color)object).getRGB());
                wmiMathAttributeSet.setExtendedStyle(32);
                if (wmiModel instanceof WmiAbstractMathTokenModel) {
                    ((WmiAbstractMathTokenModel)wmiModel).setModifiedFlag(2);
                }
            }
            if ((object = attributes.getValue("mathsize")) == null) {
                object = attributes.getValue("fontsize");
            }
            if (object != null) {
                try {
                    object = ((String)object).toLowerCase();
                    wmiMathAttributeSet.setSize(Integer.parseInt((String)object));
                    if (wmiModel instanceof WmiAbstractMathTokenModel) {
                        ((WmiAbstractMathTokenModel)wmiModel).setModifiedFlag(4);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((string2 = attributes.getValue("mathvariant")) == null) {
                boolean bl;
                string = attributes.getValue("fontweight");
                String string4 = attributes.getValue("fontstyle");
                boolean bl2 = string != null && string.equals("bold") ? true : wmiMathAttributeSet.isBold();
                boolean bl3 = bl = string4 != null && string4.equals("italic") ? true : wmiMathAttributeSet.isItalic();
                if (bl2) {
                    string2 = bl ? "bold-italic" : "bold";
                } else if (bl) {
                    string2 = "italic";
                }
            }
            if (string2 != null) {
                int n = wmiMathAttributeSet.getExtendedStyle();
                wmiMathAttributeSet.setExtendedStyle(n & 0xFFFFFFFD);
                wmiMathAttributeSet.addAttribute("mathvariant", string2.toLowerCase());
                if (wmiModel instanceof WmiAbstractMathTokenModel) {
                    ((WmiAbstractMathTokenModel)wmiModel).setModifiedFlag(8);
                }
            }
            if ((string = attributes.getValue("fontfamily")) != null) {
                wmiMathAttributeSet.addAttribute("fontfamily", string);
                if (wmiModel instanceof WmiAbstractMathTokenModel) {
                    ((WmiAbstractMathTokenModel)wmiModel).setModifiedFlag(16);
                }
            }
            wmiModel.setAttributes(wmiMathAttributeSet);
        }
    }
}

