/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.mathml;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.io.WmiImportParser;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportAction;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportParser;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFencedModel;
import org.xml.sax.Attributes;

public class WmiMathMLContentListImportAction
extends WmiMathMLImportAction {
    private static final String ORDER = "order";
    private static final String NUMERIC = "numeric";
    private static final String LEXICOGRAPHIC = "lexicographic";
    private String order = "";

    public WmiModel createModel(WmiMathDocumentModel wmiMathDocumentModel) {
        WmiMathFencedModel wmiMathFencedModel = null;
        try {
            WmiMathContext wmiMathContext = new WmiMathContext(new WmiMathAttributeSet());
            wmiMathFencedModel = new WmiMathFencedModel(wmiMathDocumentModel, new WmiModel[0], wmiMathContext);
            wmiMathFencedModel.addAttribute("Typesetting:-msemantics", "list");
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
            WmiErrorLog.log(wmiInvalidModelInitializationException);
        }
        return wmiMathFencedModel;
    }

    public void processAttributes(WmiImportParser wmiImportParser, Attributes attributes, WmiModel wmiModel) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        String string = attributes.getValue(ORDER);
        if (string != null) {
            this.order = string;
        }
        if (this.order.equals(NUMERIC)) {
            wmiModel.addAttribute("Typesetting:-msemantics", "list-numeric");
        } else if (this.order.equals(LEXICOGRAPHIC)) {
            wmiModel.addAttribute("Typesetting:-msemantics", "list-lexicographic");
        } else {
            wmiModel.addAttribute("Typesetting:-msemantics", "list");
        }
    }

    public void endAction(WmiImportParser wmiImportParser, Object object) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        ((WmiMathMLImportParser)wmiImportParser).updateListModel();
        super.endAction(wmiImportParser, object);
    }
}

