/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io;

import com.maplesoft.mathdoc.controller.WmiViewFactory;
import com.maplesoft.mathdoc.exception.WmiFormatException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.io.WmiFormatObserver;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiParagraphModel;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.util.WmiNamedWriter;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.util.RuntimeLocale;
import com.maplesoft.util.encoder.AbstractStringEncoder;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public abstract class WmiExportFormatter {
    public static final int FORMAT_SUCCESS = 0;
    public static final int FORMAT_FAILURE = -1;
    public static final int FORMAT_CANCEL = -2;
    private List observers;
    private Writer writer;
    private Stack writerStack;
    protected WmiModel rootModel;
    private AbstractStringEncoder encoder = null;
    private boolean clipboardAction = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected WmiExportFormatter() {
    }

    protected void flushBuffer() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    protected void beginFormat(Writer writer, WmiModel wmiModel) throws WmiFormatException, WmiNoReadAccessException {
        if (wmiModel == null) {
            throw new NullPointerException("model is null");
        }
        if (writer == null) {
            throw new NullPointerException("writer is null");
        }
        if (!WmiModelLock.hasLock(wmiModel, 0) && !WmiModelLock.hasLock(wmiModel, 1)) {
            throw new WmiNoReadAccessException(wmiModel);
        }
        this.writer = writer;
        this.rootModel = wmiModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endFormat(boolean bl) throws IOException {
        if (!$assertionsDisabled && this.writerStack != null && !this.writerStack.isEmpty()) {
            throw new AssertionError((Object)"writers remaining on writer stack");
        }
        try {
            this.flushBuffer();
            if (!bl) {
                this.writer.close();
            }
        }
        finally {
            this.writer = null;
            this.rootModel = null;
            this.encoder = null;
        }
    }

    protected final WmiModel getRootModel() {
        return this.rootModel;
    }

    protected String getFilename() {
        String string = null;
        if (this.writer instanceof WmiNamedWriter) {
            string = ((WmiNamedWriter)((Object)this.writer)).getFilename();
        }
        return string;
    }

    protected final AbstractStringEncoder getEncoder() {
        return this.encoder;
    }

    public final void setEncoder(AbstractStringEncoder abstractStringEncoder) {
        if (this.canSetEncoder()) {
            this.encoder = abstractStringEncoder;
        }
    }

    protected AbstractStringEncoder createDefaultEncoder() {
        return RuntimeLocale.getExportEncoder();
    }

    public abstract boolean canSetEncoder();

    public boolean setOptions() {
        return true;
    }

    public final WmiMathDocumentModel getDocument() {
        return this.rootModel.getDocument();
    }

    protected final void throwFormatException(Exception exception) throws WmiFormatException {
        exception.printStackTrace();
        throw new WmiFormatException(exception.toString(), this.writer);
    }

    public final void pushWriter(Writer writer) {
        if (this.writerStack == null) {
            this.writerStack = new Stack();
        }
        this.writerStack.push(this.writer);
        this.writer = writer;
    }

    public final void popWriter() throws IOException {
        if (this.writerStack == null || this.writerStack.isEmpty()) {
            throw new IllegalStateException("writer stack is empty -- can't pop");
        }
        if (this.writer != null) {
            this.writer.flush();
            this.writer.close();
        }
        this.writer = (Writer)this.writerStack.pop();
    }

    public final int format(Writer writer, WmiModel wmiModel) throws WmiFormatException, WmiNoReadAccessException {
        return this.format(writer, wmiModel, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int format(Writer writer, WmiModel wmiModel, boolean bl) throws WmiFormatException, WmiNoReadAccessException {
        this.beginFormat(writer, wmiModel);
        if (this.encoder == null) {
            this.encoder = this.createDefaultEncoder();
        }
        int n = -1;
        try {
            n = this.format();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                this.endFormat(bl);
            }
            catch (IOException iOException) {
                this.throwFormatException(iOException);
            }
        }
        return n;
    }

    protected static int formatUsingExistingWriter(WmiExportFormatter wmiExportFormatter, WmiExportFormatter wmiExportFormatter2, WmiModel wmiModel) throws WmiFormatException, WmiNoReadAccessException {
        if (wmiExportFormatter2.canSetEncoder()) {
            wmiExportFormatter2.setEncoder(wmiExportFormatter.getEncoder());
        }
        return wmiExportFormatter2.format(wmiExportFormatter.writer, wmiModel, true);
    }

    protected abstract int format() throws WmiFormatException, WmiNoReadAccessException;

    protected abstract boolean ignoreHiddenModels();

    public void openCompositeModel(WmiModelTag wmiModelTag) throws IOException {
    }

    public void closeCompositeModel(WmiModelTag wmiModelTag) throws IOException {
    }

    public abstract void writeMathModel(WmiMathModel var1) throws WmiNoReadAccessException, IOException;

    public abstract void writeTextModel(WmiTextModel var1) throws WmiNoReadAccessException, IOException;

    public abstract void writeAttribute(Object var1, Object var2) throws IOException;

    public final void writeText(String string) throws IOException {
        String string2 = this.transformForTextOutput(string);
        this.writeBinary(string2);
    }

    public final void writeBinary(String string) throws IOException {
        this.writer.write(string);
    }

    protected String transformForTextOutput(String string) {
        return this.encode(string);
    }

    protected String encode(String string) {
        String string2 = string;
        if (this.encoder != null && this.shouldEncode(string)) {
            string2 = this.encoder.fromUnicode(string);
        }
        return string2;
    }

    protected boolean shouldEncode(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ('\u007f' >= c) continue;
            return true;
        }
        return false;
    }

    public boolean registerObserver(WmiFormatObserver wmiFormatObserver) {
        if (wmiFormatObserver != null) {
            if (this.observers == null) {
                this.observers = new ArrayList();
            }
            this.observers.add(wmiFormatObserver);
        }
        return true;
    }

    public void reportModelError(WmiModel wmiModel, Object object) {
        if (this.observers != null) {
            for (int i = 0; i < this.observers.size(); ++i) {
                WmiFormatObserver wmiFormatObserver = (WmiFormatObserver)this.observers.get(i);
                wmiFormatObserver.modelError(wmiModel, object);
            }
        }
    }

    protected void reportFormatBegin() {
        if (this.observers != null) {
            for (int i = 0; i < this.observers.size(); ++i) {
                WmiFormatObserver wmiFormatObserver = (WmiFormatObserver)this.observers.get(i);
                wmiFormatObserver.formatBegin(this.getDocument());
            }
        }
    }

    protected void reportFormatEnd() {
        if (this.observers != null) {
            for (int i = 0; i < this.observers.size(); ++i) {
                WmiFormatObserver wmiFormatObserver = (WmiFormatObserver)this.observers.get(i);
                wmiFormatObserver.formatEnd(this.getDocument());
            }
        }
    }

    protected void reportUnrecognizedTag(WmiModel wmiModel) {
        if (this.observers != null) {
            for (int i = 0; i < this.observers.size(); ++i) {
                WmiFormatObserver wmiFormatObserver = (WmiFormatObserver)this.observers.get(i);
                wmiFormatObserver.unrecognizedModelTag(wmiModel);
            }
        }
    }

    protected WmiView modelToView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) throws WmiNoReadAccessException {
        WmiView wmiView = null;
        WmiViewFactory wmiViewFactory = wmiMathDocumentView.getViewFactory();
        if (wmiViewFactory != null) {
            wmiView = wmiModel instanceof WmiCompositeModel ? wmiViewFactory.createView(wmiModel, wmiMathDocumentView) : this.createTemporaryLeafView(wmiModel, wmiMathDocumentView, wmiViewFactory);
        }
        if (wmiView instanceof WmiPositionedView) {
            ((WmiPositionedView)wmiView).layoutView();
        }
        return wmiView;
    }

    private WmiView createTemporaryLeafView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView, WmiViewFactory wmiViewFactory) throws WmiNoReadAccessException {
        WmiParagraphModel wmiParagraphModel = null;
        WmiCompositeModel wmiCompositeModel = WmiModelUtil.findAncestorOfClass(wmiModel, WmiParagraphModel.class);
        wmiParagraphModel = wmiCompositeModel instanceof WmiParagraphModel ? (WmiParagraphModel)wmiCompositeModel : new WmiParagraphModel(this.getDocument());
        WmiParagraphView wmiParagraphView = new WmiParagraphView(wmiParagraphModel, wmiMathDocumentView);
        WmiView wmiView = wmiViewFactory.createView(wmiModel, wmiParagraphView);
        wmiParagraphView.appendView(wmiView);
        return wmiView;
    }

    public boolean isClipboardAction() {
        return this.clipboardAction;
    }

    public void setClipboardAction(boolean bl) {
        this.clipboardAction = bl;
    }

    static {
        $assertionsDisabled = !WmiExportFormatter.class.desiredAssertionStatus();
    }
}

