/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.font;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class WmiSharedGlyphVector
extends GlyphVector {
    private Font font;
    private FontRenderContext frc;
    private int[] glyphs;
    private float[] horizontalOffset;
    private int base;
    private int length;

    public WmiSharedGlyphVector(Font font, String string, FontRenderContext fontRenderContext) {
        this.font = font;
        this.frc = fontRenderContext;
        WmiFontMetrics wmiFontMetrics = WmiFontResolver.getFontMetrics(font);
        this.length = string.length();
        this.base = 0;
        this.glyphs = new int[this.length];
        this.horizontalOffset = new float[this.length + 1];
        for (int i = 0; i < this.length; ++i) {
            char c = string.charAt(i);
            this.glyphs[i] = wmiFontMetrics.getCharacterProperty(6, c, fontRenderContext);
            this.horizontalOffset[i + 1] = this.horizontalOffset[i] + wmiFontMetrics.getPreciseCharacterProperty(2, c, fontRenderContext);
        }
    }

    public WmiSharedGlyphVector(WmiSharedGlyphVector wmiSharedGlyphVector, int n) {
        this.font = wmiSharedGlyphVector.font;
        this.frc = wmiSharedGlyphVector.frc;
        this.glyphs = wmiSharedGlyphVector.glyphs;
        this.horizontalOffset = wmiSharedGlyphVector.horizontalOffset;
        this.base = wmiSharedGlyphVector.base + n;
        this.length = wmiSharedGlyphVector.length - n;
    }

    public WmiSharedGlyphVector splitVector(int n, int n2) {
        WmiSharedGlyphVector wmiSharedGlyphVector = new WmiSharedGlyphVector(this, n + n2);
        this.length = n;
        return wmiSharedGlyphVector;
    }

    public WmiSharedGlyphVector(WmiSharedGlyphVector wmiSharedGlyphVector, int n, int n2) {
        this.font = wmiSharedGlyphVector.getFont();
        this.frc = wmiSharedGlyphVector.getFontRenderContext();
        this.glyphs = wmiSharedGlyphVector.glyphs;
        this.horizontalOffset = wmiSharedGlyphVector.horizontalOffset;
        this.base = wmiSharedGlyphVector.base + n;
        this.length = n2;
    }

    public Font getFont() {
        return this.font;
    }

    public FontRenderContext getFontRenderContext() {
        return this.frc;
    }

    public void performDefaultLayout() {
    }

    public int getNumGlyphs() {
        return this.length;
    }

    public int getGlyphCode(int n) {
        return this.glyphs[this.base + n];
    }

    public int[] getGlyphCodes(int n, int n2, int[] nArray) {
        if (nArray == null) {
            nArray = new int[n2];
        }
        for (int i = 0; i < n2; ++i) {
            nArray[i] = this.glyphs[this.base + n + i];
        }
        return nArray;
    }

    public Rectangle2D getLogicalBounds() {
        WmiErrorLog.log(new Exception("Not implemented"));
        return null;
    }

    public Rectangle2D getVisualBounds() {
        WmiErrorLog.log(new Exception("Not implemented"));
        return null;
    }

    public Shape getOutline() {
        WmiErrorLog.log(new Exception("Not implemented"));
        return null;
    }

    public Shape getOutline(float f, float f2) {
        WmiErrorLog.log(new Exception("Not implemented"));
        return null;
    }

    public Shape getGlyphOutline(int n) {
        WmiErrorLog.log(new Exception("Not implemented"));
        return null;
    }

    public Point2D getGlyphPosition(int n) {
        return new Point2D.Float(this.horizontalOffset[this.base + n] - this.horizontalOffset[this.base], 0.0f);
    }

    public void setGlyphPosition(int n, Point2D point2D) {
        WmiErrorLog.log(new Exception("Not implemented"));
    }

    public AffineTransform getGlyphTransform(int n) {
        WmiErrorLog.log(new Exception("Not implemented"));
        return null;
    }

    public void setGlyphTransform(int n, AffineTransform affineTransform) {
        WmiErrorLog.log(new Exception("Not implemented"));
    }

    public float[] getGlyphPositions(int n, int n2, float[] fArray) {
        if (fArray == null) {
            fArray = new float[2 * n2];
        }
        for (int i = 0; i < n2; ++i) {
            fArray[2 * i] = this.horizontalOffset[this.base + n + i] - this.horizontalOffset[this.base];
            fArray[2 * i + 1] = 0.0f;
        }
        return fArray;
    }

    public Shape getGlyphLogicalBounds(int n) {
        WmiErrorLog.log(new Exception("Not implemented"));
        return null;
    }

    public Shape getGlyphVisualBounds(int n) {
        WmiErrorLog.log(new Exception("Not implemented"));
        return null;
    }

    public GlyphMetrics getGlyphMetrics(int n) {
        WmiErrorLog.log(new Exception("Not implemented"));
        return null;
    }

    public GlyphJustificationInfo getGlyphJustificationInfo(int n) {
        WmiErrorLog.log(new Exception("Not implemented"));
        return null;
    }

    public boolean equals(GlyphVector glyphVector) {
        WmiErrorLog.log(new Exception("Not implemented"));
        return false;
    }

    public float getHorizontalOffset(int n) {
        return this.base != 0 ? this.horizontalOffset[this.base + n] - this.horizontalOffset[this.base] : this.horizontalOffset[n];
    }
}

