/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.font;

import com.maplesoft.mathdoc.font.WmiFontCache;
import com.maplesoft.util.RuntimeLocale;
import com.maplesoft.util.StringTools;
import com.maplesoft.util.StringToolsJapanese;
import java.awt.Font;
import java.util.HashSet;
import java.util.Set;

public class WmiLocalizedFontResolver {
    private Set knownMonospacedFontsForLocale = new HashSet();
    private Set knownSerifFontsForLocale = new HashSet();
    private Set knownSansserifFontsForLocale = new HashSet();
    private WmiFontCache monospaced;
    private WmiFontCache serif;
    private WmiFontCache sansserif;
    private static final WmiLocalizedFontResolver instance;

    private WmiLocalizedFontResolver() {
        WmiFontCache wmiFontCache;
        this.monospaced = wmiFontCache = new WmiFontCache(new Font("Times New Roman", 0, 12));
        this.serif = wmiFontCache;
        this.sansserif = wmiFontCache;
    }

    private void addLocalizedMonospacedFont(String string) {
        this.knownMonospacedFontsForLocale.add(string);
    }

    private void addLocalizedSerifFont(String string) {
        this.knownSerifFontsForLocale.add(string);
    }

    private void addLocalizedSansserifFont(String string) {
        this.knownSansserifFontsForLocale.add(string);
    }

    private Font mapLocalizedFont(Font font) {
        String string = font.getFamily();
        if (this.knownMonospacedFontsForLocale.contains(string)) {
            font = this.monospaced.getFont(font.getStyle(), font.getSize());
        } else if (this.knownSerifFontsForLocale.contains(string)) {
            font = this.serif.getFont(font.getStyle(), font.getSize());
        } else if (this.knownSansserifFontsForLocale.contains(string)) {
            font = this.sansserif.getFont(font.getStyle(), font.getSize());
        }
        return font;
    }

    public Font mapFont(Font font, String string) {
        if (RuntimeLocale.isJapanese()) {
            return font;
        }
        if (string == null || string.length() == 0) {
            return font;
        }
        char c = string.charAt(0);
        if (!StringTools.isCJKCharacter(c)) {
            font = this.mapLocalizedFont(font);
        }
        return font;
    }

    public int getContinuousRunIndex(String string) {
        if (string == null || string.length() == 0) {
            return -1;
        }
        int n = -1;
        if (StringTools.isCJKCharacter(string.charAt(0))) {
            for (int i = 1; i < string.length(); ++i) {
                if (StringTools.isCJKCharacter(string.charAt(i))) continue;
                n = i;
                break;
            }
        } else {
            for (int i = 1; i < string.length(); ++i) {
                if (!StringTools.isCJKCharacter(string.charAt(i))) continue;
                n = i;
                break;
            }
        }
        return n;
    }

    public static WmiLocalizedFontResolver getInstance() {
        return instance;
    }

    static {
        if (RuntimeLocale.isJapanese() || RuntimeLocale.isSimplifiedChinese() || RuntimeLocale.isKorean()) {
            instance = new WmiLocalizedFontResolver();
            instance.addLocalizedMonospacedFont(StringToolsJapanese.GOTHIC_FONT_NAME);
            instance.addLocalizedMonospacedFont(StringToolsJapanese.GOTHIC_ALTERNATE_NAME);
            instance.addLocalizedMonospacedFont(StringToolsJapanese.PGOTHIC_FONT_NAME);
            instance.addLocalizedMonospacedFont(StringToolsJapanese.PGOTHIC_ALTERNATE_NAME);
            instance.addLocalizedMonospacedFont("SimSun");
            instance.addLocalizedSerifFont("AppleMyungjo");
            instance.addLocalizedSerifFont("BiauKai");
            instance.addLocalizedSerifFont("LiSong Pro");
            instance.addLocalizedSerifFont(StringToolsJapanese.MINCHO_FONT_NAME);
            instance.addLocalizedSerifFont(StringToolsJapanese.MINCHO_ALTERNATE_NAME);
            instance.addLocalizedSerifFont(StringToolsJapanese.PMINCHO_FONT_NAME);
            instance.addLocalizedSerifFont(StringToolsJapanese.PMINCHO_ALTERNATE_NAME);
            instance.addLocalizedSerifFont("PMingLiU");
            instance.addLocalizedSerifFont("STFangsong");
            instance.addLocalizedSerifFont("STKaiti");
            instance.addLocalizedSerifFont("STSong");
            instance.addLocalizedSansserifFont("#GungSeo");
            instance.addLocalizedSansserifFont("#HeadLineA");
            instance.addLocalizedSansserifFont("#PCMyungjo");
            instance.addLocalizedSansserifFont("#PilGi");
            instance.addLocalizedSansserifFont("Apple Gothic");
            instance.addLocalizedSansserifFont("Apple LiGothic");
            instance.addLocalizedSansserifFont("Apple LiSung");
            instance.addLocalizedSansserifFont("Fang Song");
            instance.addLocalizedSansserifFont("Gulim");
            instance.addLocalizedSansserifFont("Hei");
            instance.addLocalizedSansserifFont("Hiragino Kaku Gothic Pro");
            instance.addLocalizedSansserifFont("Hiragino Kaku Gothic Std");
            instance.addLocalizedSansserifFont("Hiragino Maru Gothic Pro");
            instance.addLocalizedSansserifFont("Hiragino Mincho Pro");
            instance.addLocalizedSansserifFont("Kai");
            instance.addLocalizedSansserifFont("Kino MT");
            instance.addLocalizedSansserifFont("LiHei Pro");
            instance.addLocalizedSansserifFont("MS PGothic");
            instance.addLocalizedSansserifFont("News Gothic MT");
            instance.addLocalizedSansserifFont("Osaka");
            instance.addLocalizedSansserifFont("STHeiti");
            instance.addLocalizedSansserifFont("Song");
            instance.addLocalizedSansserifFont("Tahoma");
        } else {
            instance = null;
        }
    }
}

