/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.font;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.util.ResourceLoader;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;

public class FontIndexer {
    private static final int TABLE_SIZE = 256;
    private String fontName;
    private String fontPath;
    private Font referenceFont;
    private static FontIndexer overrideIndexer = new FontIndexer(null, null);
    private char[][] data = new char[256][];

    protected FontIndexer(String string, String string2) {
        this.fontName = string;
        this.fontPath = string2;
        this.initialize();
    }

    protected void initialize() {
        char[] cArray = this.getInitializerTable();
        if (cArray != null) {
            int n = cArray.length;
            for (int i = 0; i < n; i += 2) {
                this.put(cArray[i], cArray[i + 1]);
            }
        }
        if (this.fontPath != null) {
            try {
                this.referenceFont = ResourceLoader.getResourceAsFont(this.fontPath);
            }
            catch (FontFormatException fontFormatException) {
                WmiErrorLog.log(fontFormatException);
            }
            catch (IOException iOException) {
                WmiErrorLog.log(iOException);
            }
        }
    }

    protected char[] getInitializerTable() {
        return null;
    }

    public void put(char c, char c2) {
        int n = c >> 8;
        int n2 = c & 0xFF;
        char[] cArray = this.data[n];
        if (cArray == null) {
            this.data[n] = new char[256];
            cArray = this.data[n];
        }
        cArray[n2] = c2;
        if (this.forceMapping() && overrideIndexer != null && overrideIndexer != this) {
            overrideIndexer.put(c, c2);
        }
    }

    public char get(char c) {
        char c2 = '\u0000';
        int n = c >> 8;
        int n2 = c & 0xFF;
        char[] cArray = this.data[n];
        if (cArray != null) {
            c2 = cArray[n2];
        }
        return c2;
    }

    public char get(char c, int n) {
        return this.get(c);
    }

    public String getName() {
        return this.fontName;
    }

    public String getFontPath() {
        return this.fontPath;
    }

    public Font getFont(int n, int n2) {
        return this.referenceFont != null ? this.referenceFont.deriveFont(n, n2) : null;
    }

    protected boolean forceMapping() {
        return false;
    }

    public static int getForceMappingIndex(String string) {
        int n = -1;
        if (overrideIndexer != null) {
            int n2 = string.length();
            for (int i = 0; i < n2; ++i) {
                char c = string.charAt(i);
                if (overrideIndexer.get(c) == '\u0000') continue;
                n = i;
                break;
            }
        }
        return n;
    }
}

