/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.exception;

import com.maplesoft.util.WmiException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class WmiErrorLog
extends JDialog {
    private static final int DEFAULT_TIMESTAMP_WIDTH = 70;
    private static final int DEFAULT_ERROR_WIDTH = 500;
    private static final int DEFAULT_ROW_HEIGHT = 20;
    private static final int DEFAULT_ROW_COUNT = 5;
    public static final int POPUP_ON_ERROR = 0;
    public static final int DUMP_STACK_ON_ERROR = 1;
    public static final int CONSUME_ON_ERROR = 2;
    private static boolean displayError = false;
    private JScrollPane listPane;
    private JScrollPane exceptionPane;
    private JSplitPane splitter;
    private JTable exceptionList;
    private JTextArea exceptionDescription;
    private JPanel buttonPanel;
    private int nRows = 5;
    private static WmiErrorLog instance = null;
    private static ArrayList logData = new ArrayList();
    private static int verbosity = 0;

    private WmiErrorLog() {
        this.createTable();
        this.createDescriptionField();
        this.createButtonPanel();
        this.splitter = new JSplitPane(0, this.listPane, this.exceptionPane);
        this.getContentPane().add((Component)this.splitter, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.validate();
        this.pack();
        this.setModal(true);
    }

    private void createTable() {
        this.listPane = new JScrollPane();
        this.exceptionList = new WmiExceptionListTable();
        this.listPane.getViewport().add(this.exceptionList);
        this.exceptionList.setAutoCreateColumnsFromModel(false);
        this.exceptionList.getTableHeader().setReorderingAllowed(false);
        this.exceptionList.setAutoResizeMode(3);
        WmiErrorLogModel wmiErrorLogModel = new WmiErrorLogModel();
        this.exceptionList.setModel(wmiErrorLogModel);
        this.exceptionList.setRowHeight(20);
        TableColumn tableColumn = new TableColumn(0);
        tableColumn.setHeaderValue("timestamp");
        tableColumn.setPreferredWidth(70);
        tableColumn.setCellRenderer(new DefaultTableCellRenderer());
        TableColumn tableColumn2 = new TableColumn(1);
        tableColumn2.setHeaderValue("error");
        tableColumn2.setPreferredWidth(500);
        tableColumn2.setCellRenderer(new DefaultTableCellRenderer());
        this.exceptionList.addColumn(tableColumn);
        this.exceptionList.addColumn(tableColumn2);
        this.listPane.setPreferredSize(new Dimension(570, 120));
        this.exceptionList.setSelectionMode(0);
    }

    private void createDescriptionField() {
        this.exceptionPane = new JScrollPane();
        this.exceptionDescription = new JTextArea(15, 60);
        this.exceptionPane.getViewport().add(this.exceptionDescription);
        this.exceptionDescription.setEditable(false);
    }

    private void createButtonPanel() {
        this.buttonPanel = new JPanel();
        JButton jButton = new JButton("continue");
        JButton jButton2 = new JButton("abort");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WmiErrorLog.this.dispose();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        this.buttonPanel.add(jButton2);
        this.buttonPanel.add(jButton);
    }

    public static WmiErrorLog getInstance() {
        if (instance == null) {
            instance = new WmiErrorLog();
        }
        return instance;
    }

    public static void log(Exception exception) {
        if (displayError) {
            if (verbosity == 0) {
                SwingUtilities.invokeLater(new WmiPendingLog(exception));
            } else if (verbosity == 1) {
                exception.printStackTrace();
            }
        } else {
            exception.printStackTrace();
        }
    }

    private static void logPopup(Exception exception) {
        WmiErrorLog wmiErrorLog = WmiErrorLog.getInstance();
        WmiLogData wmiLogData = new WmiLogData(exception);
        if (logData.size() >= wmiErrorLog.nRows) {
            ++wmiErrorLog.nRows;
        }
        logData.add(wmiLogData);
        int n = logData.size() - 1;
        wmiErrorLog.exceptionList.changeSelection(n, 1, false, false);
        wmiErrorLog.pack();
        wmiErrorLog.show();
    }

    public static void setVerbosity(int n) {
        verbosity = n;
    }

    public static void enableLogging(boolean bl) {
        displayError = bl;
    }

    protected class WmiExceptionListTable
    extends JTable {
        protected WmiExceptionListTable() {
        }

        public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
            WmiLogData wmiLogData;
            super.changeSelection(n, n2, bl, bl2);
            WmiLogData wmiLogData2 = wmiLogData = n < logData.size() ? (WmiLogData)logData.get(n) : null;
            if (wmiLogData != null) {
                WmiErrorLog.this.exceptionDescription.setText(wmiLogData.description);
            } else {
                WmiErrorLog.this.exceptionDescription.setText("");
            }
        }
    }

    protected class WmiErrorLogModel
    extends AbstractTableModel {
        private static final int FIXED_COLUMN_COUNT = 2;

        protected WmiErrorLogModel() {
        }

        public int getRowCount() {
            return WmiErrorLog.this.nRows;
        }

        public int getColumnCount() {
            return 2;
        }

        public Object getValueAt(int n, int n2) {
            WmiLogData wmiLogData;
            String string = null;
            if (n < logData.size() && (wmiLogData = (WmiLogData)logData.get(n)) != null) {
                switch (n2) {
                    case 0: {
                        string = wmiLogData.time;
                        break;
                    }
                    case 1: {
                        string = wmiLogData.exception;
                        break;
                    }
                }
            }
            return string;
        }

        public String getColumnName(int n) {
            return WmiErrorLog.this.exceptionList.getColumnName(n);
        }
    }

    protected static class WmiLogData {
        protected String time;
        protected String exception;
        protected String description;

        protected WmiLogData(Exception exception) {
            String string;
            Calendar calendar = Calendar.getInstance();
            String string2 = Integer.toString(calendar.get(10));
            String string3 = Integer.toString(calendar.get(12));
            if (string3.length() < 2) {
                string3 = "0" + string3;
            }
            if ((string = Integer.toString(calendar.get(13))).length() < 2) {
                string = "0" + string;
            }
            String string4 = calendar.get(9) == 0 ? " AM" : " PM";
            this.time = string2 + ":" + string3 + ":" + string + string4;
            this.exception = exception instanceof WmiException ? exception.getMessage() : exception.toString();
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            this.description = stringWriter.toString();
        }
    }

    protected static class WmiPendingLog
    implements Runnable {
        private Exception e;

        protected WmiPendingLog(Exception exception) {
            this.e = exception;
        }

        public void run() {
            WmiErrorLog.logPopup(this.e);
        }
    }
}

