/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.view.palettes;

import com.maplesoft.mathdoc.components.dockingtools.WmiConfigurablePalette;
import com.maplesoft.mathdoc.components.dockingtools.WmiDockableCardButtonPane;
import com.maplesoft.mathdoc.components.dockingtools.WmiDockingHost;
import com.maplesoft.mathdoc.util.WmiResourcePackage;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class WmiPaletteManager {
    public static final String ERR_STRING_PROPERTY = "error.missingresource";
    public static final String MISSING_RESOURCE_TITLE_PROPERTY = "error.missingresource.title";
    public static final String FILE_NAME_PATTERN = "_RESOURCENAME_";
    public static final String KEY_NAME_PATTERN = "_RESOURCEKEY_";
    public static final String DOCK_MENU_NAME_PROPERTY = "menu.dock.name";
    public static final String PALETTE_POPUP_MENU_NAME_PROPERTY = "menu.popup.palette.name";
    public static final String PALETTE_COUNT_PROPERTY = "palette.count";
    public static final String PALETTE_PATH_PROPERTY = "palette.path";
    public static final String PALETTE_PREFIX = "palette";
    public static final String RESOURCE_SUFFIX = ".resource";
    public static final String PALETTE_MENU_NAME_PROPERTY = "palette.menuname";
    public static final String PALETTE_BUTTON_HIGHLIGHT_PROPERTY = "palette.selected.highlight";
    public static final String PALETTE_BUTTON_HIGHLIGHT_COLOR_PROPERTY = "palette.selected.color";
    public static final String PALETTE_BUTTON_UNHIGHLIGHT_COLOR_PROPERTY = "palette.deselected.color";
    public static final String DEFAULT_HIGHLIGHT_DISABLED = "false";
    public static final String DEFAULT_HIGHLIGHT_COLOR = "0 0 255";
    public static final String DEFAULT_UNHIGHLIGHT_COLOR = "0 0 0";
    public static final String[] DIRECTIONS_PROPERTY_NAMES = new String[]{"direction.name.north", "direction.name.south", "direction.name.east", "direction.name.west"};
    public static String DIRECTION_COMMAND_SEPARATOR = "-";
    public static String DIRECTION_COMMAND_SEPARATOR_PROPERTY = "direction.command.separator";
    public static final String[] INTERNAL_DIRECTIONS = new String[]{"North", "South", "East", "West"};
    public String[] DIRECTIONS = new String[DIRECTIONS_PROPERTY_NAMES.length];
    public HashMap directionToIndex = new HashMap();
    public WmiResourcePackage manifest;
    public int numPalettes = -1;
    public String palettePath;
    protected Vector paletteNameList = null;
    public WmiConfigurablePalette[] palettes = null;
    public HashMap paletteToViewCommands = new HashMap();
    public HashMap paletteToMainViewCommands = new HashMap();
    public HashMap paletteMapForHost = new HashMap();
    public HashMap paletteToName = new HashMap();
    public String dockMenuName = null;
    public String paletteMenuName = null;

    public WmiPaletteManager() {
        this("", "");
    }

    public WmiPaletteManager(String string, String string2) {
        this.manifest = WmiResourcePackage.getResourcePackage(string);
        for (int i = 0; i < DIRECTIONS_PROPERTY_NAMES.length; ++i) {
            this.DIRECTIONS[i] = this.manifest.getStringForKey(DIRECTIONS_PROPERTY_NAMES[i]);
            this.directionToIndex.put(this.DIRECTIONS[i], new Integer(i));
        }
        DIRECTION_COMMAND_SEPARATOR = this.manifest.getStringForKey(DIRECTION_COMMAND_SEPARATOR_PROPERTY);
        this.configurePaletteHighlights();
    }

    public int getNumberOfPalettes() {
        if (this.numPalettes < 0) {
            try {
                this.numPalettes = Integer.parseInt(this.manifest.getStringForKey(PALETTE_COUNT_PROPERTY));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.numPalettes;
    }

    public int getDirectionIndex(String string) {
        int n = 0;
        if (this.directionToIndex.containsKey(string)) {
            n = (Integer)this.directionToIndex.get(string);
        }
        return n;
    }

    public void disposePalettes() {
        this.paletteToViewCommands = new HashMap();
        this.paletteToMainViewCommands = new HashMap();
        this.paletteMapForHost = new HashMap();
    }

    public String getDockMenuName() {
        if (this.dockMenuName == null) {
            this.dockMenuName = this.manifest.getStringForKey(DOCK_MENU_NAME_PROPERTY);
        }
        return this.dockMenuName;
    }

    public String getPaletteMenuName() {
        if (this.paletteMenuName == null) {
            this.paletteMenuName = this.manifest.getStringForKey(PALETTE_POPUP_MENU_NAME_PROPERTY);
        }
        return this.paletteMenuName;
    }

    public String getPalettePath() {
        this.palettePath = this.palettePath == null ? this.manifest.getStringForKey(PALETTE_PATH_PROPERTY) : this.palettePath;
        return this.palettePath;
    }

    public List getPaletteNames() {
        if (this.paletteNameList == null) {
            this.paletteNameList = new Vector();
            int n = this.getNumberOfPalettes();
            for (int i = 0; i < n; ++i) {
                String string = this.manifest.getStringForKey(PALETTE_PREFIX + i + RESOURCE_SUFFIX);
                this.paletteNameList.add(string);
            }
        }
        return this.paletteNameList;
    }

    public List getPaletteMenuDisplayNames() {
        int n = this.getNumberOfPalettes();
        List list = this.getPaletteNames();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < n; ++i) {
            WmiResourcePackage wmiResourcePackage = WmiResourcePackage.getResourcePackage(this.getPalettePath() + list.get(i));
            vector.add(wmiResourcePackage.getStringForKey(PALETTE_MENU_NAME_PROPERTY));
        }
        return vector;
    }

    public Iterator getPalettesForHost(WmiDockingHost wmiDockingHost) {
        Iterator<Object> iterator = null;
        HashMap hashMap = (HashMap)this.paletteMapForHost.get(wmiDockingHost);
        if (hashMap == null) {
            List list = this.getPaletteNames();
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                this.createPalette(iterator2.next().toString(), wmiDockingHost);
            }
            hashMap = (HashMap)this.paletteMapForHost.get(wmiDockingHost);
        }
        iterator = hashMap != null ? hashMap.values().iterator() : new ArrayList(0).iterator();
        return iterator;
    }

    public WmiConfigurablePalette createPalette(String string, WmiDockingHost wmiDockingHost) {
        String string2 = this.getPalettePath() + string;
        WmiConfigurablePalette wmiConfigurablePalette = null;
        HashMap hashMap = null;
        if (this.paletteMapForHost.containsKey(wmiDockingHost)) {
            hashMap = (HashMap)this.paletteMapForHost.get(wmiDockingHost);
        } else {
            hashMap = new HashMap();
            this.paletteMapForHost.put(wmiDockingHost, hashMap);
        }
        if (hashMap.containsKey(string2)) {
            wmiConfigurablePalette = (WmiConfigurablePalette)hashMap.get(string2);
        }
        return wmiConfigurablePalette;
    }

    public void releasePaletteHost(WmiDockingHost wmiDockingHost) {
        this.paletteMapForHost.remove(wmiDockingHost);
    }

    public void configurePaletteHighlights() {
        String string = DEFAULT_HIGHLIGHT_DISABLED;
        String string2 = DEFAULT_HIGHLIGHT_COLOR;
        String string3 = DEFAULT_UNHIGHLIGHT_COLOR;
        try {
            string = this.manifest.getStringForKey(PALETTE_BUTTON_HIGHLIGHT_PROPERTY);
            string2 = this.manifest.getStringForKey(PALETTE_BUTTON_HIGHLIGHT_COLOR_PROPERTY);
            string3 = this.manifest.getStringForKey(PALETTE_BUTTON_UNHIGHLIGHT_COLOR_PROPERTY);
        }
        catch (Exception exception) {
            string = DEFAULT_HIGHLIGHT_DISABLED;
            string2 = DEFAULT_HIGHLIGHT_COLOR;
            string3 = DEFAULT_UNHIGHLIGHT_COLOR;
        }
        string = string == null ? DEFAULT_HIGHLIGHT_DISABLED : string;
        WmiDockableCardButtonPane.setButtonHighlightEnabled(!string.equals(DEFAULT_HIGHLIGHT_DISABLED));
        Color color = this.getColorFromString(string2);
        color = color == null ? this.getColorFromString(DEFAULT_HIGHLIGHT_COLOR) : color;
        WmiDockableCardButtonPane.setButtonHighlightColor(color);
        Color color2 = this.getColorFromString(string3);
        color2 = color2 == null ? this.getColorFromString(DEFAULT_UNHIGHLIGHT_COLOR) : color2;
        WmiDockableCardButtonPane.setButtonUnHighlightColor(color2);
    }

    private Color getColorFromString(String string) {
        Color color = null;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            color = new Color(n, n2, n3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return color;
    }
}

