/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.navigation;

import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.controller.navigation.WmiNavigationCommand;
import com.maplesoft.mathdoc.controller.navigation.WmiViewNavigator;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPosition;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;

public abstract class WmiMovePageCommand
extends WmiNavigationCommand {
    protected WmiMovePageCommand(String string) {
        super(string);
    }

    public void doCommand(ActionEvent actionEvent) throws WmiNoReadAccessException {
        WmiView wmiView = WmiMovePageCommand.getView(actionEvent);
        if (wmiView != null) {
            Object object;
            WmiMathDocumentView wmiMathDocumentView = wmiView.getDocumentView();
            Rectangle rectangle = wmiMathDocumentView.getVisibleRegion();
            int n = 0;
            int n2 = 0;
            boolean bl = false;
            if (!RuntimePlatform.isMac() || this.isSelectionCommand()) {
                object = wmiMathDocumentView.getPositionMarker();
                if (object != null) {
                    bl = true;
                    Rectangle rectangle2 = object.getBounds();
                    n = rectangle2.x + rectangle2.width / 2;
                    n2 = this.getDirection() < 0 ? rectangle2.y - rectangle.height : rectangle2.y + rectangle2.height + rectangle.height;
                }
            } else {
                bl = true;
                n = rectangle.x;
                int n3 = n2 = this.getDirection() < 0 ? rectangle.y - rectangle.height : rectangle.y + rectangle.height;
            }
            if (bl) {
                if (n2 < 0) {
                    object = WmiCommand.getCommandProxy(this.isSelectionCommand() ? "select.document.start" : "move.document.start");
                    try {
                        ((WmiCommand)object).doCommand(actionEvent);
                    }
                    catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
                        WmiErrorLog.log(wmiNoWriteAccessException);
                    }
                    bl = false;
                } else if (n2 > wmiMathDocumentView.getHeight()) {
                    object = WmiCommand.getCommandProxy(this.isSelectionCommand() ? "select.document.end" : "move.document.end");
                    try {
                        ((WmiCommand)object).doCommand(actionEvent);
                    }
                    catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
                        WmiErrorLog.log(wmiNoWriteAccessException);
                    }
                    bl = false;
                }
                if (bl) {
                    if (!RuntimePlatform.isMac() || this.isSelectionCommand()) {
                        this.moveTo(wmiMathDocumentView, n, n2);
                    } else {
                        wmiMathDocumentView.setScrollPosition(n, n2, true);
                    }
                }
            }
        }
    }

    private void moveTo(WmiMathDocumentView wmiMathDocumentView, int n, int n2) throws WmiNoReadAccessException {
        WmiViewPosition wmiViewPosition = WmiViewUtil.findNearestView(wmiMathDocumentView, new Point(n, n2));
        WmiViewNavigator wmiViewNavigator = new WmiViewNavigator(wmiViewPosition.getView(), wmiViewPosition.getOffset(), this.isSelectionCommand());
        wmiViewNavigator.updateMarker();
    }

    protected abstract int getDirection();

    public boolean updatePosition(WmiViewNavigator wmiViewNavigator) throws WmiNoReadAccessException {
        return false;
    }
}

