/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.insert;

import com.maplesoft.mathdoc.controller.insert.MathInsertUtil;
import com.maplesoft.mathdoc.controller.insert.WmiInsertGenericMathCommand;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.MathTokenizer;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiView;
import java.awt.Toolkit;
import java.util.ArrayList;

public class WmiInsertTokenCommand
extends WmiInsertGenericMathCommand {
    private static WmiModelTag[] INVALID_NEWLINE_PARENTS = new WmiModelTag[]{WmiModelTag.MATH_SUBSCRIPT, WmiModelTag.MATH_SUPERSCRIPT, WmiModelTag.MATH_SUB_SUP, WmiModelTag.MATH_SQUARE_ROOT, WmiModelTag.MATH_MULTISCRIPTS, WmiModelTag.MATH_FRAC, WmiModelTag.MATH_TABLE, WmiModelTag.MATH_FENCED};
    public static WmiInsertTokenCommand INSTANCE;
    public static WmiInsertTokenCommand DEFAULT_TOKEN_INSERTER;

    public WmiInsertTokenCommand(String string) {
        super(string);
    }

    public WmiInsertTokenCommand(String string, boolean bl) {
        super(string, bl);
    }

    public static final void insertAndUpdate(char c, WmiView wmiView, String string) throws WmiModelIndexOutOfBoundsException, WmiNoReadAccessException, WmiNoUpdateAccessException, WmiNoWriteAccessException {
        WmiMathDocumentView wmiMathDocumentView = wmiView.getDocumentView();
        WmiMathDocumentModel wmiMathDocumentModel = (WmiMathDocumentModel)wmiMathDocumentView.getModel();
        WmiPositionMarker wmiPositionMarker = wmiMathDocumentView.getPositionMarker();
        if (wmiPositionMarker != null && wmiPositionMarker.getModelPosition() != null) {
            WmiInsertTokenCommand.insertAndUpdate(c, wmiPositionMarker, wmiMathDocumentView.getSelection(), wmiMathDocumentModel, wmiMathDocumentView, string);
        }
    }

    public static final void insertAndUpdate(char c, WmiPositionMarker wmiPositionMarker, WmiSelection wmiSelection, WmiMathDocumentModel wmiMathDocumentModel, WmiMathDocumentView wmiMathDocumentView, String string) throws WmiModelIndexOutOfBoundsException, WmiNoReadAccessException, WmiNoUpdateAccessException, WmiNoWriteAccessException {
        boolean bl = true;
        if (wmiSelection != null) {
            WmiModel[] wmiModelArray = new WmiModel[2];
            int[] nArray = new int[2];
            wmiSelection.getModelInterval(wmiModelArray, nArray);
            WmiCompositeModel wmiCompositeModel = WmiModelUtil.findAncestorOfTag(wmiModelArray[0], WmiModelTag.MATH_TABLE_CELL);
            WmiCompositeModel wmiCompositeModel2 = WmiModelUtil.findAncestorOfTag(wmiModelArray[1], WmiModelTag.MATH_TABLE_CELL);
            WmiCompositeModel wmiCompositeModel3 = WmiModelUtil.findAncestorOfTag(wmiModelArray[0], WmiModelTag.MATH);
            WmiCompositeModel wmiCompositeModel4 = WmiModelUtil.findAncestorOfTag(wmiModelArray[1], WmiModelTag.MATH);
            if (wmiCompositeModel != null && wmiCompositeModel2 != wmiCompositeModel) {
                bl = false;
            } else if (wmiCompositeModel2 != null && wmiCompositeModel2 != wmiCompositeModel) {
                bl = false;
            }
            if (wmiCompositeModel3 != wmiCompositeModel4) {
                bl = false;
            }
        }
        if (!wmiPositionMarker.isReadOnly() && bl) {
            if (string == null) {
                string = INSTANCE.getResource(5);
            }
            WmiInsertTokenCommand.insertMathToken(Character.toString(c), wmiMathDocumentView, string, false);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public static void insertComposedText(String string, WmiMathDocumentView wmiMathDocumentView, String string2) {
        WmiInsertTokenCommand.insertMathToken(string, wmiMathDocumentView, string2, true);
    }

    public static WmiTextModel createComposedText(WmiMathDocumentView wmiMathDocumentView, String string) {
        return WmiInsertTokenCommand.insertMathToken("", wmiMathDocumentView, string, true);
    }

    public static void insertMathToken(char c, WmiMathDocumentView wmiMathDocumentView, String string) {
        WmiInsertTokenCommand.insertMathToken(Character.toString(c), wmiMathDocumentView, string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WmiTextModel insertMathToken(String string, WmiMathDocumentView wmiMathDocumentView, String string2, boolean bl) {
        WmiPositionMarker wmiPositionMarker = wmiMathDocumentView.getPositionMarker();
        boolean bl2 = string2 != null;
        WmiModel wmiModel = null;
        if (wmiPositionMarker != null) {
            WmiMathDocumentModel wmiMathDocumentModel = (WmiMathDocumentModel)wmiMathDocumentView.getModel();
            try {
                WmiModelLock.writeLock(wmiMathDocumentModel, true);
                if (bl2) {
                    wmiMathDocumentModel.startUndoableEdit(string2);
                }
                if (WmiInsertTokenCommand.isStringInsert(wmiMathDocumentView)) {
                    WmiInsertTokenCommand.performStringInsert(wmiMathDocumentView, string);
                    WmiPositionedView wmiPositionedView = wmiPositionMarker.getView();
                    if (wmiPositionedView != null) {
                        wmiModel = wmiPositionedView.getModel();
                    }
                } else {
                    Object object;
                    Object object2;
                    int n = 0;
                    WmiModelPosition wmiModelPosition = MathInsertUtil.deleteMathSelection(wmiMathDocumentView);
                    WmiSelection wmiSelection = wmiMathDocumentView.getSelection();
                    Object var11_16 = null;
                    if (wmiSelection != null) {
                        object2 = new WmiModel[2];
                        object = new int[2];
                        wmiSelection.getModelInterval((WmiModel[])object2, (int[])object);
                    }
                    wmiModelPosition = wmiModelPosition == null ? MathInsertUtil.updateInsertionPoint(wmiPositionMarker, 0) : MathInsertUtil.updateInsertionPoint(wmiModelPosition, 0);
                    if ("\n".equals(string)) {
                        wmiModelPosition = WmiInsertTokenCommand.updatePositionForSoftReturn(wmiModelPosition);
                    }
                    MathInsertUtil.ensureParentMathRow(wmiModelPosition);
                    object2 = new ArrayList();
                    wmiModelPosition = MathInsertUtil.insertEmptyPlaceholder(wmiModelPosition, (ArrayList)object2);
                    wmiModel = wmiModelPosition.getModel();
                    n = wmiModelPosition.getOffset();
                    ((WmiTextModel)wmiModel).insertText(string, n);
                    object = (WmiFontAttributeSet)wmiModel.getAttributes();
                    wmiModelPosition = !((WmiFontAttributeSet)object).isComposed() && !bl ? MathTokenizer.retokenize((WmiTextModel)wmiModel, ((WmiTextModel)wmiModel).getLength()) : new WmiModelPosition(wmiModel, ((WmiTextModel)wmiModel).getLength());
                    wmiMathDocumentView.setPendingPosition(wmiModelPosition);
                }
                wmiMathDocumentModel.update(string2);
                if (bl2) {
                    wmiMathDocumentModel.endUndoableEdit();
                }
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
            catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
                WmiErrorLog.log(wmiNoWriteAccessException);
            }
            catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
            }
            catch (WmiNoUpdateAccessException wmiNoUpdateAccessException) {
                WmiErrorLog.log(wmiNoUpdateAccessException);
            }
            finally {
                WmiModelLock.writeUnlock(wmiMathDocumentModel);
            }
        }
        return wmiModel instanceof WmiTextModel ? (WmiTextModel)wmiModel : null;
    }

    private static WmiModelPosition updatePositionForSoftReturn(WmiModelPosition wmiModelPosition) throws WmiNoReadAccessException {
        WmiModel wmiModel = wmiModelPosition.getModel();
        WmiCompositeModel wmiCompositeModel = WmiModelUtil.findAncestorOfTag(wmiModel, INVALID_NEWLINE_PARENTS);
        boolean bl = false;
        while (wmiCompositeModel != null) {
            bl = true;
            wmiModel = wmiCompositeModel;
            wmiCompositeModel = WmiModelUtil.findAncestorOfTag(wmiModel, INVALID_NEWLINE_PARENTS);
        }
        if (bl) {
            wmiModelPosition = new WmiModelPosition(wmiModel, -1);
        }
        return wmiModelPosition;
    }

    static {
        DEFAULT_TOKEN_INSERTER = INSTANCE = new WmiInsertTokenCommand("Insert.Token");
    }
}

