/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.edit;

import com.maplesoft.mathdoc.controller.insert.MathInsertUtil;
import com.maplesoft.mathdoc.controller.insert.WmiInsertGenericMathCommand;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiDeleteManager;
import com.maplesoft.mathdoc.model.WmiDeletePlaceholderModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.MathTokenizer;
import com.maplesoft.mathdoc.model.math.WmiIdentifierModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathFencedModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathMultiscriptModel;
import com.maplesoft.mathdoc.model.math.WmiMathPhantomModel;
import com.maplesoft.mathdoc.model.math.WmiMathSpaceModel;
import com.maplesoft.mathdoc.model.math.WmiMathStringModel;
import com.maplesoft.mathdoc.model.math.WmiMathTableModel;
import com.maplesoft.mathdoc.model.math.WmiNumericModel;
import com.maplesoft.mathdoc.model.math.WmiRootModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiTextView;
import java.util.ArrayList;
import java.util.HashSet;

public class WmiMathDeleteUtil {
    private static HashSet PROMOTABLE_MODELS = new HashSet();

    private WmiMathDeleteUtil() {
    }

    public static boolean isMathSelectionDelete(WmiMathDocumentView wmiMathDocumentView) throws WmiNoReadAccessException {
        WmiCompositeModel wmiCompositeModel;
        WmiCompositeModel wmiCompositeModel2;
        boolean bl = false;
        WmiSelection wmiSelection = wmiMathDocumentView.getSelection();
        WmiModel[] wmiModelArray = null;
        int[] nArray = null;
        if (wmiSelection != null && wmiSelection.getModelInterval(wmiModelArray = new WmiModel[2], nArray = new int[2]) && (wmiCompositeModel2 = WmiModelUtil.findAncestorOfTag(wmiModelArray[0], WmiModelTag.MATH)) == (wmiCompositeModel = WmiModelUtil.findAncestorOfTag(wmiModelArray[1], WmiModelTag.MATH)) && wmiCompositeModel2 != null) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteMathSelection(WmiMathDocumentView wmiMathDocumentView, String string) throws WmiNoReadAccessException {
        boolean bl = false;
        WmiMathDocumentModel wmiMathDocumentModel = (WmiMathDocumentModel)wmiMathDocumentView.getModel();
        try {
            WmiModelPosition wmiModelPosition;
            WmiModelLock.writeLock(wmiMathDocumentModel, true);
            WmiSelection wmiSelection = wmiMathDocumentView.getSelection();
            WmiModel[] wmiModelArray = new WmiModel[2];
            int[] nArray = new int[2];
            wmiSelection.getModelInterval(wmiModelArray, nArray);
            boolean bl2 = true;
            if (!(wmiModelArray[0] == null || wmiModelArray[1] == null || wmiMathDocumentModel.isMutableModel(wmiModelArray[0]) && wmiMathDocumentModel.isMutableModel(wmiModelArray[1]))) {
                bl2 = false;
            }
            if (bl2 && wmiModelArray[0] == wmiModelArray[1] && wmiModelArray[0] instanceof WmiTextModel) {
                if (nArray[1] > nArray[0]) {
                    WmiTextModel wmiTextModel = (WmiTextModel)wmiModelArray[0];
                    wmiTextModel.deleteText(nArray[0], nArray[1] - nArray[0]);
                    WmiModelPosition wmiModelPosition2 = MathTokenizer.retokenize(wmiTextModel, nArray[0]);
                    wmiMathDocumentView.setPendingPosition(wmiModelPosition2);
                    wmiMathDocumentModel.update(string);
                    bl = true;
                }
            } else if (bl2 && !WmiMathDeleteUtil.isMultiTableCellDelete(wmiModelArray) && (wmiModelPosition = MathInsertUtil.wrapSelection(wmiMathDocumentView)) != null) {
                int n;
                WmiModel wmiModel = wmiModelPosition.getModel();
                WmiCompositeModel wmiCompositeModel = wmiModel.getParent();
                int n2 = n = wmiCompositeModel != null ? wmiCompositeModel.indexOf(wmiModel) : -1;
                if (n >= 0) {
                    WmiFontAttributeSet wmiFontAttributeSet = wmiMathDocumentModel.getActiveEditAttributes();
                    if (wmiFontAttributeSet != null) {
                        wmiFontAttributeSet = (WmiFontAttributeSet)wmiFontAttributeSet.copyAttributes();
                    }
                    WmiTextModel wmiTextModel = new WmiTextModel(wmiMathDocumentModel, "", wmiFontAttributeSet);
                    wmiCompositeModel.replaceChild(wmiTextModel, n);
                    wmiModelPosition = MathTokenizer.retokenize(wmiTextModel, 0);
                    wmiMathDocumentView.setPendingPosition(wmiModelPosition);
                }
                wmiMathDocumentModel.update(string);
                bl = true;
            }
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
        }
        catch (WmiNoUpdateAccessException wmiNoUpdateAccessException) {
            WmiErrorLog.log(wmiNoUpdateAccessException);
        }
        finally {
            WmiModelLock.writeUnlock(wmiMathDocumentModel);
        }
        return bl;
    }

    public static boolean isMathDelete(WmiMathDocumentView wmiMathDocumentView) throws WmiNoReadAccessException {
        WmiMathDocumentModel wmiMathDocumentModel;
        WmiModel wmiModel;
        boolean bl = false;
        WmiSelection wmiSelection = wmiMathDocumentView.getSelection();
        WmiPositionMarker wmiPositionMarker = wmiMathDocumentView.getPositionMarker();
        WmiPositionedView wmiPositionedView = wmiPositionMarker != null ? wmiPositionMarker.getView() : null;
        WmiModel wmiModel2 = wmiModel = wmiPositionedView != null ? wmiPositionedView.getModel() : null;
        if (wmiModel != null && wmiSelection == null && (wmiMathDocumentModel = wmiModel.getDocument()).isMutableModel(wmiModel)) {
            boolean bl2 = bl = WmiModelUtil.findAncestorOfTag(wmiModel, WmiModelTag.MATH) != null;
            if (bl) {
                bl = !WmiMathDeleteUtil.isEmptyMath(wmiModel);
            }
        }
        return bl;
    }

    public static boolean isEmptyMath(WmiModel wmiModel) throws WmiNoReadAccessException {
        boolean bl = false;
        if (wmiModel != null) {
            WmiCompositeModel wmiCompositeModel = null;
            wmiCompositeModel = wmiModel.getTag() == WmiModelTag.MATH ? (WmiCompositeModel)wmiModel : WmiModelUtil.findAncestorOfTag(wmiModel, WmiModelTag.MATH);
            bl = wmiCompositeModel != null ? !WmiMathDeleteUtil.hasContent(wmiCompositeModel) : true;
        }
        return bl;
    }

    private static boolean hasContent(WmiCompositeModel wmiCompositeModel) throws WmiNoReadAccessException {
        boolean bl = false;
        int n = wmiCompositeModel != null ? wmiCompositeModel.getChildCount() : 0;
        for (int i = 0; i < n; ++i) {
            WmiModel wmiModel = wmiCompositeModel.getChild(i);
            if (wmiModel != null && wmiModel.getTag() == WmiModelTag.MATH_ROW) {
                bl = WmiMathDeleteUtil.hasContent((WmiCompositeModel)wmiModel);
            } else if (wmiModel instanceof WmiTextModel) {
                if (((WmiTextModel)wmiModel).getLength() > 0) {
                    bl = true;
                }
            } else {
                bl = true;
            }
            if (bl) break;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteInMath(WmiMathDocumentView wmiMathDocumentView, String string, int n) throws WmiNoReadAccessException {
        boolean bl = false;
        WmiPositionMarker wmiPositionMarker = wmiMathDocumentView.getPositionMarker();
        WmiPositionedView wmiPositionedView = wmiPositionMarker != null ? wmiPositionMarker.getView() : null;
        WmiModel wmiModel = wmiPositionedView != null ? wmiPositionedView.getModel() : null;
        WmiSelection wmiSelection = wmiMathDocumentView.getSelection();
        if (wmiModel != null && wmiSelection == null) {
            int n2;
            int n3 = wmiPositionMarker.getOffset();
            if (wmiPositionedView instanceof WmiTextView && n3 >= 0) {
                n3 += ((WmiTextView)wmiPositionedView).getStartOffset();
            }
            WmiModelPosition wmiModelPosition = new WmiModelPosition(wmiModel, n3);
            int n4 = n2 = n > 0 ? 1 : -1;
            if (n2 == 1 || !MathTokenizer.isLinebreakingMSpace(wmiModel)) {
                wmiModelPosition = MathInsertUtil.updateInsertionPoint(wmiModelPosition, n2);
            }
            if (wmiModelPosition != null) {
                wmiModel = wmiModelPosition.getModel();
                WmiCompositeModel wmiCompositeModel = WmiModelUtil.findAncestorOfTag(wmiModel, WmiModelTag.MATH_PHANTOM);
                if (wmiCompositeModel != null) {
                    wmiModelPosition = new WmiModelPosition(wmiCompositeModel, 0);
                }
                wmiModelPosition = WmiMathDeleteUtil.expandMathFences(wmiModelPosition, n);
                bl = WmiMathDeleteUtil.deleteInMath(wmiMathDocumentView, wmiModelPosition = WmiMathDeleteUtil.expandMathString(wmiModelPosition, n), true, n);
                if (bl) {
                    WmiMathDocumentModel wmiMathDocumentModel = (WmiMathDocumentModel)wmiMathDocumentView.getModel();
                    WmiModelLock.writeLock(wmiMathDocumentModel, true);
                    try {
                        wmiMathDocumentModel.update(string);
                    }
                    catch (WmiNoUpdateAccessException wmiNoUpdateAccessException) {
                        WmiErrorLog.log(wmiNoUpdateAccessException);
                    }
                    finally {
                        WmiModelLock.writeUnlock(wmiMathDocumentModel);
                    }
                }
            }
        }
        return bl;
    }

    private static boolean isMultiTableCellDelete(WmiModel[] wmiModelArray) throws WmiNoReadAccessException {
        boolean bl = false;
        WmiCompositeModel wmiCompositeModel = WmiModelUtil.findAncestorOfTag(wmiModelArray[0], WmiModelTag.MATH_TABLE_CELL);
        WmiCompositeModel wmiCompositeModel2 = WmiModelUtil.findAncestorOfTag(wmiModelArray[1], WmiModelTag.MATH_TABLE_CELL);
        bl = wmiCompositeModel2 != wmiCompositeModel;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean deleteInMath(WmiMathDocumentView wmiMathDocumentView, WmiModelPosition wmiModelPosition, boolean bl, int n) throws WmiNoReadAccessException {
        WmiMathDocumentModel wmiMathDocumentModel;
        boolean bl2 = false;
        WmiModel wmiModel = wmiModelPosition.getModel();
        int n2 = wmiModelPosition.getOffset();
        WmiMathDocumentModel wmiMathDocumentModel2 = wmiMathDocumentModel = wmiModel != null ? wmiModel.getDocument() : null;
        if (wmiMathDocumentModel == null) {
            return false;
        }
        try {
            WmiModelLock.writeLock(wmiMathDocumentModel, true);
            if (wmiModel instanceof WmiMathPhantomModel) {
                bl2 = WmiMathDeleteUtil.deleteModel(wmiMathDocumentView, wmiModel, n);
            } else if (wmiModel instanceof WmiMathSpaceModel) {
                bl2 = WmiMathDeleteUtil.deleteModel(wmiMathDocumentView, wmiModel, n);
            } else if (!(wmiModel instanceof WmiMathModel)) {
                bl2 = WmiMathDeleteUtil.deleteModel(wmiMathDocumentView, wmiModel, n);
            } else if (wmiModel instanceof WmiTextModel) {
                WmiTextModel wmiTextModel = (WmiTextModel)wmiModel;
                bl2 = WmiMathDeleteUtil.deleteInMathText(wmiMathDocumentView, wmiTextModel, n2, bl, n);
            } else if (wmiModel instanceof WmiRootModel && n2 == 0) {
                bl2 = WmiMathDeleteUtil.deleteMathRootModel(wmiMathDocumentView, wmiModel, n);
            } else if (wmiModel.getTag() == WmiModelTag.MATH_ROW) {
                WmiModel wmiModel2;
                WmiInlineMathModel wmiInlineMathModel = (WmiInlineMathModel)wmiModel;
                int n3 = wmiInlineMathModel.getChildCount();
                boolean bl3 = false;
                if (n3 == 0) {
                    bl3 = true;
                } else if (n3 == 1 && (wmiModel2 = wmiInlineMathModel.getChild(0)) instanceof WmiTextModel && ((WmiTextModel)wmiModel2).getLength() == 0) {
                    bl3 = true;
                }
                if (bl3) {
                    bl2 = WmiMathDeleteUtil.deleteModel(wmiMathDocumentView, wmiInlineMathModel, n);
                } else {
                    if (n2 == 0) {
                        wmiModelPosition = new WmiModelPosition(wmiInlineMathModel.getChild(0), 0);
                    } else if (n2 == -1) {
                        wmiModelPosition = new WmiModelPosition(wmiInlineMathModel.getChild(wmiInlineMathModel.getChildCount() - 1), -1);
                    } else {
                        bl = false;
                    }
                    if (bl) {
                        wmiModelPosition = WmiMathDeleteUtil.expandMathFences(wmiModelPosition, n);
                        wmiModelPosition = WmiMathDeleteUtil.expandMathString(wmiModelPosition, n);
                        bl2 = WmiMathDeleteUtil.deleteInMath(wmiMathDocumentView, wmiModelPosition, true, n);
                    }
                }
            } else if (wmiModel instanceof WmiMathMultiscriptModel) {
                int n4 = 0;
                int n5 = 0;
                boolean bl4 = true;
                WmiMathMultiscriptModel wmiMathMultiscriptModel = (WmiMathMultiscriptModel)wmiModel;
                int n6 = wmiMathMultiscriptModel.getChildCount();
                for (int i = 1; i < n6; ++i) {
                    WmiModel wmiModel3 = wmiMathMultiscriptModel.getChild(i);
                    if (wmiModel3 instanceof WmiMathMultiscriptModel.WmiMathNoneModel) continue;
                    if (wmiModel3 instanceof WmiMathMultiscriptModel.WmiMathPrescriptModel) {
                        bl4 = false;
                        continue;
                    }
                    if (bl4) {
                        n5 = i;
                        continue;
                    }
                    n4 = i;
                    break;
                }
                wmiModel = n2 == 0 ? wmiMathMultiscriptModel.getChild(n4) : wmiMathMultiscriptModel.getChild(n5);
                wmiModelPosition = new WmiModelPosition(wmiModel, n2);
                bl2 = WmiMathDeleteUtil.deleteInMath(wmiMathDocumentView, wmiModelPosition, true, n);
            } else {
                WmiModel wmiModel4;
                WmiModel wmiModel5 = null;
                while (wmiModel instanceof WmiCompositeModel) {
                    if (wmiModel == wmiModel5) {
                        wmiModel4 = wmiModel.getParent();
                        if (!(wmiModel4 instanceof WmiMathFencedModel) || wmiModel4.getChildCount() <= 1 && wmiModel instanceof WmiInlineMathModel) break;
                        ((WmiMathFencedModel)wmiModel4).convertToInlineMath(4);
                        wmiModelPosition = MathInsertUtil.updateInsertionPoint(wmiModelPosition, n < 0 ? -1 : 1);
                        bl2 = WmiMathDeleteUtil.deleteInMath(wmiMathDocumentView, wmiModelPosition, bl, n);
                        break;
                    }
                    wmiModel5 = wmiModel;
                    wmiModel4 = (WmiCompositeModel)wmiModel;
                    if (wmiModel4 instanceof WmiMathPhantomModel) {
                        bl2 = WmiMathDeleteUtil.deleteModel(wmiMathDocumentView, wmiModel4, n);
                        break;
                    }
                    if (wmiModel4 instanceof WmiMathFencedModel) {
                        wmiModelPosition = new WmiModelPosition(wmiModel4, n2);
                        wmiModelPosition = WmiMathDeleteUtil.expandMathFences(wmiModelPosition, n);
                        wmiModelPosition = WmiMathDeleteUtil.expandMathString(wmiModelPosition, n);
                        wmiModel = wmiModelPosition.getModel();
                        continue;
                    }
                    int n7 = wmiModel4.getChildCount();
                    if (n2 == 0) {
                        wmiModel = n7 > 0 ? wmiModel4.getChild(0) : null;
                        continue;
                    }
                    wmiModel = n7 > 0 ? wmiModel4.getChild(n7 - 1) : null;
                    n2 = -1;
                }
                if (wmiModel instanceof WmiTextModel) {
                    wmiModel4 = (WmiTextModel)wmiModel;
                    n2 = n > 0 ? 0 : ((WmiTextModel)wmiModel4).getLength();
                    bl2 = WmiMathDeleteUtil.deleteInMathText(wmiMathDocumentView, (WmiTextModel)wmiModel4, n2, true, n);
                }
            }
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
        }
        finally {
            WmiModelLock.writeUnlock(wmiMathDocumentModel);
        }
        return bl2;
    }

    private static boolean deleteModel(WmiMathDocumentView wmiMathDocumentView, WmiModel wmiModel, int n) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        boolean bl = false;
        WmiCompositeModel wmiCompositeModel = wmiModel.getParent();
        WmiCompositeModel wmiCompositeModel2 = wmiCompositeModel != null ? wmiCompositeModel.getParent() : null;
        int n2 = wmiCompositeModel != null ? wmiCompositeModel.indexOf(wmiModel) : -1;
        int n3 = wmiCompositeModel2 != null ? wmiCompositeModel2.indexOf(wmiCompositeModel) : -1;
        WmiModel wmiModel2 = null;
        int n4 = n < 0 ? -1 : 0;
        boolean bl2 = false;
        if (wmiCompositeModel instanceof WmiMathTableModel.WmiMathTableDataModel) {
            bl2 = true;
            bl = WmiMathDeleteUtil.deleteMathTableCell(wmiMathDocumentView, (WmiMathTableModel.WmiMathTableDataModel)wmiCompositeModel, n);
        }
        if (wmiCompositeModel != null && wmiCompositeModel.getTag() != WmiModelTag.MATH) {
            if (!bl2) {
                Object object;
                int n5;
                boolean bl3;
                WmiModel[] wmiModelArray = WmiMathDeleteUtil.getChildrenToPromote(wmiCompositeModel, n2);
                if (wmiCompositeModel.getDeleteHandler() != null) {
                    if (wmiModelArray != null) {
                        wmiCompositeModel.addChildren(wmiModelArray, n2 + 1);
                        wmiModelArray = null;
                    }
                    WmiDeletePlaceholderModel wmiDeletePlaceholderModel = new WmiDeletePlaceholderModel(wmiModel);
                    wmiCompositeModel.replaceChild(wmiDeletePlaceholderModel, n2);
                }
                boolean bl4 = bl3 = wmiModelArray == null;
                if (bl3) {
                    for (n5 = 0; n5 < wmiCompositeModel.getChildCount(); ++n5) {
                        if (n5 == n2 || (object = wmiCompositeModel.getChild(n5)).getTag() == WmiModelTag.MATH_PHANTOM) continue;
                        bl3 = false;
                        break;
                    }
                }
                if (bl3) {
                    bl = WmiMathDeleteUtil.deleteModel(wmiMathDocumentView, wmiCompositeModel, n);
                    wmiModel2 = null;
                } else if (wmiCompositeModel.getDeleteHandler() == null) {
                    n5 = wmiCompositeModel.getChildCount();
                    wmiCompositeModel.removeChild(n2);
                    if (wmiModelArray != null) {
                        wmiCompositeModel.addChildren(wmiModelArray, n2);
                    }
                    if (n4 < 0 && --n2 < 0) {
                        n2 = 0;
                        n4 = 0;
                    }
                    if (wmiModelArray != null && wmiModelArray.length > 0) {
                        n4 = 0;
                        wmiModel2 = null;
                    } else if (n5 > n2 + 1) {
                        wmiModel2 = wmiCompositeModel.getChild(n2);
                    } else if (n5 > 1) {
                        wmiModel2 = wmiCompositeModel.getChild(n5 - 2);
                    }
                    bl = true;
                } else {
                    WmiDeleteManager wmiDeleteManager = new WmiDeleteManager();
                    wmiDeleteManager.mark(wmiCompositeModel);
                    wmiDeleteManager.update();
                    if (wmiCompositeModel2 != null) {
                        wmiModel2 = wmiCompositeModel2.getChild(n3);
                        if (n > 0) {
                            object = wmiCompositeModel.getTag();
                            if (n2 != 0 && (object == WmiModelTag.MATH_FRAC || object == WmiModelTag.MATH_SUPERSCRIPT || object == WmiModelTag.MATH_SUBSCRIPT || object == WmiModelTag.MATH_SUB_SUP)) {
                                n4 = -1;
                            }
                        }
                    }
                    bl = true;
                }
            }
            if (wmiModel2 != null) {
                if (n < 0) {
                    if (wmiModel2 instanceof WmiTextModel) {
                        n4 = ((WmiTextModel)wmiModel2).getLength();
                    }
                    wmiMathDocumentView.setPendingPosition(new WmiModelPosition(wmiModel2, n4));
                } else {
                    wmiMathDocumentView.setPendingPosition(new WmiModelPosition(wmiModel2, 0));
                }
            }
        }
        return bl;
    }

    private static boolean deleteMathRootModel(WmiMathDocumentView wmiMathDocumentView, WmiModel wmiModel, int n) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        boolean bl;
        WmiCompositeModel wmiCompositeModel = wmiModel.getParent();
        int n2 = wmiCompositeModel.indexOf(wmiModel);
        WmiTextModel wmiTextModel = null;
        int n3 = 0;
        if (n2 > 0) {
            WmiModel wmiModel2 = wmiCompositeModel.getChild(n2 - 1);
            if (wmiModel2 instanceof WmiTextModel) {
                wmiTextModel = (WmiTextModel)wmiModel2;
                n3 = -1;
            } else if (wmiModel2 != null) {
                wmiTextModel = (WmiTextModel)WmiModelUtil.findFirstDescendantOfClass(wmiModel2, WmiTextModel.class);
                n3 = -1;
            }
        }
        if (wmiTextModel == null) {
            wmiTextModel = (WmiTextModel)WmiModelUtil.findFirstDescendantOfClass(wmiModel, WmiTextModel.class);
        }
        if ((bl = WmiMathDeleteUtil.deleteModel(wmiMathDocumentView, wmiModel, n)) && wmiTextModel != null) {
            WmiModelPosition wmiModelPosition = MathTokenizer.retokenize(wmiTextModel, n3);
            wmiMathDocumentView.setPendingPosition(wmiModelPosition);
        }
        return bl;
    }

    private static boolean deleteMathTableCell(WmiMathDocumentView wmiMathDocumentView, WmiMathTableModel.WmiMathTableDataModel wmiMathTableDataModel, int n) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        boolean bl = true;
        boolean bl2 = wmiMathTableDataModel.isInEmptyRow();
        boolean bl3 = wmiMathTableDataModel.isInEmptyColumn();
        WmiMathTableModel wmiMathTableModel = (WmiMathTableModel)WmiModelUtil.findAncestorOfTag((WmiModel)wmiMathTableDataModel, WmiModelTag.MATH_TABLE);
        WmiMathTableModel.WmiMathTableRowModel wmiMathTableRowModel = (WmiMathTableModel.WmiMathTableRowModel)wmiMathTableDataModel.getParent();
        int n2 = wmiMathTableRowModel.indexOf(wmiMathTableDataModel);
        int n3 = wmiMathTableModel.indexOf(wmiMathTableRowModel);
        if (bl3 && wmiMathTableRowModel.getChildCount() > 1 && n2 > 0) {
            for (int i = 0; i < wmiMathTableModel.getChildCount(); ++i) {
                WmiMathTableModel.WmiMathTableRowModel wmiMathTableRowModel2 = (WmiMathTableModel.WmiMathTableRowModel)wmiMathTableModel.getChild(i);
                wmiMathTableRowModel2.removeChild(n2);
            }
        }
        if (bl2) {
            wmiMathTableModel.removeChild(n3);
        }
        WmiModel wmiModel = null;
        int n4 = 0;
        if (wmiMathTableModel.getChildCount() == 0) {
            bl = WmiMathDeleteUtil.deleteModel(wmiMathDocumentView, wmiMathTableModel, n);
        } else if (n < 0) {
            if (bl2) {
                if (n3 > 0) {
                    wmiModel = wmiMathTableModel.getChild(n3 - 1);
                    n4 = -1;
                } else {
                    wmiModel = wmiMathTableModel.getChild(0);
                }
            } else if (n2 > 0) {
                wmiModel = wmiMathTableRowModel.getChild(n2 - 1);
                n4 = -1;
            } else if (n3 > 0) {
                wmiModel = wmiMathTableModel.getChild(n3 - 1);
                n4 = -1;
            } else {
                wmiModel = wmiMathTableModel.getChild(0);
            }
        } else {
            int n5 = wmiMathTableModel.getChildCount() - 1;
            if (bl2) {
                if (n3 < n5) {
                    wmiModel = wmiMathTableModel.getChild(n3 + 1);
                } else {
                    wmiModel = wmiMathTableModel.getChild(n5);
                    n4 = -1;
                }
            } else {
                int n6 = wmiMathTableRowModel.getChildCount() - 1;
                if (n2 < n6) {
                    wmiModel = wmiMathTableRowModel.getChild(n2 + 1);
                } else if (n3 < n5) {
                    wmiModel = wmiMathTableModel.getChild(n3 + 1);
                } else {
                    wmiModel = wmiMathTableModel.getChild(n5);
                    n4 = -1;
                }
            }
        }
        if (wmiModel != null) {
            wmiMathDocumentView.setPendingPosition(new WmiModelPosition(wmiModel, n4));
        }
        return bl;
    }

    private static boolean deleteInMathText(WmiMathDocumentView wmiMathDocumentView, WmiTextModel wmiTextModel, int n, boolean bl, int n2) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiMathDocumentModel wmiMathDocumentModel = wmiTextModel.getDocument();
        boolean bl2 = false;
        String string = wmiTextModel.getAllText();
        if (string.equals(" ")) {
            WmiModel wmiModel = WmiModelUtil.findPreviousDescendantLeaf(wmiMathDocumentModel, wmiTextModel);
            WmiModel wmiModel2 = WmiModelUtil.findNextDescendantLeaf(wmiMathDocumentModel, wmiTextModel);
            if (wmiModel instanceof WmiNumericModel && wmiModel2 instanceof WmiIdentifierModel) {
                bl2 = true;
            }
        }
        boolean bl3 = false;
        int n3 = wmiTextModel.getLength();
        if (n < 0) {
            n = n3;
        }
        if (n2 < 0) {
            if (n > 0) {
                wmiTextModel.deleteText(--n, 1);
                WmiMathDeleteUtil.retokenizeAndReposition(wmiTextModel, n, bl2, wmiMathDocumentView);
                bl3 = true;
            } else if (bl) {
                WmiModel wmiModel = wmiTextModel;
                WmiCompositeModel wmiCompositeModel = wmiModel.getParent();
                while (wmiCompositeModel != null && wmiCompositeModel.getChildCount() == 1) {
                    wmiModel = wmiCompositeModel;
                    wmiCompositeModel = wmiModel.getParent();
                }
                if (wmiCompositeModel != null && wmiCompositeModel.getTag() == WmiModelTag.MATH_ROW) {
                    WmiModelPosition wmiModelPosition = new WmiModelPosition(wmiTextModel, n);
                    wmiModelPosition = MathInsertUtil.updateInsertionPoint(wmiModelPosition, -1);
                    bl3 = WmiMathDeleteUtil.deleteInMath(wmiMathDocumentView, wmiModelPosition, false, n2);
                }
            }
        } else if (n < n3) {
            wmiTextModel.deleteText(n, 1);
            WmiMathDeleteUtil.retokenizeAndReposition(wmiTextModel, n, bl2, wmiMathDocumentView);
            bl3 = true;
        } else if (bl) {
            WmiModelPosition wmiModelPosition = new WmiModelPosition(wmiTextModel, n);
            wmiModelPosition = MathInsertUtil.updateInsertionPoint(wmiModelPosition, 1);
            bl3 = WmiMathDeleteUtil.deleteInMath(wmiMathDocumentView, wmiModelPosition, false, n2);
        }
        if (!bl3 && n3 == 0) {
            bl3 = WmiMathDeleteUtil.deleteModel(wmiMathDocumentView, wmiTextModel, n2);
        }
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static WmiModelPosition expandMathFences(WmiModelPosition wmiModelPosition, int n) throws WmiNoReadAccessException {
        WmiModel wmiModel = wmiModelPosition.getModel();
        int n2 = wmiModelPosition.getOffset();
        if (wmiModel instanceof WmiMathFencedModel) {
            try {
                WmiModelLock.writeLock(wmiModel, true);
                if (n2 != 0 && n < 0) {
                    wmiModelPosition = ((WmiMathFencedModel)wmiModel).convertToInlineMath(3);
                    return wmiModelPosition;
                }
                if (n2 != 0 || n <= 0) return wmiModelPosition;
                wmiModelPosition = ((WmiMathFencedModel)wmiModel).convertToInlineMath(0);
                return wmiModelPosition;
            }
            catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
                WmiErrorLog.log(wmiNoWriteAccessException);
                return wmiModelPosition;
            }
            finally {
                WmiModelLock.writeUnlock(wmiModel);
            }
        }
        WmiCompositeModel wmiCompositeModel = WmiModelUtil.findAncestorOfTag(wmiModel, WmiModelTag.MATH_FENCED);
        if (wmiCompositeModel == null) return wmiModelPosition;
        try {
            WmiModelLock.writeLock(wmiModel, true);
            if (n2 == 0 && n < 0) {
                WmiModel wmiModel2 = wmiModel;
                while (wmiModel2 != wmiCompositeModel && wmiModel2 != null) {
                    WmiCompositeModel wmiCompositeModel2 = wmiModel2.getParent();
                    if (wmiCompositeModel2.getChild(0) != wmiModel2) {
                        wmiModel2 = null;
                        break;
                    }
                    wmiModel2 = wmiCompositeModel2;
                }
                if (wmiModel2 == null) return wmiModelPosition;
                wmiModelPosition = ((WmiMathFencedModel)wmiCompositeModel).convertToInlineMath(1);
                return wmiModelPosition;
            } else {
                boolean bl = false;
                if (wmiModel instanceof WmiTextModel) {
                    int n3 = ((WmiTextModel)wmiModel).getLength();
                    bl = n2 == -1 || n2 == n3;
                } else {
                    boolean bl2 = bl = n2 == -1;
                }
                if (!bl || n <= 0) return wmiModelPosition;
                WmiModel wmiModel3 = wmiModel;
                while (wmiModel3 != wmiCompositeModel && wmiModel3 != null) {
                    WmiCompositeModel wmiCompositeModel3 = wmiModel3.getParent();
                    if (wmiCompositeModel3.getChild(wmiCompositeModel3.getChildCount() - 1) != wmiModel3) {
                        wmiModel3 = null;
                        break;
                    }
                    wmiModel3 = wmiCompositeModel3;
                }
                if (wmiModel3 == null) return wmiModelPosition;
                wmiModelPosition = ((WmiMathFencedModel)wmiCompositeModel).convertToInlineMath(2);
            }
            return wmiModelPosition;
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
            return wmiModelPosition;
        }
        finally {
            WmiModelLock.writeUnlock(wmiModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WmiModelPosition expandMathString(WmiModelPosition wmiModelPosition, int n) throws WmiNoReadAccessException {
        WmiModel wmiModel = wmiModelPosition.getModel();
        int n2 = wmiModelPosition.getOffset();
        if (wmiModel instanceof WmiMathStringModel) {
            int n3 = ((WmiMathStringModel)wmiModel).getLength();
            if (n == 1 && n2 == 0 || n == -1 && n2 == 1 || n == 1 && n2 == n3 - 1 || n == -1 && n2 == -1 || n == -1 && n2 == n3) {
                try {
                    WmiModelLock.writeLock(wmiModel, true);
                    wmiModelPosition = ((WmiMathStringModel)wmiModel).convertToIdentifier(n2);
                }
                catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
                    WmiErrorLog.log(wmiNoWriteAccessException);
                }
                finally {
                    WmiModelLock.writeUnlock(wmiModel);
                }
            }
        }
        return wmiModelPosition;
    }

    private static void retokenizeAndReposition(WmiTextModel wmiTextModel, int n, boolean bl, WmiMathDocumentView wmiMathDocumentView) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiModelPosition wmiModelPosition = null;
        WmiMathDocumentModel wmiMathDocumentModel = wmiTextModel.getDocument();
        if (!bl) {
            wmiModelPosition = MathTokenizer.retokenize(wmiTextModel, n);
        } else {
            WmiModel wmiModel = WmiModelUtil.findPreviousDescendantLeaf(wmiMathDocumentModel, wmiTextModel);
            wmiModelPosition = new WmiModelPosition(wmiModel, -1);
            WmiCompositeModel wmiCompositeModel = wmiTextModel.getParent();
            int n2 = wmiCompositeModel.indexOf(wmiTextModel);
            wmiCompositeModel.removeChild(n2);
            WmiInsertGenericMathCommand.refreshSemantics(wmiCompositeModel);
        }
        wmiMathDocumentView.setPendingPosition(wmiModelPosition);
    }

    private static WmiModel[] getChildrenToPromote(WmiModel wmiModel, int n) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiModel[] wmiModelArray = null;
        try {
            WmiCompositeModel wmiCompositeModel;
            int n2;
            WmiModelTag wmiModelTag;
            WmiModel wmiModel2 = null;
            if (wmiModel instanceof WmiCompositeModel) {
                wmiModel2 = ((WmiCompositeModel)wmiModel).getChild(n);
            }
            if (wmiModel2 instanceof WmiCompositeModel && PROMOTABLE_MODELS.contains(wmiModelTag = wmiModel2.getTag()) && (n2 = (wmiCompositeModel = (WmiCompositeModel)wmiModel2).getChildCount()) > 0) {
                if (wmiModelTag == WmiModelTag.MATH_SQUARE_ROOT || wmiModelTag == WmiModelTag.MATH_NROOT) {
                    n2 = 1;
                }
                ArrayList<WmiModel> arrayList = new ArrayList<WmiModel>();
                for (int i = 0; i < n2; ++i) {
                    WmiModel wmiModel3 = wmiCompositeModel.getChild(i);
                    if (wmiModel3 == null) continue;
                    arrayList.add(wmiModel3);
                }
                n2 = arrayList.size();
                if (n2 > 0) {
                    wmiModelArray = new WmiModel[n2];
                    arrayList.toArray(wmiModelArray);
                }
            }
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        return wmiModelArray;
    }

    static {
        PROMOTABLE_MODELS.add(WmiModelTag.MATH_SQUARE_ROOT);
        PROMOTABLE_MODELS.add(WmiModelTag.MATH_NROOT);
    }
}

