/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.edit;

import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.controller.edit.WmiCustomDeleteHandler;
import com.maplesoft.mathdoc.controller.edit.WmiMathDeleteUtil;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentHierarchyValidator;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiParagraphModel;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.view.WmiCaret;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiView;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.HashSet;

public abstract class WmiAbstractDelete
extends WmiCommand {
    private static final String RESOURCE_LOCATION = "com.maplesoft.mathdoc.controller.edit.resources.Edit";
    protected static final int DIRECTION_RIGHT = 1;
    protected static final int DIRECTION_LEFT = -1;
    private static final HashSet SELECT_MODEL_ONLY_TAGS = new HashSet();

    protected WmiAbstractDelete(String string) {
        super(string);
    }

    protected WmiAbstractDelete(String string, boolean bl) {
        super(string, bl);
    }

    public static void registerSelectModelOnlyTag(WmiModelTag wmiModelTag) {
        SELECT_MODEL_ONLY_TAGS.add(wmiModelTag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCommand(ActionEvent actionEvent) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiCustomDeleteHandler wmiCustomDeleteHandler;
        WmiMathDocumentModel wmiMathDocumentModel;
        WmiMathDocumentView wmiMathDocumentView = WmiAbstractDelete.getDocumentView(actionEvent);
        boolean bl = false;
        String string = this.getResource(5);
        if (WmiMathDeleteUtil.isMathSelectionDelete(wmiMathDocumentView)) {
            bl = WmiMathDeleteUtil.deleteMathSelection(wmiMathDocumentView, string);
        }
        if (!bl && WmiMathDeleteUtil.isMathDelete(wmiMathDocumentView)) {
            bl = WmiMathDeleteUtil.deleteInMath(wmiMathDocumentView, string, this.getDirection());
        }
        if (!bl) {
            wmiMathDocumentModel = (WmiMathDocumentModel)wmiMathDocumentView.getModel();
            wmiMathDocumentModel.revertPendingUpdates();
            bl = this.delete(wmiMathDocumentView);
        }
        if (!bl && (wmiCustomDeleteHandler = (wmiMathDocumentModel = (WmiMathDocumentModel)wmiMathDocumentView.getModel()).getCustomDeleteHandler()) != null) {
            WmiModelLock.writeLock(wmiMathDocumentModel, true);
            try {
                bl = wmiCustomDeleteHandler.deleteAtMarkerPosition(wmiMathDocumentView, this.getDirection());
                if (bl) {
                    wmiMathDocumentModel.update(this.getResource(5));
                }
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
            catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
                WmiErrorLog.log(wmiNoWriteAccessException);
            }
            catch (WmiNoUpdateAccessException wmiNoUpdateAccessException) {
                WmiErrorLog.log(wmiNoUpdateAccessException);
            }
            finally {
                WmiModelLock.writeUnlock(wmiMathDocumentModel);
            }
        }
        if (!bl) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public boolean delete(WmiMathDocumentView wmiMathDocumentView) throws WmiNoReadAccessException {
        boolean bl = false;
        if (wmiMathDocumentView != null) {
            WmiSelection wmiSelection = wmiMathDocumentView.getSelection();
            if (wmiSelection != null) {
                bl = this.deleteSelection(wmiMathDocumentView);
            } else {
                WmiPositionMarker wmiPositionMarker = wmiMathDocumentView.getPositionMarker();
                if (wmiPositionMarker != null) {
                    bl = this.deleteAtMarkerPosition(wmiMathDocumentView, true);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteAtMarkerPosition(WmiMathDocumentView wmiMathDocumentView, boolean bl) {
        boolean bl2 = false;
        WmiPositionMarker wmiPositionMarker = wmiMathDocumentView.getPositionMarker();
        if (wmiPositionMarker != null) {
            WmiMathDocumentModel wmiMathDocumentModel = (WmiMathDocumentModel)wmiMathDocumentView.getModel();
            WmiModelLock.writeLock(wmiMathDocumentModel, true);
            try {
                WmiPositionedView wmiPositionedView = wmiPositionMarker.getView();
                int n = wmiPositionMarker.getOffset();
                WmiModel wmiModel = wmiPositionedView.getModel();
                if (!(wmiPositionMarker instanceof WmiCaret)) {
                    bl2 = this.deleteView(wmiPositionedView);
                } else if (wmiModel instanceof WmiMathModel) {
                    WmiCompositeModel wmiCompositeModel;
                    if (WmiMathDeleteUtil.isEmptyMath(wmiModel) && (wmiCompositeModel = WmiModelUtil.findAncestorOfTag(wmiModel, WmiModelTag.MATH)) != null) {
                        bl2 = this.removeEmptyModel(wmiMathDocumentView, wmiCompositeModel);
                    }
                    if (!bl2) {
                        bl2 = this.deleteAtMathBoundary(wmiMathDocumentView, bl);
                    }
                } else if (wmiPositionedView instanceof WmiTextView) {
                    bl2 = this.deleteInText((WmiTextView)wmiPositionedView, n, bl);
                }
                if (bl2) {
                    wmiMathDocumentModel.update(this.getResource(5));
                }
            }
            catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
                WmiErrorLog.log(wmiNoWriteAccessException);
            }
            catch (WmiNoUpdateAccessException wmiNoUpdateAccessException) {
                WmiErrorLog.log(wmiNoUpdateAccessException);
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
            finally {
                WmiModelLock.writeUnlock(wmiMathDocumentModel);
            }
        }
        return bl2;
    }

    private boolean deleteView(WmiView wmiView) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathDocumentView wmiMathDocumentView;
        boolean bl = false;
        WmiModel wmiModel = wmiView.getModel();
        if (wmiModel != null && (wmiMathDocumentView = wmiView.getDocumentView()) != null) {
            this.removeEmptyModel(wmiMathDocumentView, wmiModel);
            bl = true;
        }
        return bl;
    }

    private boolean deleteInText(WmiTextView wmiTextView, int n, boolean bl) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        boolean bl2;
        block10: {
            bl2 = false;
            WmiModel wmiModel = wmiTextView.getModel();
            WmiMathDocumentView wmiMathDocumentView = wmiTextView.getDocumentView();
            if (wmiMathDocumentView == null) {
                return false;
            }
            WmiMathDocumentModel wmiMathDocumentModel = (WmiMathDocumentModel)wmiMathDocumentView.getModel();
            if (wmiModel instanceof WmiTextModel && wmiMathDocumentModel.isMutableModel(wmiModel)) {
                WmiTextModel wmiTextModel = (WmiTextModel)wmiModel;
                n = n < 0 ? wmiTextModel.getLength() : (n += wmiTextView.getStartOffset());
                if (this.getDirection() < 0) {
                    bl2 = --n >= 0;
                } else {
                    boolean bl3 = bl2 = n < wmiTextModel.getLength();
                }
                if (bl2) {
                    try {
                        wmiTextModel.deleteText(n, 1);
                        if (wmiTextModel.getLength() == 0) {
                            if (!this.removeEmptyModel(wmiMathDocumentView, wmiTextModel)) {
                                wmiMathDocumentView.setPendingPosition(new WmiModelPosition(wmiTextModel, 0));
                            }
                            break block10;
                        }
                        wmiMathDocumentView.setPendingPosition(new WmiModelPosition(wmiTextModel, n));
                    }
                    catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                        WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
                        bl2 = false;
                    }
                } else {
                    bl2 = this.deleteAtTextBoundary(wmiMathDocumentView, wmiTextModel, bl);
                }
            }
        }
        return bl2;
    }

    private boolean deleteAtTextBoundary(WmiMathDocumentView wmiMathDocumentView, WmiTextModel wmiTextModel, boolean bl) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        boolean bl2 = false;
        WmiPositionMarker wmiPositionMarker = wmiMathDocumentView.getPositionMarker();
        WmiPositionedView wmiPositionedView = wmiPositionMarker.getView();
        int n = wmiPositionMarker.getOffset();
        String string = this.getDirection() < 0 ? "move.left" : "move.right";
        WmiCommand wmiCommand = WmiCommand.getCommandInstance(string);
        ActionEvent actionEvent = new ActionEvent(wmiMathDocumentView, 0, string);
        wmiCommand.doCommand(actionEvent);
        WmiPositionMarker wmiPositionMarker2 = wmiMathDocumentView.getPositionMarker();
        if (wmiPositionMarker2 != null) {
            WmiPositionedView wmiPositionedView2 = wmiPositionMarker2.getView();
            WmiModel wmiModel = wmiPositionedView2.getModel();
            WmiCompositeModel wmiCompositeModel = WmiModelUtil.findAncestorOfClass(wmiModel, WmiParagraphModel.class);
            WmiCompositeModel wmiCompositeModel2 = WmiModelUtil.findAncestorOfClass(wmiTextModel, WmiParagraphModel.class);
            if (wmiCompositeModel != null && wmiCompositeModel2 != null && wmiCompositeModel != wmiCompositeModel2) {
                bl2 = this.conditionalParagraphMerge(wmiMathDocumentView, wmiCompositeModel2, wmiCompositeModel, wmiModel);
            } else if (wmiCompositeModel == wmiCompositeModel2 && wmiModel != wmiTextModel) {
                if (wmiTextModel.getLength() == 0) {
                    this.removeEmptyModel(wmiMathDocumentView, wmiTextModel);
                }
                if (bl) {
                    bl2 = this.deleteAtMarkerPosition(wmiMathDocumentView, false);
                }
            }
        }
        if (!bl2 && wmiPositionedView != null) {
            wmiPositionedView.setPositionMarker(n);
        }
        return bl2;
    }

    private boolean deleteAtMathBoundary(WmiMathDocumentView wmiMathDocumentView, boolean bl) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiModel wmiModel;
        boolean bl2 = false;
        WmiPositionMarker wmiPositionMarker = wmiMathDocumentView.getPositionMarker();
        WmiPositionedView wmiPositionedView = wmiPositionMarker.getView();
        int n = wmiPositionMarker.getOffset();
        String string = this.getDirection() < 0 ? "move.left" : "move.right";
        WmiCommand wmiCommand = WmiCommand.getCommandInstance(string);
        ActionEvent actionEvent = new ActionEvent(wmiMathDocumentView, 0, string);
        wmiCommand.doCommand(actionEvent);
        WmiPositionMarker wmiPositionMarker2 = wmiMathDocumentView.getPositionMarker();
        WmiPositionedView wmiPositionedView2 = wmiPositionMarker2 != null ? wmiPositionMarker2.getView() : null;
        WmiModel wmiModel2 = wmiModel = wmiPositionedView2 != null ? wmiPositionedView2.getModel() : null;
        if (wmiModel != null) {
            WmiCompositeModel wmiCompositeModel = WmiModelUtil.findAncestorOfTag(wmiPositionedView.getModel(), WmiModelTag.MATH);
            WmiCompositeModel wmiCompositeModel2 = WmiModelUtil.findAncestorOfTag(wmiModel, WmiModelTag.MATH);
            if (wmiCompositeModel != null && wmiCompositeModel2 != wmiCompositeModel && bl) {
                WmiCompositeModel wmiCompositeModel3 = WmiModelUtil.findAncestorOfClass(wmiPositionedView.getModel(), WmiParagraphModel.class);
                WmiCompositeModel wmiCompositeModel4 = WmiModelUtil.findAncestorOfClass(wmiModel, WmiParagraphModel.class);
                if (wmiCompositeModel4 == wmiCompositeModel3) {
                    bl2 = this.deleteAtMarkerPosition(wmiMathDocumentView, false);
                } else if (wmiCompositeModel4 != null && wmiCompositeModel3 != null && wmiCompositeModel4 != wmiCompositeModel3) {
                    bl2 = this.conditionalParagraphMerge(wmiMathDocumentView, wmiCompositeModel3, wmiCompositeModel4, wmiModel);
                }
            }
        }
        if (!bl2) {
            if (wmiPositionMarker != wmiPositionMarker2) {
                wmiMathDocumentView.setPositionMarker(wmiPositionMarker);
            } else {
                wmiPositionedView.setPositionMarker(n);
            }
        }
        return bl2;
    }

    private boolean conditionalParagraphMerge(WmiMathDocumentView wmiMathDocumentView, WmiCompositeModel wmiCompositeModel, WmiCompositeModel wmiCompositeModel2, WmiModel wmiModel) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        boolean bl = wmiCompositeModel != null && wmiCompositeModel2 != null;
        WmiMathDocumentModel wmiMathDocumentModel = wmiCompositeModel != null ? wmiCompositeModel.getDocument() : null;
        WmiMathDocumentHierarchyValidator wmiMathDocumentHierarchyValidator = wmiMathDocumentModel != null ? wmiMathDocumentModel.getModelHierarchyValidator() : null;
        bl &= wmiMathDocumentHierarchyValidator != null & wmiCompositeModel != null && wmiMathDocumentHierarchyValidator.hasPostDeletePermission(wmiCompositeModel.getTag());
        while (bl && wmiCompositeModel.getParent() != wmiCompositeModel2.getParent()) {
            wmiCompositeModel = wmiCompositeModel.getParent();
            wmiCompositeModel2 = wmiCompositeModel2.getParent();
            if (wmiCompositeModel == null || wmiCompositeModel2 == null) {
                bl = false;
            }
            if (wmiCompositeModel.getTag() != wmiCompositeModel2.getTag()) {
                bl = false;
            }
            if (!wmiMathDocumentHierarchyValidator.hasPostDeletePermission(wmiCompositeModel.getTag())) {
                bl = false;
            }
            if (!wmiCompositeModel.isDeletionBoundary()) continue;
            bl = false;
        }
        if (bl) {
            bl = this.mergeParagraphs(wmiMathDocumentView, wmiCompositeModel, wmiCompositeModel2, wmiModel, this.getDirection());
        }
        return bl;
    }

    private boolean mergeParagraphs(WmiMathDocumentView wmiMathDocumentView, WmiCompositeModel wmiCompositeModel, WmiCompositeModel wmiCompositeModel2, WmiModel wmiModel, int n) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        int n2;
        WmiModel wmiModel2;
        boolean bl = false;
        int n3 = wmiCompositeModel.getChildCount();
        for (int i = n3 - 1; i >= 0; --i) {
            wmiModel2 = wmiCompositeModel.getChild(i);
            if (wmiModel2 == wmiModel || !(wmiModel2 instanceof WmiTextModel) || ((WmiTextModel)wmiModel2).getLength() != 0) continue;
            try {
                wmiCompositeModel.removeChild(i);
                continue;
            }
            catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
            }
        }
        WmiCompositeModel wmiCompositeModel3 = null;
        wmiModel2 = null;
        if (n < 0) {
            wmiCompositeModel3 = wmiCompositeModel2;
            wmiModel2 = wmiCompositeModel;
        } else {
            wmiCompositeModel3 = wmiCompositeModel;
            wmiModel2 = wmiCompositeModel2;
        }
        n3 = wmiModel2.getChildCount();
        WmiModel[] wmiModelArray = new WmiModel[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            wmiModelArray[n2] = wmiModel2.getChild(n2);
        }
        n2 = wmiCompositeModel3.getChildCount();
        WmiModel wmiModel3 = n2 > 0 ? wmiCompositeModel3.getChild(n2 - 1) : null;
        WmiModel wmiModel4 = n3 > 0 ? wmiModel2.getChild(0) : null;
        try {
            wmiModel2.removeChildren(0, n3);
            wmiCompositeModel3.addChildren(wmiModelArray, n2);
            WmiCompositeModel wmiCompositeModel4 = wmiModel2.getParent();
            wmiCompositeModel4.removeChild(wmiModel2);
            if (wmiModel3 != null && wmiModel4 != null && wmiModel3.getTag() == wmiModel4.getTag()) {
                WmiMathDocumentHierarchyValidator wmiMathDocumentHierarchyValidator;
                WmiMathDocumentModel wmiMathDocumentModel = wmiModel3.getDocument();
                WmiMathDocumentHierarchyValidator wmiMathDocumentHierarchyValidator2 = wmiMathDocumentHierarchyValidator = wmiMathDocumentModel != null ? wmiMathDocumentModel.getModelHierarchyValidator() : null;
                if (wmiMathDocumentHierarchyValidator.hasPostDeletePermission(wmiModel3.getTag())) {
                    if (wmiModel3 instanceof WmiCompositeModel) {
                        this.mergeParagraphs(wmiMathDocumentView, (WmiCompositeModel)wmiModel3, (WmiCompositeModel)wmiModel4, wmiModel, 1);
                    } else if (wmiModel3 instanceof WmiTextModel) {
                        this.mergeText(wmiMathDocumentView, (WmiTextModel)wmiModel3, (WmiTextModel)wmiModel4);
                    }
                }
            }
            bl = true;
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
        }
        return bl;
    }

    private void mergeText(WmiMathDocumentView wmiMathDocumentView, WmiTextModel wmiTextModel, WmiTextModel wmiTextModel2) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiCompositeModel wmiCompositeModel;
        int n;
        WmiFontAttributeSet wmiFontAttributeSet;
        WmiFontAttributeSet wmiFontAttributeSet2 = (WmiFontAttributeSet)wmiTextModel.getAttributes();
        if (wmiFontAttributeSet2.equals(wmiFontAttributeSet = (WmiFontAttributeSet)wmiTextModel2.getAttributes()) && (n = (wmiCompositeModel = wmiTextModel.getParent()).indexOf(wmiTextModel2)) >= 0) {
            int n2 = wmiTextModel.getLength();
            wmiMathDocumentView.setPendingPosition(new WmiModelPosition(wmiTextModel, n2));
            try {
                wmiTextModel.appendText(wmiTextModel2.getText());
                wmiCompositeModel.removeChild(n);
            }
            catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
            }
        }
    }

    private boolean removeEmptyModel(WmiMathDocumentView wmiMathDocumentView, WmiModel wmiModel) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        boolean bl = false;
        WmiCompositeModel wmiCompositeModel = wmiModel.getParent();
        if (wmiCompositeModel != null) {
            WmiMathDocumentModel wmiMathDocumentModel;
            WmiMathDocumentHierarchyValidator wmiMathDocumentHierarchyValidator;
            int n = wmiCompositeModel.getChildCount();
            if (n == 1 && wmiModel.getTag() != WmiModelTag.TEXT && !(wmiModel instanceof WmiMathModel) && (wmiMathDocumentHierarchyValidator = (wmiMathDocumentModel = wmiModel.getDocument()).getModelHierarchyValidator()).isValid(wmiCompositeModel.getTag(), WmiModelTag.TEXT)) {
                try {
                    WmiAttributeSet wmiAttributeSet = wmiCompositeModel.getAttributesForRead();
                    WmiTextModel wmiTextModel = new WmiTextModel(wmiMathDocumentModel);
                    wmiTextModel.addAttributes(wmiAttributeSet);
                    wmiCompositeModel.replaceChild(wmiTextModel, 0);
                    wmiMathDocumentView.setPendingPosition(new WmiModelPosition(wmiTextModel, 0));
                    bl = true;
                }
                catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                    WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
                }
            }
            if (n > 1) {
                try {
                    int n2 = wmiCompositeModel.indexOf(wmiModel);
                    int n3 = -1;
                    if (n2 > 0) {
                        --n2;
                    } else {
                        n3 = 0;
                    }
                    wmiCompositeModel.removeChild(wmiModel);
                    bl = true;
                    if (wmiMathDocumentView != null) {
                        wmiMathDocumentView.setPendingPosition(new WmiModelPosition(wmiCompositeModel.getChild(n2), n3));
                    }
                }
                catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                    WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
                }
            }
        }
        return bl;
    }

    private boolean deleteSelection(WmiMathDocumentView wmiMathDocumentView) throws WmiNoReadAccessException {
        boolean bl = false;
        WmiSelection wmiSelection = wmiMathDocumentView.getSelection();
        if (wmiSelection != null) {
            WmiMathDocumentModel wmiMathDocumentModel = (WmiMathDocumentModel)wmiMathDocumentView.getModel();
            WmiCustomDeleteHandler wmiCustomDeleteHandler = wmiMathDocumentModel.getCustomDeleteHandler();
            if (wmiCustomDeleteHandler != null) {
                try {
                    bl = wmiCustomDeleteHandler.deleteSelection(wmiMathDocumentView);
                }
                catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
                    WmiErrorLog.log(wmiNoWriteAccessException);
                }
            }
            if (!bl && WmiAbstractDelete.isDeleteableSelection(wmiSelection, false)) {
                wmiSelection.deleteSelection();
                bl = true;
            }
        }
        return bl;
    }

    public boolean isEnabled(WmiView wmiView) {
        return true;
    }

    protected abstract boolean canSelectNext(int var1, int var2);

    protected abstract int getDirection();

    protected String getResourcePath() {
        return RESOURCE_LOCATION;
    }

    public static boolean isDeleteableSelection(WmiSelection wmiSelection, boolean bl) throws WmiNoReadAccessException {
        boolean bl2 = true;
        WmiMathDocumentView wmiMathDocumentView = wmiSelection.getSourceDocument();
        WmiMathDocumentModel wmiMathDocumentModel = (WmiMathDocumentModel)wmiMathDocumentView.getModel();
        WmiModel[] wmiModelArray = new WmiModel[2];
        int[] nArray = new int[2];
        wmiSelection.getModelInterval(wmiModelArray, nArray);
        if (wmiModelArray[0] != null && wmiModelArray[1] != null) {
            boolean bl3;
            WmiModel wmiModel;
            WmiModel wmiModel2;
            bl2 = false;
            WmiModel wmiModel3 = wmiModelArray[0];
            WmiModel wmiModel4 = wmiModelArray[1];
            int n = nArray[0];
            int n2 = nArray[1];
            boolean bl4 = wmiMathDocumentModel.isMutableModel(wmiModel3);
            if (!bl4 && (wmiModel2 = WmiAbstractDelete.getMutableDeletionBoundary(wmiModel3, n, -1)) != null) {
                wmiModel = wmiModel2.getParent();
                bl4 = wmiMathDocumentModel.isMutableModel(wmiModel);
            }
            if (!(bl3 = wmiMathDocumentModel.isMutableModel(wmiModel4)) && (wmiModel = WmiAbstractDelete.getMutableDeletionBoundary(wmiModel4, n2, 1)) != null) {
                WmiCompositeModel wmiCompositeModel = wmiModel.getParent();
                bl3 = wmiMathDocumentModel.isMutableModel(wmiCompositeModel);
            }
            bl2 = bl4 && bl3;
        }
        return bl2;
    }

    private static WmiModel getMutableDeletionBoundary(WmiModel wmiModel, int n, int n2) throws WmiNoReadAccessException {
        WmiModel wmiModel2 = wmiModel;
        WmiMathDocumentModel wmiMathDocumentModel = wmiModel.getDocument();
        if (n2 == -1 && n != 0) {
            return null;
        }
        if (n2 == 1 && n >= 0) {
            if (wmiModel instanceof WmiTextModel) {
                if (n < ((WmiTextModel)wmiModel).getLength()) {
                    return null;
                }
            } else {
                return null;
            }
        }
        while (!wmiMathDocumentModel.isMutableModel(wmiModel2)) {
            WmiCompositeModel wmiCompositeModel = wmiModel2.getParent();
            int n3 = wmiCompositeModel.indexOf(wmiModel2);
            if (n2 == -1 && n3 > 0 && !wmiMathDocumentModel.isMutableModel(wmiCompositeModel)) {
                wmiModel2 = null;
                break;
            }
            if (n2 == 1 && n3 >= 0 && n3 < wmiCompositeModel.getChildCount() - 1 && !wmiMathDocumentModel.isMutableModel(wmiCompositeModel)) {
                wmiModel2 = null;
                break;
            }
            wmiModel2 = wmiCompositeModel;
            if (!wmiModel2.isDeletionBoundary()) continue;
            break;
        }
        return wmiModel2;
    }
}

