/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.util.RuntimePlatform;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import javax.swing.KeyStroke;

public class WmiKeyBinder
extends HashMap {
    public void registerBinding(char c, WmiDispatchOperation wmiDispatchOperation) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(c);
        this.registerBinding(keyStroke, wmiDispatchOperation);
    }

    public void registerBinding(char c, int n, WmiDispatchOperation wmiDispatchOperation) {
        WmiCharModCombo wmiCharModCombo = new WmiCharModCombo(c, n);
        this.put(wmiCharModCombo, wmiDispatchOperation);
    }

    public void registerBinding(int n, int n2, WmiDispatchOperation wmiDispatchOperation) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(n, n2);
        this.registerBinding(keyStroke, wmiDispatchOperation);
    }

    public void registerBinding(KeyStroke keyStroke, WmiDispatchOperation wmiDispatchOperation) {
        this.put(keyStroke, wmiDispatchOperation);
    }

    public void registerBindingOverRange(char c, char c2, WmiDispatchOperation wmiDispatchOperation) {
        for (char c3 = c; c3 <= c2; c3 = (char)(c3 + '\u0001')) {
            this.registerBinding(c3, wmiDispatchOperation);
        }
    }

    public boolean handlesKey(KeyStroke keyStroke) {
        return this.get(keyStroke) != null;
    }

    public boolean handlesKey(WmiCharModCombo wmiCharModCombo) {
        return this.get(wmiCharModCombo) != null;
    }

    public boolean dispatch(KeyEvent keyEvent, WmiView wmiView) {
        boolean bl = false;
        KeyStroke keyStroke = null;
        switch (keyEvent.getKeyChar()) {
            case '\t': {
                keyStroke = KeyStroke.getKeyStroke(new Character('\t'), keyEvent.getModifiers());
                break;
            }
            default: {
                keyStroke = keyEvent.getID() == 400 ? KeyStroke.getKeyStroke(keyEvent.getKeyChar()) : (RuntimePlatform.isMac_10_2() && (keyEvent.getModifiers() & 0xFFFFFFFE) == 0 ? KeyStroke.getKeyStroke(keyEvent.getKeyChar()) : KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers()));
            }
        }
        WmiCharModCombo wmiCharModCombo = new WmiCharModCombo(keyEvent);
        if (this.handlesKey(keyStroke)) {
            bl = this.get(keyStroke).dispatch(keyEvent, wmiView);
        } else if (this.handlesKey(wmiCharModCombo)) {
            bl = this.get(wmiCharModCombo).dispatch(keyEvent, wmiView);
        }
        return bl;
    }

    public void put(KeyStroke keyStroke, WmiDispatchOperation wmiDispatchOperation) {
        super.put(keyStroke, wmiDispatchOperation);
    }

    public void put(WmiCharModCombo wmiCharModCombo, WmiDispatchOperation wmiDispatchOperation) {
        super.put(wmiCharModCombo, wmiDispatchOperation);
    }

    public WmiDispatchOperation get(WmiCharModCombo wmiCharModCombo) {
        return (WmiDispatchOperation)super.get(wmiCharModCombo);
    }

    public WmiDispatchOperation get(KeyStroke keyStroke) {
        return (WmiDispatchOperation)super.get(keyStroke);
    }

    public static interface WmiDispatchOperation {
        public boolean dispatch(KeyEvent var1, WmiView var2);
    }

    private class WmiCharModCombo {
        char c;
        boolean ctrlDown;
        boolean altDown;
        boolean metaDown;
        boolean shiftDown;

        WmiCharModCombo(char c, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.c = c;
            this.ctrlDown = bl;
            this.altDown = bl2;
            this.metaDown = bl3;
            this.shiftDown = bl4;
        }

        WmiCharModCombo(char c, int n) {
            this.c = c;
            this.ctrlDown = (n & 2) != 0;
            this.altDown = (n & 8) != 0;
            this.metaDown = (n & 4) != 0;
            this.shiftDown = (n & 1) != 0;
        }

        WmiCharModCombo(KeyEvent keyEvent) {
            this(keyEvent.getKeyChar(), keyEvent.getModifiers());
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof WmiCharModCombo) {
                WmiCharModCombo wmiCharModCombo = (WmiCharModCombo)object;
                bl = this.c == wmiCharModCombo.c && this.ctrlDown == wmiCharModCombo.ctrlDown && this.altDown == wmiCharModCombo.altDown && this.metaDown == wmiCharModCombo.metaDown && this.shiftDown == wmiCharModCombo.shiftDown;
            }
            return bl;
        }

        public int hashCode() {
            int n = 17 * this.c + 11 * (this.ctrlDown ? 1 : 0) + 29 * (this.altDown ? 1 : 0) + 7 * (this.metaDown ? 1 : 0) + 5 * (this.shiftDown ? 1 : 0);
            return n;
        }
    }
}

