/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.controller.WmiAbstractViewFactory;
import com.maplesoft.mathdoc.controller.WmiController;
import com.maplesoft.mathdoc.controller.WmiControllerBuilder;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewBuilder;
import java.lang.reflect.Constructor;
import java.util.HashMap;

public class WmiHashedViewFactory
extends WmiAbstractViewFactory {
    private HashMap viewMap;
    private HashMap controllerMap;

    public WmiController getController(WmiView wmiView) {
        WmiController wmiController = null;
        if (wmiView != null) {
            WmiModel wmiModel = wmiView.getModel();
            if (wmiModel != null) {
                WmiModelTag wmiModelTag = wmiModel.getTag();
                WmiControllerBuilder wmiControllerBuilder = (WmiControllerBuilder)this.controllerMap.get(wmiModelTag);
                if (wmiControllerBuilder != null) {
                    wmiController = wmiControllerBuilder.createController();
                }
            } else {
                throw new IllegalArgumentException("getController() received a view with a null model:" + wmiView);
            }
        }
        return wmiController;
    }

    protected void initialize() {
        this.viewMap = new HashMap();
        this.controllerMap = new HashMap();
    }

    public void addViewMapping(WmiModelTag wmiModelTag, WmiViewBuilder wmiViewBuilder) {
        this.viewMap.put(wmiModelTag, wmiViewBuilder);
    }

    public void addViewMapping(WmiModelTag wmiModelTag, Constructor constructor) {
        this.viewMap.put(wmiModelTag, constructor);
    }

    public void addControllerMapping(WmiModelTag wmiModelTag, WmiControllerBuilder wmiControllerBuilder) {
        this.controllerMap.put(wmiModelTag, wmiControllerBuilder);
    }

    protected Object getBuilder(WmiModelTag wmiModelTag) {
        return this.viewMap.get(wmiModelTag);
    }
}

