/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.controller.WmiCommandProxy;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.util.WmiResourcePackage;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.util.RuntimeLocale;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class WmiDefaultKeyListener
implements KeyListener {
    private static boolean treatTabsAsChars;
    protected static final String DELETE_COMMAND = "edit.delete";
    protected static final String BACKSPACE_COMMAND = "edit.backspace";
    private static final char[] CODE_TO_CHAR_MAPPING;
    private char lastDeadKey = '\u0000';
    private boolean gotKeyTyped = false;

    private static void loadCommandsFromBundle(String string) {
        WmiResourcePackage wmiResourcePackage = WmiResourcePackage.getResourcePackage(string);
        wmiResourcePackage.instantiateClasses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WmiSelection getSelection(WmiView wmiView) {
        WmiModel wmiModel = wmiView.getModel();
        WmiSelection wmiSelection = null;
        try {
            WmiModelLock.readLock(wmiModel, true);
            WmiMathDocumentView wmiMathDocumentView = wmiView.getDocumentView();
            wmiSelection = wmiMathDocumentView.getSelection();
        }
        finally {
            WmiModelLock.readUnlock(wmiModel);
        }
        return wmiSelection;
    }

    protected boolean processChar(KeyEvent keyEvent, WmiView wmiView) {
        boolean bl = true;
        if (!wmiView.getDocumentView().getInputLock().isLocked()) {
            char c = keyEvent.getKeyChar();
            if (c == '\u007f') {
                WmiCommand.invokeCommand(DELETE_COMMAND);
            } else if (c == '\b') {
                WmiCommand.invokeCommand(BACKSPACE_COMMAND);
            } else {
                bl = false;
            }
        }
        return bl;
    }

    protected KeyEvent mapFromInternationalKeyboard(KeyEvent keyEvent) {
        if (RuntimeLocale.isJapanese() && keyEvent.isShiftDown()) {
            boolean bl;
            boolean bl2 = bl = RuntimePlatform.isMac() ? keyEvent.isMetaDown() : keyEvent.isControlDown();
            if (bl) {
                char c = '\u0000';
                int n = 0;
                if (keyEvent.getKeyChar() == '-' || keyEvent.getKeyCode() == 45) {
                    c = '=';
                    n = 61;
                }
                if (c != '\u0000') {
                    keyEvent.consume();
                    Object object = keyEvent.getSource();
                    Component component = null;
                    component = object instanceof WmiView ? ((WmiView)object).getDocumentView() : (object instanceof Component ? (Component)object : WmiMathDocumentView.getActiveDocumentView());
                    keyEvent = new KeyEvent(component, keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers() & 0xFFFFFFFE, n, c);
                    keyEvent.setSource(object);
                }
            }
        }
        return keyEvent;
    }

    public void keyPressed(KeyEvent keyEvent) {
        WmiCommandProxy wmiCommandProxy;
        if (!keyEvent.isConsumed() && !WmiDefaultKeyListener.isInputLocked(keyEvent) && (wmiCommandProxy = WmiCommand.getCommandProxy(keyEvent = this.mapFromInternationalKeyboard(keyEvent))) != null) {
            wmiCommandProxy.actionPerformed(new ActionEvent(keyEvent.getSource(), keyEvent.getModifiers(), wmiCommandProxy.toString()));
            keyEvent.consume();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (RuntimePlatform.isUnix()) {
            int n = keyEvent.getKeyCode();
            if (this.isDeadKey(n) && !this.gotKeyTyped) {
                char c = this.mapKeyCode(n);
                if (c == this.lastDeadKey) {
                    Component component = null;
                    if (keyEvent.getSource() instanceof Component) {
                        component = (Component)keyEvent.getSource();
                    } else if (keyEvent.getSource() instanceof WmiView) {
                        component = ((WmiView)keyEvent.getSource()).getDocumentView();
                    }
                    KeyEvent keyEvent2 = new KeyEvent(component, 400, keyEvent.getWhen(), keyEvent.getModifiers(), 0, this.lastDeadKey, 0);
                    keyEvent2.setSource(keyEvent.getSource());
                    this.keyTyped(keyEvent2);
                    this.lastDeadKey = '\u0000';
                } else {
                    this.lastDeadKey = c;
                }
            } else {
                this.lastDeadKey = '\u0000';
            }
        }
        this.notifyKeyReleased(keyEvent);
    }

    protected boolean isDeadKey(int n) {
        return 128 <= n && n <= 143;
    }

    protected char mapKeyCode(int n) {
        return CODE_TO_CHAR_MAPPING[n - 128];
    }

    protected void notifyKeyTyped(KeyEvent keyEvent) {
        this.gotKeyTyped = true;
    }

    protected void notifyKeyReleased(KeyEvent keyEvent) {
        this.gotKeyTyped = false;
    }

    public void keyTyped(KeyEvent keyEvent) {
        WmiCommandProxy wmiCommandProxy = WmiCommand.getCommandProxy(keyEvent);
        if (wmiCommandProxy != null) {
            wmiCommandProxy.actionPerformed(new ActionEvent(keyEvent.getSource(), keyEvent.getModifiers(), wmiCommandProxy.toString()));
            keyEvent.consume();
        }
        if (!(keyEvent.isConsumed() || keyEvent.isControlDown() || keyEvent.isMetaDown() || !RuntimePlatform.isMac() && keyEvent.isAltDown())) {
            if (keyEvent.getKeyChar() == '\t' && !this.treatTabsAsChars()) {
                String string = keyEvent.isShiftDown() ? "focus.cycle.reverse" : "focus.cycle.forward";
                WmiCommand.invokeCommand(string);
                keyEvent.consume();
            } else {
                WmiMathDocumentView wmiMathDocumentView;
                WmiPositionMarker wmiPositionMarker;
                Component component;
                Container container;
                Object object = keyEvent.getSource();
                WmiPositionedView wmiPositionedView = null;
                if (object instanceof WmiPositionedView) {
                    wmiPositionedView = (WmiPositionedView)object;
                } else if (object instanceof Component && (container = (component = (Component)object).getParent()) instanceof WmiMathDocumentView && (wmiPositionMarker = (wmiMathDocumentView = (WmiMathDocumentView)container).getPositionMarker()) != null) {
                    wmiPositionedView = wmiPositionMarker.getView();
                }
                if (wmiPositionedView != null && wmiPositionedView.getDocumentView() != null && !wmiPositionedView.getDocumentView().getInputLock().isLocked() && this.processChar(keyEvent, wmiPositionedView)) {
                    keyEvent.consume();
                }
            }
        }
        this.notifyKeyTyped(keyEvent);
    }

    protected static boolean isInputLocked(KeyEvent keyEvent) {
        Component component;
        Container container;
        boolean bl = false;
        Object object = keyEvent.getSource();
        WmiMathDocumentView wmiMathDocumentView = null;
        if (object instanceof WmiView) {
            wmiMathDocumentView = ((WmiView)object).getDocumentView();
        } else if (object instanceof Component && (container = (component = (Component)object).getParent()) instanceof WmiMathDocumentView) {
            wmiMathDocumentView = (WmiMathDocumentView)container;
        }
        if (wmiMathDocumentView != null) {
            bl = wmiMathDocumentView.getInputLock().isLocked();
        }
        return bl;
    }

    protected boolean treatTabsAsChars() {
        return treatTabsAsChars;
    }

    public static void treatTabsAsChars(boolean bl) {
        treatTabsAsChars = bl;
    }

    static {
        WmiDefaultKeyListener.loadCommandsFromBundle("com/maplesoft/mathdoc/controller/navigation/resources/Navigation");
        WmiDefaultKeyListener.loadCommandsFromBundle("com/maplesoft/mathdoc/controller/edit/resources/Edit");
        WmiDefaultKeyListener.loadCommandsFromBundle("com/maplesoft/mathdoc/controller/insert/resources/Insert");
        treatTabsAsChars = false;
        CODE_TO_CHAR_MAPPING = new char[]{'`', '\u00b4', '^', '~', '\u02c9', '\u02d8', '\u02d9', '\u00a8', '\u02da', '\u02dd', '\u02c7', '\u00b8', '\u02db', '\u0000', '\u0000', '\u0000'};
    }
}

