/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components.palettes;

import com.maplesoft.mathdoc.components.WmiComponentUtil;
import com.maplesoft.mathdoc.components.WmiMathMLEditorButtonMenu;
import com.maplesoft.mathdoc.components.dockingtools.WmiConfigurablePalette;
import com.maplesoft.mathdoc.components.dockingtools.WmiItemConfigurationError;
import com.maplesoft.mathdoc.components.dockingtools.WmiPalette;
import com.maplesoft.mathdoc.components.dockingtools.WmiPaletteButtonFactory;
import com.maplesoft.mathdoc.components.dockingtools.WmiPaletteContentPanel;
import com.maplesoft.mathdoc.components.palettes.WmiMathMLContentInsertionController;
import com.maplesoft.mathdoc.components.palettes.WmiMathMLEditorPaletteManager;
import com.maplesoft.mathdoc.controller.view.palettes.WmiPaletteButtonDnDManager;
import com.maplesoft.mathdoc.controller.view.palettes.WmiPaletteManager;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorDictionary;
import com.maplesoft.mathdoc.util.WmiResourcePackage;
import com.maplesoft.util.WmiMathEntityNameMapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.dnd.DragGestureEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class WmiMathMLEditorPalette
extends WmiConfigurablePalette {
    public static final String PALETTE_BUTTON_LIST_PROPERTY = "buttons";
    public static final String EXTENDED_BUTTON_LIST_PROPERTY = "extended";
    public static final String PALETTE_INSERT_2D_MATH_PROPERTY = ".insert.2dmath";
    public static final String PALETTE_PREFERRED_WIDTH_PROPERTY = "palette.preferred.width";
    public static final String PALETTE_PREFERRED_HEIGHT_PROPERTY = "palette.preferred.height";
    public static final String PALETTE_PREFERRED_EXTENDED_WIDTH_PROPERTY = "palette.preferred.extended.width";
    public static final String PALETTE_PREFERRED_EXTENDED_HEIGHT_PROPERTY = "palette.preferred.extended.height";
    public static final int DEFAULT_WIDTH = 200;
    public static final int DEFAULT_HEIGHT = 200;
    protected List indexToNameList;
    protected List indexToExtendedNameList;
    protected ArrayList insert2DMathList;
    protected ArrayList originalNameList;
    protected ArrayList tooltipList;
    protected static WmiPaletteButtonFactory buttonFactory = null;
    protected WmiMathMLEditorButtonMenu menu;
    private boolean lazyInitialize = true;
    protected int paletteWidth;
    protected int paletteHeight;
    private int columns = 0;
    private int columnCount = 1;
    private int rowHeight = 0;
    private int rowWidth = 0;
    private int maxRowWidth = 0;

    public WmiMathMLEditorPalette(String string, WmiPaletteManager wmiPaletteManager, boolean bl) {
        this(string, "", wmiPaletteManager, bl);
    }

    public WmiMathMLEditorPalette(String string, WmiPaletteManager wmiPaletteManager) {
        this(string, "", wmiPaletteManager, false);
        this.paletteWidth = 0;
        this.paletteHeight = 0;
        this.lazyInitialize = true;
    }

    public void setColumnCount(int n) {
        this.columns = n;
    }

    public WmiMathMLEditorPalette(String string, String string2, WmiPaletteManager wmiPaletteManager, boolean bl) {
        super(string, string2, wmiPaletteManager, bl);
        if (this.insert2DMathList == null) {
            this.insert2DMathList = new ArrayList();
        }
        this.originalNameList = new ArrayList();
        this.tooltipList = new ArrayList();
        this.setDragController(new DragController());
        if (bl) {
            try {
                if (this.configuration.getStringForKey(PALETTE_PREFERRED_EXTENDED_WIDTH_PROPERTY) != null) {
                    this.paletteWidth = Integer.parseInt(this.configuration.getStringForKey(PALETTE_PREFERRED_EXTENDED_WIDTH_PROPERTY));
                }
                if (this.configuration.getStringForKey(PALETTE_PREFERRED_EXTENDED_HEIGHT_PROPERTY) != null) {
                    this.paletteHeight = Integer.parseInt(this.configuration.getStringForKey(PALETTE_PREFERRED_EXTENDED_HEIGHT_PROPERTY));
                }
            }
            catch (Exception exception) {
                this.paletteWidth = 200;
                this.paletteHeight = 200;
            }
        }
        if (this.paletteWidth == 0 || this.paletteHeight == 0) {
            try {
                this.paletteWidth = Integer.parseInt(this.configuration.getStringForKey(PALETTE_PREFERRED_WIDTH_PROPERTY));
                this.paletteHeight = Integer.parseInt(this.configuration.getStringForKey(PALETTE_PREFERRED_HEIGHT_PROPERTY));
            }
            catch (Exception exception) {
                this.paletteWidth = 200;
                this.paletteHeight = 200;
            }
        }
        this.setActionController(new InsertAction());
    }

    public WmiMathMLEditorPaletteManager getPaletteManager() {
        return (WmiMathMLEditorPaletteManager)this.paletteManager;
    }

    public WmiPaletteButtonFactory getButtonFactory() {
        return buttonFactory;
    }

    public ArrayList getInsert2DMathList() {
        return this.insert2DMathList;
    }

    public ArrayList getOriginalNameList() {
        return this.originalNameList;
    }

    public ArrayList getTooltipList() {
        return this.tooltipList;
    }

    public HashMap getButtonToIndex() {
        return this.buttonToIndex;
    }

    public void setMenu(WmiMathMLEditorButtonMenu wmiMathMLEditorButtonMenu) {
        this.menu = wmiMathMLEditorButtonMenu;
    }

    protected void populateButtonPanel() {
        Object object;
        WmiResourcePackage wmiResourcePackage = this.getConfiguration();
        String string = wmiResourcePackage.getStringForKey(EXTENDED_BUTTON_LIST_PROPERTY);
        this.indexToExtendedNameList = new ArrayList();
        if (string != null) {
            object = string.split("\\s+");
            for (int i = 0; i < ((String[])object).length; ++i) {
                this.indexToExtendedNameList.add(object[i]);
            }
        }
        if ((object = wmiResourcePackage.getStringForKey(PALETTE_BUTTON_LIST_PROPERTY)) != null) {
            String[] stringArray = ((String)object).split("\\s+");
            this.indexToNameList = new ArrayList();
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!this.extendedPalette && this.indexToExtendedNameList.contains(stringArray[i])) continue;
                AbstractButton abstractButton = this.addItem(stringArray[i], wmiResourcePackage);
                this.indexToNameList.add(stringArray[i]);
                this.buttonToIndex.put(abstractButton, new Integer(n));
                ++n;
            }
            if (this.indexToNameList == null || this.indexToNameList.size() == 0) {
                throw new WmiItemConfigurationError("Error populating " + this.getResourceName() + " palette: empty button list", null);
            }
        } else {
            super.populateButtonPanel();
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.paletteWidth, this.paletteHeight);
    }

    public void configureSize(int n, int n2) {
        if (this.rowWidth > this.maxRowWidth) {
            this.maxRowWidth = this.rowWidth;
        }
        this.paletteWidth = this.maxRowWidth + 4;
        this.paletteHeight = this.paletteHeight + this.rowHeight + 8;
    }

    public void configurePanel() {
        this.setUI(WmiPalette.PaletteGroupPanelUI.getInstance());
        this.setBorder(null);
        BorderLayout borderLayout = new BorderLayout();
        this.setLayout(borderLayout);
    }

    public AbstractButton addItem(String string, WmiResourcePackage wmiResourcePackage, int n, String string2) throws WmiItemConfigurationError {
        Object object;
        AbstractButton abstractButton = null;
        try {
            object = wmiResourcePackage.getStringForKey(string + PALETTE_INSERT_2D_MATH_PROPERTY);
            String string3 = this.menu.getIconNameForKey(string);
            if (object != null) {
                this.insert2DMathList.add(object);
                String string4 = ((String)object).replaceAll("%", "");
                abstractButton = buttonFactory.createButton(string4);
                if (string3 != null) {
                    ImageIcon imageIcon = WmiComponentUtil.getImageIcon(this.menu.getImageResourcePath() + string3);
                    abstractButton.setIcon(imageIcon);
                }
            } else if (WmiMathEntityNameMapper.getUnicodeCharacter(string) != '\u0000') {
                String string5 = WmiMathOperatorDictionary.isNameForOperator("&" + string + ";") ? "<mrow><mo>&" + string + ";" + "</mo></mrow>" : "<mrow><mi>&" + string + ";" + "</mi></mrow>";
                this.insert2DMathList.add(string5);
                abstractButton = buttonFactory.createButton(WmiMathEntityNameMapper.getUnicodeCharacter(string));
            } else {
                String string6 = "";
                string6 = WmiMathOperatorDictionary.isNameForOperator(string) ? "<mrow><mo>" + string + "</mo></mrow>" : "<mrow><mi>" + string + "</mi></mrow>";
                this.insert2DMathList.add(string6);
                abstractButton = string.length() == 1 ? buttonFactory.createButton(string.charAt(0)) : buttonFactory.createButton(string6);
            }
            this.buttonToIndex.put(abstractButton, new Integer(n));
            this.originalNameList.add(string);
            this.tooltipList.add(string2);
        }
        catch (Exception exception) {
            throw new WmiItemConfigurationError(this.getResourceName() + " WmiExpressionPalette item " + string + " needs insert property", exception);
        }
        if (this.columns > 0) {
            if (this.columnCount > this.columns) {
                if (this.rowWidth > this.maxRowWidth) {
                    this.maxRowWidth = this.rowWidth;
                }
                this.paletteHeight = this.paletteHeight + this.rowHeight + 4;
                this.columnCount = 1;
                this.rowWidth = 0;
                this.rowHeight = 0;
            }
            object = abstractButton.getPreferredSize();
            this.rowWidth = this.rowWidth + (int)((Dimension)object).getWidth() + 2;
            if (((Dimension)object).getHeight() > (double)this.rowHeight) {
                this.rowHeight = (int)((Dimension)object).getHeight();
            }
            ++this.columnCount;
        }
        abstractButton.setToolTipText(string2);
        super.addItem(string, wmiResourcePackage, abstractButton);
        return abstractButton;
    }

    public void addItem(WmiMathMLEditorButtonMenu wmiMathMLEditorButtonMenu) {
        this.getContent().add(wmiMathMLEditorButtonMenu);
    }

    public AbstractButton addMenuButton(String string, WmiResourcePackage wmiResourcePackage, int n, WmiMathMLEditorButtonMenu wmiMathMLEditorButtonMenu) throws WmiItemConfigurationError {
        return null;
    }

    protected JPanel createContentPanel() {
        return new MathMLPaletteContentPanel(this, this.rowPadding, this.columnPadding, this.getUniformContentItemSize());
    }

    protected boolean performLazyInitialize() {
        return true;
    }

    static {
        buttonFactory = new WmiPaletteButtonFactory(new WmiPaletteButtonDnDManager());
    }

    public class MathMLActionControllerCaller
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            Integer n2 = (Integer)WmiMathMLEditorPalette.this.buttonToIndex.get(actionEvent.getSource());
            int n3 = n = n2 != null ? n2 : -1;
            if (WmiMathMLEditorPalette.this.actionController != null) {
                WmiMathMLEditorPalette.this.actionController.actionPerformed(actionEvent, n);
            }
        }

        public boolean handlesButton(AbstractButton abstractButton) {
            return WmiMathMLEditorPalette.this.buttonToIndex.containsKey(abstractButton);
        }
    }

    private class DragController
    implements WmiConfigurablePalette.WmiDragController {
        private DragController() {
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent, int n) {
            if (WmiMathMLEditorPalette.this.menu != null) {
                WmiMathMLEditorPalette.this.menu.hide();
            }
        }
    }

    public class InsertAction
    implements WmiConfigurablePalette.WmiActionController {
        public void actionPerformed(ActionEvent actionEvent, int n) {
            Component component = (Component)actionEvent.getSource();
            String string = (String)WmiMathMLEditorPalette.this.insert2DMathList.get(n);
            WmiMathMLContentInsertionController.insertPaletteContent(component, string);
            if (WmiMathMLEditorPalette.this.menu != null) {
                WmiMathMLEditorPalette.this.menu.hide();
            }
        }
    }

    protected class MathMLPaletteContentPanel
    extends WmiPaletteContentPanel {
        public MathMLPaletteContentPanel(WmiPalette wmiPalette, int n, int n2, boolean bl) {
            super(wmiPalette, n, n2, bl);
            this.setBorder(BorderFactory.createBevelBorder(0));
        }
    }
}

