/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components.dockingtools;

import com.maplesoft.mathdoc.controller.view.palettes.WmiPaletteButtonDnDManager;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.platform.WmiPaletteButtonUIFactory;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.math.WmiMathViewUtil;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JSlider;
import javax.swing.plaf.ButtonUI;

public class WmiPaletteButtonFactory {
    private static final int BUTTON_BORDER_PADDING = 4;
    public static final float DEFAULT_FONT_SIZE = 20.0f;
    protected static final Font DEFAULT_RESOLVE_FONT = new Font("Times New Roman", 0, 20);
    protected WmiMathDocumentView renderView = new WmiMathDocumentView();
    private WmiPaletteButtonDnDManager dndManager = null;
    private JFrame contextFrame = null;

    public WmiPaletteButtonFactory(WmiPaletteButtonDnDManager wmiPaletteButtonDnDManager) {
        this.dndManager = wmiPaletteButtonDnDManager;
    }

    public WmiPaletteButtonDnDManager getDnDManager() {
        return this.dndManager;
    }

    public Image renderMathML(String string, WmiMathDocumentView wmiMathDocumentView, int[] nArray, boolean bl) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        return WmiMathViewUtil.renderMathML(string, wmiMathDocumentView, 4, nArray, bl, null);
    }

    public Image renderComponent(JComponent jComponent) {
        Serializable serializable;
        if (jComponent instanceof JSlider) {
            serializable = jComponent.getPreferredSize();
            ((Dimension)serializable).width /= 2;
            jComponent.setPreferredSize((Dimension)serializable);
        }
        serializable = this.getContextFrame();
        ((JFrame)serializable).getContentPane().add(jComponent);
        ((Window)serializable).pack();
        BufferedImage bufferedImage = new BufferedImage(jComponent.getWidth() + 2, jComponent.getHeight() + 2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        jComponent.paint(graphics2D);
        graphics2D.dispose();
        ((JFrame)serializable).remove(jComponent);
        return bufferedImage;
    }

    private JFrame getContextFrame() {
        if (this.contextFrame == null) {
            this.contextFrame = new JFrame();
        }
        return this.contextFrame;
    }

    public AbstractButton createButton(char c) {
        JButton jButton = new JButton();
        WmiPaletteButtonFactory.installFont(jButton, c);
        ButtonUI buttonUI = WmiPaletteButtonUIFactory.createUI();
        jButton.setUI(buttonUI);
        this.dndManager.installDragGestureListener(jButton);
        return jButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractButton createButton(String string) {
        Object object;
        PaletteButton paletteButton = new PaletteButton();
        if (string.startsWith("<mrow")) {
            try {
                WmiModelLock.writeLock(this.renderView.getModel(), true);
                object = new int[1];
                Image image = this.renderMathML(string, this.renderView, (int[])object, false);
                paletteButton.setIcon(new ImageIcon(image));
                paletteButton.setBaseline((int)object[0]);
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
            catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
                WmiErrorLog.log(wmiNoWriteAccessException);
            }
            finally {
                WmiModelLock.writeUnlock(this.renderView.getModel());
            }
        }
        object = WmiPaletteButtonUIFactory.createUI();
        paletteButton.setUI((ButtonUI)object);
        this.dndManager.installDragGestureListener(paletteButton);
        return paletteButton;
    }

    public AbstractButton createButton(JComponent jComponent) {
        JButton jButton = new JButton();
        Image image = this.renderComponent(jComponent);
        jButton.setIcon(new ImageIcon(image));
        ButtonUI buttonUI = WmiPaletteButtonUIFactory.createUI();
        jButton.setUI(buttonUI);
        this.dndManager.installDragGestureListener(jButton);
        return jButton;
    }

    public static void installFont(AbstractButton abstractButton, char c) {
        String string = Character.toString(c);
        Font font = WmiFontResolver.getFontForCharacter(string, DEFAULT_RESOLVE_FONT);
        if (font != null) {
            char c2 = WmiFontResolver.mapCharacterForFont(string.charAt(0), font);
            abstractButton.setFont(font.deriveFont(20.0f));
            abstractButton.setText(Character.toString(c2));
        } else {
            abstractButton.setFont(DEFAULT_RESOLVE_FONT.deriveFont(20.0f));
            abstractButton.setText(string);
        }
    }

    public static int getBaseline(AbstractButton abstractButton) {
        int n = 0;
        if (abstractButton instanceof PaletteButton) {
            n = ((PaletteButton)abstractButton).getBaseline();
        } else if (abstractButton != null) {
            n = abstractButton.getHeight() / 2;
        }
        return n;
    }

    public static class PaletteButton
    extends JButton {
        private int baseline;

        public int getBaseline() {
            return this.baseline;
        }

        public void setBaseline(int n) {
            this.baseline = n;
        }
    }
}

