/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import com.maplesoft.mathdoc.components.FloatValueControlSliderUI;
import com.maplesoft.mathdoc.components.WmiFloatValueTarget;
import com.maplesoft.mathdoc.util.WmiResourcePackage;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WmiFloatValueControl
extends JPanel
implements ChangeListener,
PropertyChangeListener {
    public static final String PROMPT_KEY = "PROMPT";
    public static final String INFO_KEY = "INFO";
    public static final String MIN_VAL_KEY = "MIN";
    public static final String MAX_VAL_KEY = "MAX";
    public static final int DEFAULT_PRECISION = 2;
    private static final double FONT_SCALE = 0.8;
    private int ctrlId;
    private JSlider ctrlSlider = null;
    private JFormattedTextField ctrlTextField = null;
    private double ctrlValue = 0.0;
    private String promptString = null;
    private String infoString = null;
    private String minString = null;
    private String maxString = null;
    private double ctrlMin = 0.0;
    private double ctrlMax = 1000.0;
    private int ctrlPrecision = 0;
    private Vector targets = new Vector();
    private boolean inhibitValueUpdate = false;

    public WmiFloatValueControl(int n, String string, String string2, int n2) {
        this(n, string, string2, n2, 1);
    }

    public WmiFloatValueControl(int n, String string, String string2, int n2, int n3) {
        this.ctrlId = n;
        this.ctrlPrecision = n2;
        this.loadResources(string, string2);
        this.setLayout(new BoxLayout(this, n3));
        this.addComponents();
    }

    public WmiFloatValueControl(int n, String string, String string2) {
        this(n, string, string2, 2);
    }

    public WmiFloatValueControl(String string, String string2, int n) {
        this(-1, string, string2, n);
    }

    public WmiFloatValueControl(String string, String string2) {
        this(-1, string, string2, 2);
    }

    public void setDrawSliderTicks(boolean bl) {
        if (this.ctrlSlider != null) {
            this.ctrlSlider.setPaintTicks(bl);
        }
    }

    public void setRange(double d, double d2) {
        this.ctrlMin = d;
        this.ctrlMax = d2;
        this.setValue(this.getValue());
    }

    public double getValue() {
        return this.ctrlValue;
    }

    public void setValue(double d) {
        this.setValue(d, true, true);
    }

    public void setValue(double d, boolean bl, boolean bl2) {
        this.ctrlValue = d < this.ctrlMin ? this.ctrlMin : (d > this.ctrlMax ? this.ctrlMax : d);
        if (bl) {
            this.notifyTargets();
        }
        if (bl2) {
            if (this.ctrlSlider != null) {
                this.ctrlSlider.setValue(this.getScaledSliderValue(this.ctrlValue));
            }
            if (this.ctrlTextField != null) {
                this.ctrlTextField.setValue(new Double(this.ctrlValue));
            }
        }
    }

    protected void addComponents() {
        JLabel jLabel = new JLabel(this.promptString);
        Font font = jLabel.getFont();
        font = font.deriveFont((float)(0.8 * (double)font.getSize()));
        JLabel jLabel2 = new JLabel(this.infoString);
        jLabel2.setFont(font);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(jLabel);
        jPanel.add(Box.createVerticalStrut(2));
        jPanel.add(jLabel2);
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMinimumFractionDigits(this.ctrlPrecision);
        numberFormat.setMaximumFractionDigits(this.ctrlPrecision);
        this.ctrlTextField = new JFormattedTextField(numberFormat);
        this.ctrlTextField.setColumns(5);
        this.ctrlTextField.setValue(new Double(this.getValue()));
        this.ctrlTextField.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "verify_edit");
        this.ctrlTextField.getActionMap().put("verify_edit", new WmiTextInputHandler());
        this.ctrlTextField.addPropertyChangeListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(jPanel);
        jPanel2.add(Box.createHorizontalStrut(10));
        jPanel2.add(this.ctrlTextField);
        this.add(jPanel2);
        this.ctrlSlider = new JSlider();
        this.ctrlSlider.setUI(new FloatValueControlSliderUI(this.ctrlSlider));
        if (this.minString != null && this.maxString != null) {
            Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
            JLabel jLabel3 = new JLabel(this.minString);
            jLabel3.setFont(font);
            JLabel jLabel4 = new JLabel(this.maxString);
            jLabel4.setFont(font);
            hashtable.put(new Integer(0), jLabel3);
            hashtable.put(new Integer(100), jLabel4);
            this.ctrlSlider.setLabelTable(hashtable);
            this.ctrlSlider.setPaintLabels(true);
        }
        this.ctrlSlider.setPaintTicks(true);
        this.ctrlSlider.setMajorTickSpacing(25);
        this.ctrlSlider.setValue(this.getScaledSliderValue(this.ctrlValue));
        this.ctrlSlider.addChangeListener(this);
        this.add(this.ctrlSlider);
    }

    protected void loadResources(String string, String string2) {
        WmiResourcePackage wmiResourcePackage = WmiResourcePackage.getResourcePackage(string);
        this.promptString = wmiResourcePackage.getStringForKey(string2 + "." + PROMPT_KEY);
        this.infoString = wmiResourcePackage.getStringForKey(string2 + "." + INFO_KEY);
        this.minString = wmiResourcePackage.getStringForKey(string2 + "." + MIN_VAL_KEY);
        this.maxString = wmiResourcePackage.getStringForKey(string2 + "." + MAX_VAL_KEY);
    }

    private double rangeClamp(double d) {
        double d2 = d;
        if (d2 < this.ctrlMin) {
            d2 = this.ctrlMin;
        } else if (d2 > this.ctrlMax) {
            d2 = this.ctrlMax;
        }
        return d2;
    }

    private int getScaledSliderValue(double d) {
        double d2 = this.rangeClamp(d);
        d2 = (d2 - this.ctrlMin) / (this.ctrlMax - this.ctrlMin) * 100.0;
        return (int)Math.round(d2);
    }

    private double getScaledControlValue(int n) {
        double d = n;
        d = d * (this.ctrlMax - this.ctrlMin) / 100.0 + this.ctrlMin;
        return d;
    }

    public void addSliderMouseListener(MouseListener mouseListener) {
        this.ctrlSlider.addMouseListener(mouseListener);
    }

    public void removeSliderMouseListener(MouseListener mouseListener) {
        this.ctrlSlider.removeMouseListener(mouseListener);
    }

    public void addTarget(WmiFloatValueTarget wmiFloatValueTarget) {
        if (!this.targets.contains(wmiFloatValueTarget)) {
            this.targets.add(wmiFloatValueTarget);
        }
    }

    public void removeTarget(WmiFloatValueTarget wmiFloatValueTarget) {
        this.targets.remove(wmiFloatValueTarget);
    }

    private void notifyTargets() {
        Iterator iterator = this.targets.iterator();
        while (iterator.hasNext()) {
            ((WmiFloatValueTarget)iterator.next()).valueChangeNotify(this.ctrlId, this.ctrlValue);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JSlider jSlider;
        JSlider jSlider2 = jSlider = changeEvent.getSource() instanceof JSlider ? (JSlider)changeEvent.getSource() : null;
        if (jSlider != null) {
            if (!this.inhibitValueUpdate) {
                this.setValue(this.getScaledControlValue(jSlider.getValue()));
            }
            if (!jSlider.getValueIsAdjusting()) {
                this.ctrlTextField.setValue(new Double(this.getValue()));
            } else if (this.ctrlPrecision != 0) {
                this.ctrlTextField.setText(String.valueOf(this.getValue()));
            } else {
                this.ctrlTextField.setText(String.valueOf((int)this.getValue()));
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("value".equals(propertyChangeEvent.getPropertyName())) {
            Number number = (Number)propertyChangeEvent.getNewValue();
            this.setValue(number.doubleValue());
            if (this.ctrlSlider != null && number != null) {
                this.ctrlSlider.setValue(this.getScaledSliderValue(this.getValue()));
            }
        }
    }

    protected class WmiTextInputHandler
    extends AbstractAction {
        protected WmiTextInputHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            if (!WmiFloatValueControl.this.ctrlTextField.isEditValid()) {
                Toolkit.getDefaultToolkit().beep();
                WmiFloatValueControl.this.ctrlTextField.selectAll();
            } else {
                try {
                    WmiFloatValueControl.this.inhibitValueUpdate = true;
                    WmiFloatValueControl.this.ctrlTextField.commitEdit();
                }
                catch (ParseException parseException) {
                }
                finally {
                    WmiFloatValueControl.this.inhibitValueUpdate = false;
                }
            }
        }
    }
}

