/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import com.maplesoft.mathdoc.components.WmiContextualMenu;
import com.maplesoft.mathdoc.components.WmiStatusBarContextListener;
import com.maplesoft.mathdoc.components.WmiUpdateScheduler;
import com.maplesoft.mathdoc.controller.Wmi2DEntryMode;
import com.maplesoft.mathdoc.controller.WmiMenu;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiInlineView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

public abstract class WmiContextManager {
    protected static final String CUT_COMMAND_NAME = "MathDoc.Edit.Cut";
    protected static final String COPY_COMMAND_NAME = "MathDoc.Edit.Copy";
    protected static final String COPY_FULL_PRECISION_COMMAND_NAME = "MathDoc.Edit.CopyFullPrecision";
    protected static final String PASTE_COMMAND_NAME = "MathDoc.Edit.Paste";
    protected static final String FORMAT_COMMAND_NAME = "Format.Numeric";
    public static final Wmi2DEntryMode EM_STANDARD = new Wmi2DEntryMode("2D_MODE");
    public static final Wmi2DEntryMode EM_GREEK = new Wmi2DEntryMode("GREEK_MODE");
    protected WmiMathDocumentView contextDocument = null;
    protected WmiView contextView = null;
    protected WmiMenu activeContextualMenu = null;
    private WmiUpdateScheduler scheduler = null;
    private Wmi2DEntryMode entryMode = EM_STANDARD;
    protected WmiStatusBarContextListener statusListener = null;

    protected WmiContextManager() {
    }

    protected void popupMenu(WmiMenu wmiMenu, WmiView wmiView, MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = this.activeContextualMenu.getPopupMenu();
        wmiMenu.setSelected(true);
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (wmiView instanceof WmiPositionedView) {
            WmiPositionedView wmiPositionedView = (WmiPositionedView)wmiView;
            Point point = WmiViewUtil.getAbsoluteOffset(wmiPositionedView);
            n += point.x;
            n2 += point.y;
        }
        jPopupMenu.show(wmiView.getDocumentView(), n, n2);
    }

    public void positionChangeNotification(WmiMathDocumentView wmiMathDocumentView) {
        if (wmiMathDocumentView == this.contextDocument) {
            this.setContextForDocument(this.contextDocument);
        }
    }

    public void popupRequestNotification(WmiView wmiView, MouseEvent mouseEvent) {
        this.setContextForDocument(wmiView);
        this.buildMenu();
        if (this.activeContextualMenu != null) {
            mouseEvent.consume();
            this.popupMenu(this.activeContextualMenu, wmiView, mouseEvent);
        }
    }

    public void notifyWorksheetChange(WmiMathDocumentView wmiMathDocumentView) {
        if (wmiMathDocumentView != null) {
            this.contextDocument = wmiMathDocumentView;
            this.setContextForDocument(this.contextDocument);
        }
    }

    public void updateEntryMode(Wmi2DEntryMode wmi2DEntryMode) {
        this.entryMode = wmi2DEntryMode;
        if (this.statusListener != null) {
            this.statusListener.notifyContextStatusChange();
        }
    }

    public Wmi2DEntryMode getEntryMode() {
        return this.entryMode;
    }

    public void setStatusBarContextListener(WmiStatusBarContextListener wmiStatusBarContextListener) {
        this.statusListener = wmiStatusBarContextListener;
    }

    public void setContextForDocument(WmiView wmiView) {
        boolean bl = false;
        if (wmiView != null) {
            WmiMathDocumentView wmiMathDocumentView;
            WmiPositionMarker wmiPositionMarker;
            if ((wmiView instanceof WmiMathDocumentView || wmiView instanceof WmiInlineView) && (wmiPositionMarker = (wmiMathDocumentView = wmiView.getDocumentView()).getPositionMarker()) != null) {
                WmiPositionedView wmiPositionedView = wmiPositionMarker.getView();
                if (wmiPositionedView != null) {
                    wmiView = wmiPositionedView;
                }
                int n = wmiPositionMarker.getOffset();
                WmiModel wmiModel = wmiView.getModel();
                if (wmiModel instanceof WmiMathModel) {
                    WmiCompositeView wmiCompositeView;
                    int n2;
                    while (wmiView instanceof WmiCompositeView && (n2 = (wmiCompositeView = (WmiCompositeView)wmiView).getChildCount()) > 0) {
                        wmiView = n == 0 ? wmiCompositeView.getChild(0) : wmiCompositeView.getChild(n2 - 1);
                    }
                }
            }
            if (wmiView.getDocumentView() != null && wmiView.getDocumentView().getSelection() != null) {
                bl = true;
            }
            if (wmiView != this.contextView) {
                this.contextView = wmiView;
                bl = true;
            }
        }
        if (bl) {
            if (this.scheduler == null) {
                this.scheduler = new WmiUpdateScheduler(new Runnable(){

                    public void run() {
                        WmiContextManager.this.updateContext();
                    }
                });
            } else {
                this.scheduler.ping();
            }
        }
    }

    protected boolean updateContext() {
        return true;
    }

    protected void resetExistingMenu() {
        if (this.activeContextualMenu != null) {
            this.activeContextualMenu.setSelected(false);
            this.activeContextualMenu.getPopupMenu().setInvoker(this.activeContextualMenu);
            this.removeCommonMenuElements(this.activeContextualMenu);
        }
    }

    public boolean buildMenu() {
        return this.buildMenu(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean buildMenu(boolean bl) {
        boolean bl2 = false;
        if (bl) {
            this.resetExistingMenu();
        }
        WmiModel wmiModel = this.contextView.getModel();
        WmiContextualMenu wmiContextualMenu = this.getMenuForModel(wmiModel);
        WmiContextualMenu wmiContextualMenu2 = (WmiContextualMenu)(bl ? null : this.activeContextualMenu);
        if (wmiContextualMenu != null) {
            if (bl) {
                wmiContextualMenu2 = wmiContextualMenu.copyMenu();
            } else {
                wmiContextualMenu2.add(wmiContextualMenu.copyMenu());
            }
        }
        HashSet<WmiModelTag> hashSet = new HashSet<WmiModelTag>();
        boolean bl3 = !WmiModelLock.ownsWriteLock(wmiModel);
        try {
            if (bl3) {
                WmiModelLock.readLock(wmiModel, true);
            }
            for (WmiCompositeModel wmiCompositeModel = wmiModel.getParent(); wmiCompositeModel != null && wmiCompositeModel != wmiCompositeModel.getDocument(); wmiCompositeModel = wmiCompositeModel.getParent()) {
                if (hashSet.contains(wmiCompositeModel.getTag())) continue;
                hashSet.add(wmiCompositeModel.getTag());
                wmiContextualMenu = this.getMenuForModel(wmiCompositeModel);
                if (wmiContextualMenu == null) continue;
                if (wmiContextualMenu2 != null) {
                    wmiContextualMenu.setSelected(false);
                    wmiContextualMenu.getPopupMenu().setInvoker(wmiContextualMenu);
                    wmiContextualMenu2.add(wmiContextualMenu.copyMenu());
                    continue;
                }
                wmiContextualMenu2 = wmiContextualMenu.copyMenu();
            }
            bl2 = true;
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        finally {
            if (bl3) {
                WmiModelLock.readUnlock(wmiModel);
            }
        }
        if (wmiContextualMenu2 != null) {
            this.removeDisabledMenuItems(wmiContextualMenu2);
            this.addCommonMenuElements(wmiContextualMenu2, false);
        }
        this.activeContextualMenu = wmiContextualMenu2;
        return bl2;
    }

    private void removeDisabledMenuItems(WmiMenu wmiMenu) {
        Component component;
        wmiMenu.setSelected(true);
        int n = 0;
        Component[] componentArray = wmiMenu.getMenuComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] instanceof WmiMenu) {
                WmiMenu wmiMenu2 = (WmiMenu)componentArray[i];
                this.removeDisabledMenuItems(wmiMenu2);
                if (wmiMenu2.getMenuComponentCount() == 0) {
                    wmiMenu.remove(wmiMenu2);
                    continue;
                }
                ++n;
                continue;
            }
            if (!this.isValidMenuItem(componentArray[i])) {
                wmiMenu.remove(componentArray[i]);
                continue;
            }
            if (componentArray[i] instanceof JPopupMenu.Separator) {
                if (n == 0) {
                    wmiMenu.remove(componentArray[i]);
                    continue;
                }
                n = 0;
                continue;
            }
            ++n;
        }
        if (wmiMenu.getMenuComponentCount() > 0 && (component = wmiMenu.getMenuComponent(wmiMenu.getMenuComponentCount() - 1)) instanceof JPopupMenu.Separator) {
            wmiMenu.remove(component);
        }
        wmiMenu.setSelected(false);
    }

    protected boolean isValidMenuItem(Component component) {
        return component.isEnabled();
    }

    protected void addCommonMenuElements(JMenu jMenu, boolean bl) {
    }

    protected void removeCommonMenuElements(JMenu jMenu) {
        if (jMenu.getMenuComponentCount() >= 4) {
            jMenu.remove(0);
            jMenu.remove(0);
            jMenu.remove(0);
            jMenu.remove(0);
        }
    }

    protected abstract WmiContextualMenu getMenuForModel(WmiModel var1);

    public WmiMenu getActiveContextualMenu() {
        return this.activeContextualMenu;
    }
}

