/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import com.maplesoft.util.ResourceLoader;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class WmiComponentUtil {
    private static HashMap imageMap = new HashMap();
    private static HashMap imageIconMap = new HashMap();
    private static final String PLATFORM_FOLDER = RuntimePlatform.isMac() ? "/mac" : "/default";

    public static Image getImage(String string) {
        Image image = (Image)imageMap.get(string);
        if (image == null && (image = ResourceLoader.getResourceAsImage(string)) != null) {
            imageMap.put(string, image);
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageIcon getImageIcon(String string) {
        ImageIcon imageIcon = null;
        HashMap hashMap = imageIconMap;
        synchronized (hashMap) {
            Image image;
            imageIcon = (ImageIcon)imageIconMap.get(string);
            if (imageIcon == null && (image = WmiComponentUtil.getImage(string)) != null) {
                imageIcon = new ImageIcon(image);
                imageIconMap.put(string, imageIcon);
            }
        }
        return imageIcon;
    }

    public static String getMnemonic(String string) {
        int n;
        String string2 = null;
        if (!RuntimePlatform.isMac() && string != null && (n = string.indexOf(126)) != -1 && n < string.length() - 1) {
            string2 = String.valueOf(string.charAt(n + 1));
        }
        return string2;
    }

    public static String resourceFolderName(int n) {
        String string;
        switch (n) {
            case 1: {
                string = "/mini";
                break;
            }
            case 2: {
                string = "/small";
                break;
            }
            case 3: {
                string = "/large";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    public static String platformFolderName() {
        return PLATFORM_FOLDER;
    }

    public static Rectangle centerTextInButton(AbstractButton abstractButton) {
        Rectangle rectangle = new Rectangle();
        SwingUtilities.layoutCompoundLabel(abstractButton, abstractButton.getFontMetrics(abstractButton.getFont()), abstractButton.getText(), abstractButton.getIcon(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), new Rectangle(0, 0, abstractButton.getWidth(), abstractButton.getHeight()), new Rectangle(), rectangle, abstractButton.getText() == null ? 0 : abstractButton.getIconTextGap());
        return rectangle;
    }

    private WmiComponentUtil() {
    }
}

