/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import com.maplesoft.mathdoc.components.WmiComponent;
import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.controller.WmiDataActionEvent;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class WmiComboBox
extends JComboBox
implements WmiComponent {
    protected WmiCommand boxCmd = null;
    private boolean ignoreSelectionChange = false;
    private ItemListener myListener = null;

    public WmiComboBox(Object[] objectArray, WmiCommand wmiCommand) {
        super(objectArray);
        this.initializeComboBox(wmiCommand);
    }

    public WmiComboBox(ComboBoxModel comboBoxModel, WmiCommand wmiCommand) {
        super(comboBoxModel);
        this.initializeComboBox(wmiCommand);
    }

    public WmiComboBox(Vector vector, WmiCommand wmiCommand) {
        super(vector);
        this.initializeComboBox(wmiCommand);
    }

    public WmiComboBox(WmiCommand wmiCommand) {
        this.initializeComboBox(wmiCommand);
    }

    protected void initializeComboBox(WmiCommand wmiCommand) {
        this.boxCmd = wmiCommand;
        if (RuntimePlatform.isMac()) {
            ListCellRenderer listCellRenderer = this.getRenderer();
            MacComboBoxRenderer macComboBoxRenderer = new MacComboBoxRenderer(listCellRenderer);
            this.setRenderer(macComboBoxRenderer);
        }
        this.setEditable(false);
        this.myListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1 && !WmiComboBox.this.ignoreSelectionChange) {
                    WmiComboBox.this.invokeCommand(itemEvent, itemEvent.getItem());
                }
            }
        };
        this.addItemListener(this.myListener);
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        boolean bl;
        boolean bl2 = bl = keyEvent.getKeyCode() == 10;
        if (!bl) {
            this.ignoreSelectionChange = true;
        }
        super.processKeyEvent(keyEvent);
        this.ignoreSelectionChange = false;
        if (bl) {
            this.invokeCommand(keyEvent, this.getItemAt(this.getSelectedIndex()));
        }
    }

    public boolean isIgnoreSelectionChange() {
        return this.ignoreSelectionChange;
    }

    public void setIgnoreSelectionChange(boolean bl) {
        this.ignoreSelectionChange = bl;
    }

    protected void invokeCommand(EventObject eventObject, Object object) {
        if (this.boxCmd != null) {
            Object object2 = null;
            if (eventObject != null) {
                object2 = eventObject.getSource();
            }
            WmiDataActionEvent wmiDataActionEvent = new WmiDataActionEvent(object2, 0, null, object);
            this.boxCmd.actionPerformed(wmiDataActionEvent);
            WmiMathDocumentView wmiMathDocumentView = WmiMathDocumentView.getActiveDocumentView();
            if (wmiMathDocumentView != null) {
                wmiMathDocumentView.requestFocus();
            }
        }
    }

    public void dispose() {
        if (this.myListener != null) {
            this.removeItemListener(this.myListener);
            this.myListener = null;
        }
        this.boxCmd = null;
    }

    private class MacComboBoxRenderer
    implements ListCellRenderer {
        private ListCellRenderer wrappedRenderer = null;

        public MacComboBoxRenderer(ListCellRenderer listCellRenderer) {
            this.wrappedRenderer = listCellRenderer;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JComponent jComponent = (JComponent)this.wrappedRenderer.getListCellRendererComponent(jList, object, n, bl, bl2);
            String string = "<empty>";
            if (object != null) {
                string = object instanceof String ? (String)object : object.toString();
            }
            Dimension dimension = new Dimension(string.length() * 8, 18);
            jComponent.setMaximumSize(dimension);
            jComponent.setPreferredSize(dimension);
            return jComponent;
        }
    }
}

