/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.template;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.NameDagFactory;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.template.BracketTemplate;
import com.maplesoft.client.prettyprinter.template.DivideTemplate;
import com.maplesoft.client.prettyprinter.template.PowerTemplate;
import com.maplesoft.client.prettyprinter.template.RootTemplate;
import com.maplesoft.client.prettyprinter.template.SpecialFunctionTemplate;
import com.maplesoft.client.prettyprinter.template.SubScriptTemplate;
import java.io.IOException;
import java.util.HashMap;

public class TypesettingTemplate
implements SpecialFunctionTemplate {
    protected static HashMap templateMap = new HashMap();

    public LayoutBox apply(LayoutFormatter layoutFormatter, Dag dag, Dag[] dagArray) {
        LayoutBox layoutBox = null;
        String string = dag.getChild(0).getData();
        SpecialFunctionTemplate specialFunctionTemplate = (SpecialFunctionTemplate)templateMap.get(string);
        if (specialFunctionTemplate != null) {
            layoutBox = specialFunctionTemplate.apply(layoutFormatter, dag, dagArray);
        }
        return layoutBox;
    }

    static {
        templateMap.put("Typesetting:-mfrac", new MFracTemplate());
        templateMap.put("Typesetting:-mi", new MITemplate());
        templateMap.put("Typesetting:-mmultiscripts", null);
        templateMap.put("Typesetting:-mscripts", null);
        templateMap.put("Typesetting:-mn", new MNTemplate());
        templateMap.put("Typesetting:-mo", new MOTemplate());
        templateMap.put("Typesetting:-mover", null);
        templateMap.put("Typesetting:-mambiguous", null);
        templateMap.put("Typesetting:-maction", null);
        templateMap.put("Typesetting:-mroot", null);
        templateMap.put("Typesetting:-mrow", new MRowTemplate());
        templateMap.put("Typesetting:-mspace", new MSpaceTemplate());
        templateMap.put("Typesetting:-msqrt", new MSqrtTemplate());
        templateMap.put("Typesetting:-ms", new MSTemplate());
        templateMap.put("Typesetting:-mstyle", null);
        templateMap.put("Typesetting:-msub", new MSubTemplate());
        templateMap.put("Typesetting:-msubsup", null);
        templateMap.put("Typesetting:-msup", new MSupTemplate());
        templateMap.put("Typesetting:-mtext", new MTextTemplate());
        templateMap.put("Typesetting:-merror", null);
        templateMap.put("Typesetting:-munder", null);
        templateMap.put("Typesetting:-mphantom", null);
        templateMap.put("Typesetting:-munderover", null);
        templateMap.put("Typesetting:-mprescripts", null);
        templateMap.put("Typesetting:-none", null);
        templateMap.put("Typesetting:-mfenced", new MFencedTemplate());
        templateMap.put("Typesetting:-mtable", null);
        templateMap.put("Typesetting:-mtr", null);
        templateMap.put("Typesetting:-mtd", null);
        templateMap.put("Typesetting:-mprintslash", new MPrintslashTemplate());
        templateMap.put("Typesetting:-mparsed", null);
        templateMap.put("Typesetting:-mverbatim", new MVerbatimTemplate());
    }

    public static class MVerbatimTemplate
    implements SpecialFunctionTemplate {
        public LayoutBox apply(LayoutFormatter layoutFormatter, Dag dag, Dag[] dagArray) {
            LayoutBox layoutBox = null;
            String string = dagArray[0].getData();
            try {
                Dag dag2 = DagBuilder.createDag(string);
                layoutBox = DagBuilder.createLayout(layoutFormatter, dag2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return layoutBox;
        }
    }

    public static class MPrintslashTemplate
    implements SpecialFunctionTemplate {
        public LayoutBox apply(LayoutFormatter layoutFormatter, Dag dag, Dag[] dagArray) {
            Dag dag2 = DagUtil.getDisplayDataFromPrintslash(dag);
            LayoutBox layoutBox = DagBuilder.createLayout(layoutFormatter, dag2);
            return layoutBox;
        }
    }

    private static class MFencedTemplate
    implements SpecialFunctionTemplate {
        private MFencedTemplate() {
        }

        public LayoutBox apply(LayoutFormatter layoutFormatter, Dag dag, Dag[] dagArray) {
            int n;
            InlineLayoutBox inlineLayoutBox = null;
            LayoutBox layoutBox = null;
            inlineLayoutBox = new InlineLayoutBox();
            String string = "(";
            String string2 = ")";
            for (n = 0; n < dagArray.length; ++n) {
                if (DagUtil.isFunction(dagArray[n])) {
                    LayoutBox layoutBox2 = DagBuilder.createLayout(layoutFormatter, dagArray[n]);
                    inlineLayoutBox.addChild(layoutBox2);
                    continue;
                }
                if (!DagUtil.isEquation(dagArray[n])) continue;
                if (dagArray[n].getChild(0).getData().equals("open")) {
                    string = dagArray[n].getChild(1).getData();
                    continue;
                }
                if (!dagArray[n].getChild(0).getData().equals("close")) continue;
                string2 = dagArray[n].getChild(1).getData();
            }
            n = this.getIDForBracketChar(string, true);
            int n2 = this.getIDForBracketChar(string2, false);
            layoutBox = BracketTemplate.apply(layoutFormatter, (LayoutBox)inlineLayoutBox, n, n2);
            return layoutBox;
        }

        private int getIDForBracketChar(String string, boolean bl) {
            int n = 91;
            if (string.equals(")")) {
                n = 92;
            } else if (string.equals("[")) {
                n = 95;
            } else if (string.equals("]")) {
                n = 96;
            } else if (string.equals("{")) {
                n = 93;
            } else if (string.equals("}")) {
                n = 94;
            } else if (string.length() == 0 && !bl) {
                n = 92;
            }
            return n;
        }
    }

    private static class MSupTemplate
    implements SpecialFunctionTemplate {
        private MSupTemplate() {
        }

        public LayoutBox apply(LayoutFormatter layoutFormatter, Dag dag, Dag[] dagArray) {
            LayoutBox layoutBox = null;
            LayoutBox layoutBox2 = DagBuilder.createLayout(layoutFormatter, dagArray[0]);
            LayoutBox layoutBox3 = DagBuilder.createLayout(layoutFormatter, dagArray[1]);
            layoutBox = PowerTemplate.apply(layoutFormatter, layoutBox2, layoutBox3);
            return layoutBox;
        }
    }

    private static class MSubTemplate
    implements SpecialFunctionTemplate {
        private MSubTemplate() {
        }

        public LayoutBox apply(LayoutFormatter layoutFormatter, Dag dag, Dag[] dagArray) {
            LayoutBox layoutBox = null;
            Dag dag2 = DagUtil.createTableRefDag(dagArray[0], dagArray[1]);
            layoutBox = SubScriptTemplate.apply(layoutFormatter, dag2);
            return layoutBox;
        }
    }

    private static class MSTemplate
    extends MTextTemplate {
        private MSTemplate() {
        }

        protected String getStringWrapperChar() {
            return "\"";
        }
    }

    private static class MTextTemplate
    implements SpecialFunctionTemplate {
        private MTextTemplate() {
        }

        public LayoutBox apply(LayoutFormatter layoutFormatter, Dag dag, Dag[] dagArray) {
            NotationLayoutBox notationLayoutBox = null;
            StringBuffer stringBuffer = new StringBuffer(this.getStringWrapperChar());
            stringBuffer.append(dagArray[0].getData());
            stringBuffer.append(this.getStringWrapperChar());
            notationLayoutBox = NotationLayoutBox.createCustomBox(layoutFormatter, stringBuffer.toString(), 4);
            return notationLayoutBox;
        }

        protected String getStringWrapperChar() {
            return "";
        }
    }

    private static class MSqrtTemplate
    implements SpecialFunctionTemplate {
        private static RootTemplate ROOT_FAC = new RootTemplate();

        private MSqrtTemplate() {
        }

        public LayoutBox apply(LayoutFormatter layoutFormatter, Dag dag, Dag[] dagArray) {
            LayoutBox layoutBox = null;
            layoutBox = ROOT_FAC.apply(layoutFormatter, dag, dagArray);
            layoutBox.applyLayout();
            return layoutBox;
        }
    }

    private static class MSpaceTemplate
    implements SpecialFunctionTemplate {
        private MSpaceTemplate() {
        }

        public LayoutBox apply(LayoutFormatter layoutFormatter, Dag dag, Dag[] dagArray) {
            NotationLayoutBox notationLayoutBox = null;
            notationLayoutBox = NotationLayoutBox.createCustomBox(layoutFormatter, " ", 5);
            return notationLayoutBox;
        }
    }

    private static class MOTemplate
    implements SpecialFunctionTemplate {
        private MOTemplate() {
        }

        public LayoutBox apply(LayoutFormatter layoutFormatter, Dag dag, Dag[] dagArray) {
            NotationLayoutBox notationLayoutBox = null;
            Dag dag2 = dagArray[0];
            String string = dag2.getData();
            string = this.substituteEntities(string);
            notationLayoutBox = NotationLayoutBox.createCustomBox(layoutFormatter, string, 5);
            return notationLayoutBox;
        }

        private String substituteEntities(String string) {
            String string2 = string;
            if (string2.equals("&InvisibleTimes;")) {
                string2 = " ";
            } else if (string2.equals("&plus;")) {
                string2 = " + ";
            } else if (string2.equals("&CenterDot;")) {
                string2 = " * ";
            } else if (string2.equals("&minus;")) {
                string2 = " - ";
            } else if (string2.startsWith("&") && string2.endsWith(";")) {
                string2 = string2.substring(1);
                string2 = string2.substring(0, string2.length() - 1);
            }
            return string2;
        }
    }

    private static class MNTemplate
    implements SpecialFunctionTemplate {
        private MNTemplate() {
        }

        public LayoutBox apply(LayoutFormatter layoutFormatter, Dag dag, Dag[] dagArray) {
            NotationLayoutBox notationLayoutBox = null;
            Dag dag2 = dagArray[0];
            String string = dag2.getData();
            notationLayoutBox = NotationLayoutBox.createCustomBox(layoutFormatter, string, 4);
            return notationLayoutBox;
        }
    }

    private static class MRowTemplate
    implements SpecialFunctionTemplate {
        private MRowTemplate() {
        }

        public LayoutBox apply(LayoutFormatter layoutFormatter, Dag dag, Dag[] dagArray) {
            InlineLayoutBox inlineLayoutBox = null;
            inlineLayoutBox = new InlineLayoutBox();
            for (int i = 0; i < dagArray.length; ++i) {
                if (!DagUtil.isFunction(dagArray[i]) || DagUtil.isFunctionNamed(dagArray[i], "Typesetting:-mi") && dagArray[i].getChild(0).getData().length() == 0) continue;
                LayoutBox layoutBox = DagBuilder.createLayout(layoutFormatter, dagArray[i]);
                inlineLayoutBox.addChild(layoutBox);
            }
            inlineLayoutBox.applyLayout();
            return inlineLayoutBox;
        }
    }

    private static class MITemplate
    implements SpecialFunctionTemplate {
        private static NameDagFactory NAME_FAC = new NameDagFactory();

        private MITemplate() {
        }

        public LayoutBox apply(LayoutFormatter layoutFormatter, Dag dag, Dag[] dagArray) {
            LayoutBox layoutBox = null;
            Dag dag2 = dagArray[0];
            layoutBox = NAME_FAC.createLayout(layoutFormatter, dag2);
            layoutBox.applyLayout();
            return layoutBox;
        }
    }

    private static class MFracTemplate
    implements SpecialFunctionTemplate {
        private MFracTemplate() {
        }

        public LayoutBox apply(LayoutFormatter layoutFormatter, Dag dag, Dag[] dagArray) {
            LayoutBox layoutBox = null;
            LayoutBox layoutBox2 = DagBuilder.createLayout(layoutFormatter, dagArray[0]);
            LayoutBox layoutBox3 = DagBuilder.createLayout(layoutFormatter, dagArray[1]);
            layoutBox2.applyLayout();
            layoutBox3.applyLayout();
            int n = 0;
            for (int i = 0; i < dagArray.length; ++i) {
                String string;
                Dag dag2 = dagArray[i];
                if (!DagUtil.isEquation(dag2) || !DagUtil.isNameNamed(dag2.getChild(0), "bevelled") || (string = dag2.getChild(1).getData()).equals("false")) continue;
                n = 1;
            }
            layoutBox = DivideTemplate.apply(layoutFormatter, layoutBox2, layoutBox3, n);
            layoutBox.applyLayout();
            return layoutBox;
        }
    }
}

