/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.template;

import com.maplesoft.client.dag.BranchDag;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.prettyprinter.DefaultLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutAnchor;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.LayoutVector;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import com.maplesoft.client.prettyprinter.selection.StandardSelectionData;
import com.maplesoft.client.prettyprinter.template.BracketTemplate;
import com.maplesoft.client.prettyprinter.template.MatrixTemplate;
import com.maplesoft.client.prettyprinter.template.SpecialFunctionTemplate;
import com.maplesoft.client.prettyprinter.template.VectorTemplate;
import java.util.HashMap;

public class RtableTemplate
implements SpecialFunctionTemplate {
    private static final String ARRAY_TYPE = "Array";
    private static final String DIMENSION_STRING = "-D ";
    private static final int NAME_POS = 0;
    private static final int FUNCTION_POS = 1;
    private static final int FUNCTION_ARG_POS = 1;
    private static final int DATA_TYPE_POS = 1;
    private static final int OBJECT_TYPE_POS = 2;
    private static final int STORAGE_POS = 3;
    private static final int ORDER_POS = 4;
    private static final int DIMENSION_COUNT_POS = 6;
    private static final int UPPER_RANGE_POS = 1;
    private static MatrixTemplate matrixFormatter = new MatrixTemplate();
    private static VectorTemplate vectorFormatter = new VectorTemplate();
    private static HashMap rtableMap = new HashMap();
    private static HashMap idTranslationMap = new HashMap();
    private static HashMap idAliasMap = new HashMap();

    public LayoutBox apply(LayoutFormatter layoutFormatter, Dag dag, Dag[] dagArray) {
        LayoutBox layoutBox = null;
        if (dagArray != null) {
            Dag dag2 = null;
            if (dagArray.length > 1) {
                dag2 = dagArray[0];
            }
            if (dag2 != null) {
                LayoutBox layoutBox2;
                Dag dag3;
                if (dag2.getType() == 2) {
                    long l = Long.parseLong(dag2.getData());
                    this.addRtableID(l, dag);
                }
                if ((dag3 = dagArray[1]).getType() == 18) {
                    Dag[] dagArray2;
                    String string = dag3.getChild(0).getData();
                    Dag dag4 = dag3.getChild(1);
                    Dag[] dagArray3 = dagArray2 = dag4 instanceof BranchDag ? ((BranchDag)dag4).getChildrenAsArray() : null;
                    if (dagArray2 != null) {
                        if (string.equals("MATRIX")) {
                            layoutBox = matrixFormatter.apply(layoutFormatter, dag, dagArray2);
                        } else if (string.equals("VECTOR")) {
                            layoutBox = vectorFormatter.apply(layoutFormatter, dag, dagArray2);
                        }
                    }
                } else if (dagArray.length > 6 && (layoutBox2 = this.createDimensionBox(layoutFormatter, dagArray)) != null) {
                    layoutBox = new DefaultLayoutBox();
                    layoutBox.addChild(layoutBox2);
                    layoutBox.addChild(this.createPropertyBox(layoutFormatter, dagArray, 1, "Data Type"));
                    layoutBox.addChild(this.createPropertyBox(layoutFormatter, dagArray, 3, "Storage"));
                    layoutBox.addChild(this.createPropertyBox(layoutFormatter, dagArray, 4, "Order"));
                    for (int i = 1; i < layoutBox.numChildren(); ++i) {
                        layoutBox.addLayoutAnchor(new LayoutAnchor(i - 1, LayoutVector.SOUTHWEST, i, LayoutVector.NORTHWEST));
                    }
                    layoutBox.applyLayout();
                    layoutBox.setBaseline(layoutBox.getHeight() / 2.0);
                    SelectionData selectionData = new SelectionData(2);
                    int[] nArray = new int[]{0, 1, 2, 3};
                    selectionData.setStandardEastWestArray(layoutBox);
                    selectionData.setTraversalNorthSouth(nArray);
                    layoutBox.setSelectionData(selectionData);
                    layoutBox = BracketTemplate.apply(layoutFormatter, layoutBox, 95, 96);
                }
            }
        }
        return layoutBox;
    }

    private LayoutBox createDimensionBox(LayoutFormatter layoutFormatter, Dag[] dagArray) {
        Object object;
        NotationLayoutBox notationLayoutBox = null;
        boolean bl = false;
        Dag dag = dagArray[6];
        Dag dag2 = dagArray[2];
        String string = dag2 != null ? DagBuilder.lPrint(dag2) : "";
        int n = Integer.parseInt(DagBuilder.lPrint(dag));
        StringBuffer stringBuffer = new StringBuffer(" ");
        if (n == 1) {
            object = dagArray[7];
            stringBuffer.append(DagBuilder.lPrint((Dag)object));
        } else {
            for (int i = 1; i <= n; ++i) {
                Dag dag3 = dagArray[6 + i];
                if (dag3.getType() == 35) {
                    Dag dag4 = dag3.getChild(1);
                    stringBuffer.append(DagBuilder.lPrint(dag4));
                    if (i >= n) continue;
                    stringBuffer.append(" x ");
                    continue;
                }
                bl = true;
                break;
            }
        }
        if (string.equals(ARRAY_TYPE)) {
            stringBuffer.append(" ");
            stringBuffer.append(n);
            stringBuffer.append(DIMENSION_STRING);
        }
        if (!bl) {
            stringBuffer.append(" ");
            stringBuffer.append(string);
            stringBuffer.append(" ");
            notationLayoutBox = NotationLayoutBox.createCustomBox(layoutFormatter, stringBuffer.toString());
            object = new StandardSelectionData(4);
            notationLayoutBox.setSelectionData((SelectionData)object);
        }
        return notationLayoutBox;
    }

    private LayoutBox createPropertyBox(LayoutFormatter layoutFormatter, Dag[] dagArray, int n, String string) {
        StringBuffer stringBuffer = new StringBuffer(" ");
        stringBuffer.append(string);
        stringBuffer.append(": ");
        if (dagArray.length > n) {
            stringBuffer.append(DagBuilder.lPrint(dagArray[n]));
            stringBuffer.append(" ");
        }
        NotationLayoutBox notationLayoutBox = NotationLayoutBox.createCustomBox(layoutFormatter, stringBuffer.toString());
        StandardSelectionData standardSelectionData = new StandardSelectionData(4);
        notationLayoutBox.setSelectionData(standardSelectionData);
        return notationLayoutBox;
    }

    public static long getCorretedRTableID(long l) {
        long l2 = l;
        Long l3 = new Long(l);
        if (!rtableMap.containsKey(l3) && idAliasMap.containsKey(l3)) {
            l2 = (Long)idAliasMap.get(l3);
        }
        return l2;
    }

    private void addRtableID(long l, Dag dag) {
        Long l2 = new Long(l);
        if (idTranslationMap.containsKey(l2)) {
            Long l3 = (Long)idTranslationMap.get(l2);
            idAliasMap.put(l2, l3);
            l2 = l3;
            if (l2 != null) {
                RtableTemplate.updateRTableID(dag, l2);
                rtableMap.put(l2, dag);
            }
            idTranslationMap.remove(l2);
        }
        rtableMap.put(l2, dag);
    }

    public static boolean containsRTableID(long l) {
        return rtableMap.containsKey(new Long(l));
    }

    public static void release(long l) {
        Long l2 = new Long(l);
        rtableMap.remove(l2);
        idAliasMap.remove(l2);
    }

    public static void addRTableTranslation(long l, long l2) {
        if (RtableTemplate.containsRTableID(l)) {
            Long l3 = new Long(l);
            Long l4 = new Long(l2);
            Dag dag = (Dag)rtableMap.get(l3);
            if (dag != null) {
                RtableTemplate.updateRTableID(dag, l2);
                rtableMap.remove(l3);
                idAliasMap.put(l3, l4);
                rtableMap.put(l4, dag);
            }
        } else {
            idTranslationMap.put(new Long(l), new Long(l2));
        }
    }

    public static void updateRTableID(Dag dag, long l) {
        Dag dag2 = dag.getChild(1);
        dag2.setChild(0, Dag.createDag(2, null, Long.toString(l), false));
    }
}

