/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.template;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.FunctionDagFactory;
import com.maplesoft.client.prettyprinter.DefaultLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutAnchor;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.LayoutVector;
import com.maplesoft.client.prettyprinter.ResizableNotationBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import com.maplesoft.client.prettyprinter.selection.StandardSelectionData;
import com.maplesoft.client.prettyprinter.template.SpecialFunctionTemplate;

public class RootTemplate
implements SpecialFunctionTemplate {
    private static SelectionData sd;

    public LayoutBox apply(LayoutFormatter layoutFormatter, Dag dag, Dag[] dagArray) {
        LayoutBox layoutBox = new RootLayoutBox();
        if (dagArray != null && dagArray.length > 0) {
            layoutBox = RootTemplate.applyRoot(layoutBox, layoutFormatter, dagArray[0]);
            layoutBox.applyLayout();
            if (layoutBox.getWidth() > layoutFormatter.getSafeBreakWidth()) {
                layoutBox = FunctionDagFactory.createGenericLayout(layoutFormatter, dag);
            }
        }
        return layoutBox;
    }

    public static LayoutBox apply(LayoutBox layoutBox, LayoutFormatter layoutFormatter, Dag dag) {
        int n;
        if (!(layoutBox instanceof RootLayoutBox)) {
            RootLayoutBox rootLayoutBox = new RootLayoutBox();
            layoutBox.addChild(rootLayoutBox);
            layoutBox = rootLayoutBox;
        }
        if ((n = dag.getLength()) != 2) {
            return null;
        }
        layoutBox = RootTemplate.applyRoot(layoutBox, layoutFormatter, dag.getChild(0));
        layoutBox.applyLayout();
        if (layoutBox.getWidth() > layoutFormatter.getSafeBreakWidth()) {
            Dag[] dagArray = new Dag[1];
            Dag[] dagArray2 = new Dag[2];
            dagArray[0] = dag.getChild(0);
            Dag dag2 = Dag.createDag(29, dagArray, null, false);
            dagArray2[0] = Dag.createDag(8, null, "sqrt", false);
            dagArray2[1] = dag2;
            Dag dag3 = Dag.createDag(18, dagArray2, null, false);
            layoutBox = FunctionDagFactory.createGenericLayout(layoutFormatter, dag3);
        }
        return layoutBox;
    }

    public static LayoutBox applyRoot(LayoutBox layoutBox, LayoutFormatter layoutFormatter, Dag dag) {
        LayoutBox layoutBox2 = DagBuilder.createLayout(layoutFormatter, dag);
        ResizableNotationBox resizableNotationBox = new ResizableNotationBox(layoutFormatter, 99, 2, layoutBox2, layoutBox2);
        if (sd == null) {
            sd = new StandardSelectionData(4);
            sd.setContextHelpAvailable(false);
        }
        resizableNotationBox.setSelectionData(sd);
        layoutBox.addChild(resizableNotationBox);
        layoutBox.addChild(layoutBox2);
        layoutBox.addLayoutAnchor(new LayoutAnchor(0, LayoutVector.SOUTHEAST, 1, LayoutVector.SOUTHEAST));
        int[] nArray = new int[]{0, 1};
        SelectionData selectionData = new SelectionData(1);
        selectionData.setFirstCaretPosition(0);
        selectionData.setLastCaretPosition(1);
        selectionData.setStandardNorthSouthArray();
        selectionData.setTraversalEastWest(nArray);
        layoutBox.setSelectionData(selectionData);
        layoutBox.setRightSideBearing(2.0 * layoutFormatter.getBearingMultiplier());
        layoutBox.setLineBreaker(LineBreakerFactory.newLineBreaker((int)5));
        return layoutBox;
    }

    public static class RootLayoutBox
    extends DefaultLayoutBox {
        public RootLayoutBox() {
            super("sqrt", 2);
        }

        protected LayoutBox getReferenceForBaseline() {
            return this.getChild(1);
        }
    }
}

