/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.template;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.prettyprinter.DefaultLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutAnchor;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.MatrixLayoutBox;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.ResizableNotationBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import com.maplesoft.client.prettyprinter.selection.StandardSelectionData;
import com.maplesoft.client.prettyprinter.template.BracketTemplate;
import com.maplesoft.client.prettyprinter.template.SpecialFunctionTemplate;

public class MatrixTemplate
implements SpecialFunctionTemplate {
    public LayoutBox apply(LayoutFormatter layoutFormatter, Dag dag, Dag[] dagArray) {
        LayoutBox layoutBox = null;
        if (dagArray != null) {
            if (dagArray.length == 1 && dagArray[0].getType() == 30) {
                layoutBox = this.buildMatrix(layoutFormatter, dagArray);
            } else if (dagArray.length >= 2 && dagArray[0].getType() == 30 && dagArray[1].getType() == 30) {
                boolean bl;
                Dag dag2 = dagArray[0];
                Dag dag3 = dagArray[1];
                Dag dag4 = null;
                if (dagArray.length > 2) {
                    dag4 = dagArray[2];
                }
                String string = dag4 != null ? DagBuilder.lPrint(dag4) : null;
                boolean bl2 = bl = string != null ? string.equals("\"field\"") : false;
                if (dag2.getLength() == dag3.getLength()) {
                    layoutBox = this.buildBasisVector(layoutFormatter, dag2, dag3, bl);
                }
            }
        }
        return layoutBox;
    }

    public LayoutBox buildMatrix(LayoutFormatter layoutFormatter, Dag[] dagArray) {
        Object object;
        LayoutBox layoutBox = null;
        boolean bl = false;
        boolean bl2 = true;
        int n = 0;
        int n2 = 0;
        Dag dag = dagArray[0];
        int n3 = dag.getLength();
        int n4 = -1;
        for (n = 0; n < n3; ++n) {
            object = dag.getChild(n);
            if (((Dag)object).getType() != 30) {
                bl = true;
                break;
            }
            if (n4 > 0 && ((Dag)object).getLength() != n4) {
                bl = true;
                break;
            }
            if (n4 >= 0) continue;
            n4 = ((Dag)object).getLength();
        }
        if (!bl) {
            Object object2;
            Object object3;
            object = null;
            layoutBox = new MatrixLayoutBox(n3, n4, 1);
            if (n3 > 1) {
                ((MatrixLayoutBox)layoutBox).setBaselineFudgeFactor(layoutFormatter.getFontHeight(1) / 2.0);
            } else {
                ((MatrixLayoutBox)layoutBox).setBaselineFudgeFactor(layoutFormatter.getFontHeight(1) / 6.0);
            }
            for (n = 0; n < n3; ++n) {
                object3 = dag.getChild(n);
                for (n2 = 0; n2 < n4; ++n2) {
                    object2 = new StandardSelectionData(4);
                    LayoutBox layoutBox2 = DagBuilder.createLayout(layoutFormatter, ((Dag)object3).getChild(n2));
                    layoutBox2.setSelectionData((SelectionData)object2);
                    layoutBox.addChild(layoutBox2);
                    Object object4 = object = object == null ? layoutBox2 : object;
                    if (!bl2 || DagUtil.isNumeric(((Dag)object3).getChild(n2))) continue;
                    bl2 = false;
                }
            }
            ((MatrixLayoutBox)layoutBox).setJustification(bl2 ? 2 : 1);
            ((MatrixLayoutBox)layoutBox).setSeparators(layoutFormatter.getRowSeparator(), layoutFormatter.getColumnSeparator());
            layoutBox.applyLayout();
            if (n3 == 1) {
                layoutBox.setBaseline(object.getBaseline());
            } else if (layoutBox.getHeight() > layoutFormatter.getFontHeight(0)) {
                layoutBox.setBaseline(layoutBox.getHeight() / 2.0);
            }
            if (layoutBox.numChildren() > 0) {
                object3 = new SelectionData(2);
                object2 = new int[n3 * n4 + 1];
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < n3; ++j) {
                        object2[j + i * n3] = i + j * n4;
                    }
                    object2[n3 * (i + 1)] = -10;
                }
                ((SelectionData)object3).setTraversalNorthSouth((int[])object2);
                ((SelectionData)object3).setStandardEastWestArray(layoutBox);
                layoutBox.setSelectionData((SelectionData)object3);
            }
            layoutBox = BracketTemplate.apply(layoutFormatter, layoutBox, 95, 96);
            layoutBox.applyLayout();
            if (layoutBox.getWidth() < layoutFormatter.getSafeBreakWidth()) {
                layoutBox.setLineBreaker(LineBreakerFactory.newLineBreaker((int)5));
            } else {
                layoutBox = DagBuilder.createLayout(layoutFormatter, dagArray[0]);
            }
        }
        return layoutBox;
    }

    public LayoutBox buildBasisVector(LayoutFormatter layoutFormatter, Dag dag, Dag dag2, boolean bl) {
        Dag dag3 = null;
        DefaultLayoutBox defaultLayoutBox = new DefaultLayoutBox("BasisVector");
        int n = dag.getLength();
        for (int i = 0; i < n; ++i) {
            dag3 = dag.getChild(i);
            if (dag3.getType() == 30) {
                dag3 = dag3.getChild(0);
            }
            this.addBasisVectorTerm(layoutFormatter, defaultLayoutBox, dag3, dag2.getChild(i), bl);
        }
        if (defaultLayoutBox.numChildren() == 0) {
            defaultLayoutBox.addChild(NotationLayoutBox.createCustomBox(layoutFormatter, "0 "));
            defaultLayoutBox.addChild(this.createBasisVectorCoordinate(layoutFormatter, dag2.getChild(0), bl));
            defaultLayoutBox.addLayoutAnchor(LayoutAnchor.INLINE_01);
        }
        SelectionData selectionData = new SelectionData(1);
        selectionData.setStandardNorthSouthArray();
        selectionData.setStandardEastWestArray(defaultLayoutBox);
        defaultLayoutBox.setSelectionData(selectionData);
        return defaultLayoutBox;
    }

    public void addBasisVectorTerm(LayoutFormatter layoutFormatter, LayoutBox layoutBox, Dag dag, Dag dag2, boolean bl) {
        boolean bl2 = true;
        LayoutBox layoutBox2 = null;
        if (dag.getType() == 29) {
            dag = dag.getChild(0);
        }
        boolean bl3 = false;
        if (dag.getType() == 16 && dag.getLength() == 2) {
            bl3 = true;
        }
        if (DagUtil.isOne(dag)) {
            layoutBox2 = this.createBasisVectorCoordinate(layoutFormatter, dag2, bl);
        } else if (DagUtil.isMinusOne(dag)) {
            layoutBox2 = this.createBasisVectorCoordinate(layoutFormatter, dag2, bl);
            bl2 = false;
        } else if (!DagUtil.isZero(dag)) {
            Dag[] dagArray;
            if (layoutBox.numChildren() > 0) {
                if (DagUtil.isNegative(dag)) {
                    dag = DagUtil.negate(dag);
                    bl2 = false;
                } else if (bl3 && DagUtil.isNegative(dag.getChild(1))) {
                    dagArray = new Dag[]{dag.getChild(0), DagUtil.negate(dag.getChild(1))};
                    dag = Dag.createDag(16, dagArray, null, false);
                    bl2 = false;
                }
            }
            layoutBox2 = new DefaultLayoutBox("Term");
            dagArray = DagBuilder.createLayout(layoutFormatter, dag);
            if (!bl3) {
                dagArray = BracketTemplate.apply(layoutFormatter, (LayoutBox)dagArray, dag, 4);
            }
            layoutBox2.addChild((LayoutBox)dagArray);
            layoutBox2.addChild(NotationLayoutBox.createNotationBox(layoutFormatter, 76));
            layoutBox2.addChild(this.createBasisVectorCoordinate(layoutFormatter, dag2, bl));
            layoutBox2.addLayoutAnchor(LayoutAnchor.INLINE_01);
            layoutBox2.addLayoutAnchor(LayoutAnchor.INLINE_12);
        }
        if (layoutBox2 != null) {
            int n = layoutBox.numChildren();
            if (n != 0) {
                NotationLayoutBox notationLayoutBox = NotationLayoutBox.createNotationBox(layoutFormatter, bl2 ? 1 : 2);
                layoutBox.addChild(notationLayoutBox);
            } else if (n == 0 && !bl2) {
                layoutBox.addChild(NotationLayoutBox.createNotationBox(layoutFormatter, 24));
            }
            layoutBox.addChild(layoutBox2);
            while (n < layoutBox.numChildren()) {
                if (n > 0) {
                    layoutBox.addLayoutAnchor(LayoutAnchor.createLeftToRightAnchor(n - 1));
                }
                ++n;
            }
        }
    }

    public LayoutBox createBasisVectorCoordinate(LayoutFormatter layoutFormatter, Dag dag, boolean bl) {
        DefaultLayoutBox defaultLayoutBox = new DefaultLayoutBox("Coordinate");
        NotationLayoutBox notationLayoutBox = NotationLayoutBox.createCustomBox(layoutFormatter, "e");
        defaultLayoutBox.addChild(notationLayoutBox);
        layoutFormatter.incSuperscriptCount();
        if (dag.getType() == 7) {
            defaultLayoutBox.addChild(NotationLayoutBox.createCustomBox(layoutFormatter, dag.getData()));
        } else {
            defaultLayoutBox.addChild(DagBuilder.createLayout(layoutFormatter, dag));
        }
        layoutFormatter.decSuperscriptCount();
        defaultLayoutBox.addLayoutAnchor(LayoutAnchor.SUBSCRIPT_10);
        if (bl) {
            ResizableNotationBox resizableNotationBox = new ResizableNotationBox(layoutFormatter, 105, 1, notationLayoutBox);
            defaultLayoutBox.addChild(resizableNotationBox);
            defaultLayoutBox.addLayoutAnchor(LayoutAnchor.UNDER_02);
        }
        return defaultLayoutBox;
    }
}

