/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.template;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.template.BracketTemplate;
import com.maplesoft.client.prettyprinter.template.SpecialFunctionTemplate;

public class InfixNotationTemplate
implements SpecialFunctionTemplate {
    private int notationID;
    private int precedence;
    private String keyword;
    private int minSize;
    private int maxSize;
    private double leftBearing;
    private double rightBearing;
    private boolean precedenceGreaterEqual = false;

    public InfixNotationTemplate(String string, int n, int n2, int n3, int n4) {
        this(string, n, n2, n3, n4, 0.0, 0.0, false);
    }

    public InfixNotationTemplate(String string, int n, int n2, int n3, int n4, double d, double d2) {
        this(string, n, n2, n3, n4, d, d2, false);
    }

    public InfixNotationTemplate(String string, int n, int n2, int n3, int n4, double d, double d2, boolean bl) {
        this.keyword = string;
        this.notationID = n;
        this.precedence = n2;
        this.minSize = n3;
        this.maxSize = n4;
        this.leftBearing = d;
        this.rightBearing = d2;
        this.precedenceGreaterEqual = bl;
    }

    public LayoutBox apply(LayoutFormatter layoutFormatter, Dag dag, Dag[] dagArray) {
        InfixLayoutBox infixLayoutBox = null;
        if (dagArray != null && dagArray.length >= this.minSize && dagArray.length <= this.maxSize) {
            infixLayoutBox = new InfixLayoutBox(layoutFormatter, this.keyword, this.notationID, dagArray, this.precedence, this.leftBearing, this.rightBearing, this.precedenceGreaterEqual);
        }
        return infixLayoutBox;
    }

    static class InfixLayoutBox
    extends InlineLayoutBox {
        InfixLayoutBox(LayoutFormatter layoutFormatter, String string, int n, Dag[] dagArray, int n2, double d, double d2, boolean bl) {
            super(dagArray.length * 2 - 1);
            LayoutBox layoutBox = DagBuilder.createLayout(layoutFormatter, dagArray[0]);
            layoutBox = BracketTemplate.apply(layoutFormatter, layoutBox, dagArray[0], n2, bl ? 0 : 1);
            this.addChild(layoutBox);
            for (int i = 1; i < dagArray.length; ++i) {
                this.addChild(this.buildNotation(layoutFormatter, string, n, layoutBox, d, d2));
                LayoutBox layoutBox2 = DagBuilder.createLayout(layoutFormatter, dagArray[i]);
                layoutBox2 = BracketTemplate.apply(layoutFormatter, layoutBox2, dagArray[i], n2, bl ? 0 : 1);
                layoutBox2.applyLayout();
                this.addChild(layoutBox2);
            }
        }

        InfixLayoutBox() {
        }

        public NotationLayoutBox buildNotation(LayoutFormatter layoutFormatter, String string, int n, LayoutBox layoutBox, double d, double d2) {
            NotationLayoutBox notationLayoutBox = null;
            notationLayoutBox = layoutFormatter.isInProc() ? layoutFormatter.createNotationBox(174, string, 2) : NotationLayoutBox.createNotationBox(layoutFormatter, n);
            if (notationLayoutBox.getHeight() == 0.0) {
                notationLayoutBox.setSize(7.0, layoutFormatter.getFontHeight(1));
                if (layoutFormatter.getFontHeight(1) != 1.0) {
                    notationLayoutBox.setBaseline(notationLayoutBox.getHeight());
                }
            }
            notationLayoutBox.setLeftSideBearing(d * layoutFormatter.getBearingMultiplier());
            notationLayoutBox.setRightSideBearing(d2 * layoutFormatter.getBearingMultiplier());
            return notationLayoutBox;
        }
    }
}

