/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.selection;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.selection.EquationSelectionEvent;
import com.maplesoft.client.prettyprinter.selection.EquationSelectionListener;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;

public class EquationSelectionRecorder
implements EquationSelectionListener {
    private static EquationSelectionRecorder instance;
    private Dag selectedDag;
    private LayoutBox selectedBox;
    private LayoutBox rootBox;
    private List selectedList;
    private EventObject selectionTrigger;
    boolean haltUpdateForForcedSelection = false;

    private EquationSelectionRecorder() {
    }

    public static EquationSelectionRecorder getInstance() {
        if (instance == null) {
            instance = new EquationSelectionRecorder();
        }
        return instance;
    }

    public void contextRequest(EquationSelectionEvent equationSelectionEvent) {
    }

    public void actionRequest(EquationSelectionEvent equationSelectionEvent) {
    }

    public void forceRecordsClear() {
        this.selectedDag = null;
        this.selectedBox = null;
        this.selectedList = null;
        this.selectionTrigger = null;
        this.rootBox = null;
        this.haltUpdateForForcedSelection = false;
    }

    public void forceRecordSelection(Dag dag, LayoutBox layoutBox, LayoutBox layoutBox2) {
        this.selectedDag = dag;
        this.selectedBox = layoutBox2;
        this.selectedList = new LinkedList();
        this.selectedList.add(layoutBox2);
        this.rootBox = layoutBox;
        this.haltUpdateForForcedSelection = true;
    }

    public void selectionChanged(EquationSelectionEvent equationSelectionEvent) {
        if (this.haltUpdateForForcedSelection) {
            this.haltUpdateForForcedSelection = false;
        } else if (equationSelectionEvent.isClearedSelection()) {
            this.forceRecordsClear();
        } else {
            this.selectedDag = equationSelectionEvent.getDag();
            this.selectedBox = equationSelectionEvent.getSelectedBox();
            this.selectedList = equationSelectionEvent.getMultiSelectedBoxes();
            this.rootBox = equationSelectionEvent.getRootBox();
            this.selectionTrigger = equationSelectionEvent.getSourceEvent();
        }
    }

    public Dag getSelectedDag() {
        return this.selectedDag;
    }

    public LayoutBox getSelectedBox() {
        return this.selectedBox;
    }

    public List getMultiSelectionList() {
        return this.selectedList;
    }

    public EventObject getSelectionTrigger() {
        return this.selectionTrigger;
    }

    public LayoutBox getRootBox() {
        return this.rootBox;
    }
}

