/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter;

import com.maplesoft.client.prettyprinter.BracketLayoutBox;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;

public class TTYBracketLayoutBox
extends BracketLayoutBox {
    private static final char LEFT_PAREN = '(';
    private static final char RIGHT_PAREN = ')';
    private static final char LEFT_BRACKET = '[';
    private static final char RIGHT_BRACKET = ']';
    private static final char LEFT_BRACE = '{';
    private static final char RIGHT_BRACE = '}';
    private static final char ABSOLUTE_BAR = '|';
    private static final char LOW_LEFT_PAREN = '\\';
    private static final char UPPER_LEFT_PAREN = '/';
    private static final char LEFT_PAREN_FILL = '|';
    private static final char LOW_LEFT_BRACKET = '[';
    private static final char UPPER_LEFT_BRACKET = '[';
    private static final char LEFT_BRACKET_FILL = '[';
    private static final char LOW_RIGHT_PAREN = '/';
    private static final char UPPER_RIGHT_PAREN = '\\';
    private static final char RIGHT_PAREN_FILL = '|';
    private static final char LOW_RIGHT_BRACKET = ']';
    private static final char UPPER_RIGHT_BRACKET = ']';
    private static final char RIGHT_BRACKET_FILL = ']';
    private static final char INTEGRAL_SMALL = 'S';
    private static final char INTEGRAL_TOP = '/';
    private static final char INTEGRAL_BOTTOM = '/';
    private static final char INTEGRAL_FILL = '|';
    private static final char LOW_LEFT_BRACE = '\\';
    private static final char UPPER_LEFT_BRACE = '/';
    private static final char LEFT_BRACE_FILL = '|';
    private static final char LEFT_BRACE_MIDDLE = '<';
    private static final char LOW_RIGHT_BRACE = '/';
    private static final char UPPER_RIGHT_BRACE = '\\';
    private static final char RIGHT_BRACE_FILL = '|';
    private static final char RIGHT_BRACE_MIDDLE = '>';
    private static final int FIXED_INTEGRAL_HEIGHT = 5;
    private static final int MIN_INTEGRAL_HEIGHT = 3;
    private static final int MAX_INTEGRAL_HEIGHT = 5;
    private TTYBracket bracket = null;

    public TTYBracketLayoutBox(int n) {
        super(n);
        switch (n) {
            case 91: {
                this.bracket = new LeftParen();
                break;
            }
            case 92: {
                this.bracket = new RightParen();
                break;
            }
            case 93: {
                this.bracket = new LeftBrace();
                break;
            }
            case 94: {
                this.bracket = new RightBrace();
                break;
            }
            case 103: 
            case 106: {
                this.bracket = new LeftAbsolute();
                break;
            }
            case 104: {
                this.bracket = new RightAbsolute();
                break;
            }
            case 95: {
                this.bracket = new LeftBracket();
                break;
            }
            case 96: {
                this.bracket = new RightBracket();
                break;
            }
            case 97: {
                this.bracket = new IntegralBracket();
            }
        }
    }

    public void drawBracket(char[][] cArray, int n, int n2) {
        if (this.bracket != null) {
            this.bracket.drawBracket(cArray, n, n2);
        }
    }

    public void setSize(double d, double d2) {
        if (this.bracket != null) {
            super.setSize(d, d2);
            this.bracket.setSize(d, d2);
        }
    }

    protected static class RightBrace
    extends TTYBrace {
        protected RightBrace() {
            super(94, '}', '/', '|', '>', '\\');
        }
    }

    protected static class LeftBrace
    extends TTYBrace {
        protected LeftBrace() {
            super(93, '{', '\\', '|', '<', '/');
        }
    }

    protected static class RightAbsolute
    extends TTYBracket {
        protected RightAbsolute() {
            super(104, '|', '|', '|', '|');
        }
    }

    protected static class LeftAbsolute
    extends TTYBracket {
        protected LeftAbsolute() {
            super(103, '|', '|', '|', '|');
        }
    }

    protected static class RightBracket
    extends TTYBracket {
        protected RightBracket() {
            super(96, ']', ']', ']', ']');
        }
    }

    protected static class LeftBracket
    extends TTYBracket {
        protected LeftBracket() {
            super(95, '[', '[', '[', '[');
        }
    }

    protected static class RightParen
    extends TTYBracket {
        protected RightParen() {
            super(92, ')', '/', '|', '\\');
        }
    }

    protected static class LeftParen
    extends TTYBracket {
        protected LeftParen() {
            super(91, '(', '\\', '|', '/');
        }
    }

    protected static class IntegralBracket
    extends TTYBracket {
        protected IntegralBracket() {
            super(97, 'S', '/', '|', '/');
        }

        public void drawBracket(char[][] cArray, int n, int n2) {
            int n3 = (int)this.getHeight();
            ++n;
            if (n3 < 2) {
                cArray[n2][n] = this.single;
            } else {
                cArray[n2][n + 1] = this.top;
                for (int i = 1; i < n3 - 1; ++i) {
                    cArray[n2 + i][n] = this.fill;
                }
                cArray[n2 + n3 - 1][n - 1] = this.bottom;
            }
        }
    }

    protected static class TTYBrace
    extends TTYBracket {
        private char middle;

        protected TTYBrace(int n, char c, char c2, char c3, char c4, char c5) {
            super(n, c, c2, c3, c5);
            this.middle = c4;
        }

        public void drawBracket(char[][] cArray, int n, int n2) {
            int n3 = (int)this.getHeight();
            int n4 = 1;
            int n5 = 0;
            if (this.single == '}') {
                n4 = 0;
                n5 = 1;
            }
            if (n3 == 1) {
                cArray[n2][n] = this.single;
            } else if (n3 < 4) {
                cArray[n2][n + n4] = this.top;
                cArray[n2 + 1][n + n5] = this.single;
                cArray[n2 + 2][n + n4] = this.bottom;
            } else {
                cArray[n2][n + n4] = this.top;
                for (int i = 1; i < n3 - 1; ++i) {
                    cArray[n2 + i][n + n4] = this.fill;
                }
                cArray[n2 + n3 / 2][n + n5] = this.middle;
                cArray[n2 + n3 / 2][n + n4] = 32;
                cArray[n2 + n3 - 1][n + n4] = this.bottom;
            }
        }
    }

    protected static class TTYBracket
    extends NotationLayoutBox {
        protected char single;
        protected char bottom;
        protected char fill;
        protected char top;

        protected TTYBracket(int n, char c, char c2, char c3, char c4) {
            super(n);
            this.single = c;
            this.bottom = c2;
            this.fill = c3;
            this.top = c4;
        }

        public void drawBracket(char[][] cArray, int n, int n2) {
            int n3 = (int)this.getHeight();
            if (n2 > cArray.length - 1) {
                System.out.println("drawBracket: out of bounds! " + this.single);
                System.out.println("yoffset: " + n2 + ", height: " + n3 + ", out.length: " + cArray.length);
            } else if (n3 < 2) {
                cArray[n2][n] = this.single;
            } else {
                cArray[n2][n] = this.top;
                for (int i = 1; i < n3 - 1; ++i) {
                    cArray[n2 + i][n] = this.fill;
                }
                cArray[n2 + n3 - 1][n] = this.bottom;
            }
        }
    }
}

