/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.prettyprinter.AbstractFormatter;
import com.maplesoft.client.prettyprinter.DefaultLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.PostLayoutJobQueue;

public class SubexpressionLabelLayoutBox
extends DefaultLayoutBox {
    private LayoutBox target;
    private LayoutBox renderer;
    private int labelNumber;
    private String label;
    private String lprint;

    public SubexpressionLabelLayoutBox(LayoutFormatter layoutFormatter, LayoutBox layoutBox, String string) {
        this.target = layoutBox;
        this.lprint = string;
        PostLayoutJobQueue postLayoutJobQueue = layoutFormatter.getPostLayoutJobQueue();
        boolean bl = postLayoutJobQueue.containsJobForIdentifier(string);
        if (bl) {
            AbstractFormatter.SubexpressionLabelJob subexpressionLabelJob = (AbstractFormatter.SubexpressionLabelJob)postLayoutJobQueue.getJob(string);
            this.labelNumber = subexpressionLabelJob.getSubexpressionBox().getLabelNumber();
        } else {
            this.labelNumber = postLayoutJobQueue.getSubexpressionNumber();
            ++this.labelNumber;
            postLayoutJobQueue.setSubexpressionNumber(this.labelNumber);
        }
        this.renderer = layoutFormatter.createNotationBox(174, this.getLabel(), 1);
        this.addChild(this.renderer);
        this.setSize(this.renderer.getWidth(), this.renderer.getHeight());
        this.setBaseline(this.renderer.getBaseline());
        if (!bl) {
            postLayoutJobQueue.addJob(string, new AbstractFormatter.SubexpressionLabelJob(layoutFormatter, this));
        }
    }

    public void setLabelTarget(LayoutBox layoutBox) {
        this.target = layoutBox;
    }

    public String getLPrint() {
        return this.lprint;
    }

    public LayoutBox getLabelTarget() {
        return this.target;
    }

    public int getLabelNumber() {
        return this.labelNumber;
    }

    public LayoutBox getRenderer() {
        return this.renderer;
    }

    public Dag getDag() {
        Dag dag = null;
        if (this.target != null) {
            dag = this.target.getDag();
        }
        return dag;
    }

    public String getLabel() {
        if (this.label == null) {
            this.label = "%" + this.labelNumber;
        }
        return this.label;
    }

    public String getData() {
        return this.getLabel();
    }
}

