/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter;

import com.maplesoft.client.prettyprinter.LayoutPoint;

public class LayoutVector {
    public static final LayoutVector NORTH = new LayoutVector("center", "bottom");
    public static final LayoutVector NORTHEAST = new LayoutVector("right", "bottom");
    public static final LayoutVector EAST = new LayoutVector("right", "center");
    public static final LayoutVector SOUTHEAST = new LayoutVector("right", "top");
    public static final LayoutVector SOUTH = new LayoutVector("center", "top");
    public static final LayoutVector SOUTHWEST = new LayoutVector("left", "top");
    public static final LayoutVector WEST = new LayoutVector("left", "center");
    public static final LayoutVector NORTHWEST = new LayoutVector("left", "bottom");
    private String origWidth = "";
    private String origHeight = "";
    private double width;
    private double height;

    public LayoutVector(String string, String string2) {
        this.origWidth = string;
        this.origHeight = string2;
        if (this.origWidth.equals("left")) {
            this.width = 0.0;
        } else if (this.origWidth.equals("center")) {
            this.width = 0.5;
        } else if (this.origWidth.equals("right")) {
            this.width = 1.0;
        }
        if (this.origHeight.equals("top")) {
            this.height = 1.0;
        } else if (this.origHeight.equals("center")) {
            this.height = 0.5;
        } else if (this.origHeight.equals("bottom")) {
            this.height = 0.0;
        }
    }

    public LayoutVector(double d, double d2) {
        this.width = d;
        this.height = d2;
    }

    public String toString() {
        String string = "LayoutVector: ";
        string = string + this.origWidth + " " + this.width + " ";
        string = string + this.origHeight + " " + this.height + "\n";
        return string;
    }

    public LayoutPoint subtract(LayoutVector layoutVector) {
        return new LayoutPoint(this.width - layoutVector.getWidth(), this.height - layoutVector.getHeight());
    }

    public LayoutVector add(LayoutPoint layoutPoint) {
        return new LayoutVector(this.width + layoutPoint.getX(), this.height + layoutPoint.getY());
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }
}

