/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter;

import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutVector;
import java.util.ArrayList;

public class LayoutAnchor {
    public static final int ORIGIN = 1;
    public static final int BASELINE = 2;
    public static final int ADJUSTED_ORIGIN = 3;
    public static final int PARTIALLY_ADJUSTED_ORIGIN = 4;
    public static final LayoutAnchor INLINE_01 = new LayoutAnchor(0, LayoutVector.EAST, 1, LayoutVector.WEST, 2);
    public static final LayoutAnchor INLINE_12 = new LayoutAnchor(1, LayoutVector.EAST, 2, LayoutVector.WEST, 2);
    public static final LayoutAnchor INLINE_23 = new LayoutAnchor(2, LayoutVector.EAST, 3, LayoutVector.WEST, 2);
    public static final LayoutAnchor INLINE_LOW_01 = new LayoutAnchor(0, LayoutVector.SOUTHEAST, 1, LayoutVector.SOUTHWEST, 2);
    public static final LayoutAnchor OVER_01 = new LayoutAnchor(0, LayoutVector.SOUTH, 1, LayoutVector.NORTH, 4);
    public static final LayoutAnchor OVER_02 = new LayoutAnchor(0, LayoutVector.SOUTH, 2, LayoutVector.NORTH, 4);
    public static final LayoutAnchor UNDER_01 = new LayoutAnchor(0, LayoutVector.NORTH, 1, LayoutVector.SOUTH, 4);
    public static final LayoutAnchor UNDER_02 = new LayoutAnchor(0, LayoutVector.NORTH, 2, LayoutVector.SOUTH, 4);
    public static final LayoutAnchor RIGHTOF_01 = new LayoutAnchor(0, LayoutVector.WEST, 1, LayoutVector.EAST);
    public static final LayoutAnchor RIGHTOF_03 = new LayoutAnchor(0, LayoutVector.WEST, 3, LayoutVector.EAST);
    public static final LayoutAnchor RIGHTOF_12 = new LayoutAnchor(1, LayoutVector.WEST, 2, LayoutVector.EAST);
    public static final LayoutAnchor RIGHTOF_31 = new LayoutAnchor(3, LayoutVector.WEST, 1, LayoutVector.EAST);
    public static final LayoutAnchor LEFTOF_02 = new LayoutAnchor(0, LayoutVector.EAST, 2, LayoutVector.WEST);
    public static final LayoutAnchor LEFTOF_01 = new LayoutAnchor(0, LayoutVector.EAST, 1, LayoutVector.WEST);
    public static final LayoutAnchor LEFTOF_12 = new LayoutAnchor(1, LayoutVector.EAST, 2, LayoutVector.WEST);
    public static final LayoutAnchor SUPERSCRIPT_10 = new LayoutAnchor(0, LayoutVector.NORTHEAST, 1, LayoutVector.SOUTHWEST, 3);
    public static final LayoutAnchor SUPERSCRIPT_20 = new LayoutAnchor(0, LayoutVector.NORTHEAST, 2, LayoutVector.SOUTHWEST, 3);
    public static final LayoutAnchor SUPERSCRIPT_32 = new LayoutAnchor(2, LayoutVector.NORTHEAST, 3, LayoutVector.SOUTHWEST, 3);
    public static final LayoutAnchor SUBSCRIPT_10 = new LayoutAnchor(0, LayoutVector.SOUTHEAST, 1, LayoutVector.NORTHWEST, 3);
    public static final LayoutAnchor TOPLEFT_01 = new LayoutAnchor(0, LayoutVector.NORTHEAST, 1, LayoutVector.NORTHWEST);
    public static final LayoutAnchor BOTTOMRIGHT_21 = new LayoutAnchor(1, LayoutVector.SOUTHEAST, 2, LayoutVector.SOUTHWEST);
    private static final String category = "prettyprinter.LayoutAnchor";
    private static ArrayList anchorPool = new ArrayList();
    private static ArrayList topBottomAnchorPool = new ArrayList();
    protected LayoutVector pt1;
    protected LayoutVector pt2;
    protected int sibling1;
    protected int sibling2;
    protected int reference;

    public LayoutAnchor(int n, LayoutVector layoutVector, int n2, LayoutVector layoutVector2) {
        this.pt1 = layoutVector;
        this.pt2 = layoutVector2;
        this.sibling1 = n;
        this.sibling2 = n2;
        this.reference = 1;
    }

    public LayoutAnchor(int n, LayoutVector layoutVector, int n2, LayoutVector layoutVector2, int n3) {
        this.pt1 = layoutVector;
        this.pt2 = layoutVector2;
        this.sibling1 = n;
        this.sibling2 = n2;
        this.reference = n3;
    }

    public static LayoutAnchor createTopToBottomAnchor(int n) {
        LayoutAnchor layoutAnchor = null;
        if (n < topBottomAnchorPool.size()) {
            layoutAnchor = (LayoutAnchor)topBottomAnchorPool.get(n);
        } else {
            layoutAnchor = new LayoutAnchor(n, LayoutVector.SOUTHWEST, n + 1, LayoutVector.NORTHWEST);
            topBottomAnchorPool.add(layoutAnchor);
        }
        return layoutAnchor;
    }

    public static LayoutAnchor createLeftToRightAnchor(int n) {
        LayoutAnchor layoutAnchor = null;
        if (n < anchorPool.size()) {
            layoutAnchor = (LayoutAnchor)anchorPool.get(n);
        } else {
            layoutAnchor = new LayoutAnchor(n, LayoutVector.EAST, n + 1, LayoutVector.WEST, 2);
            anchorPool.add(layoutAnchor);
        }
        return layoutAnchor;
    }

    public static void anchorLeftToRight(LayoutBox layoutBox, int n, int n2) {
        if (n >= n2 || n2 > layoutBox.numChildren()) {
            throw new IndexOutOfBoundsException("Problem creating left to right anchors from " + n + " to " + n2 + " for a box with " + layoutBox.numChildren() + " children.");
        }
        for (int i = n; i < n2; ++i) {
            layoutBox.addLayoutAnchor(LayoutAnchor.createLeftToRightAnchor(i));
        }
    }

    public String toString() {
        return "Sibling : " + this.sibling1 + " " + this.pt1.toString() + "Relative: " + this.sibling2 + " " + this.pt2.toString();
    }

    public LayoutVector getFirstVector() {
        return this.pt1;
    }

    public LayoutVector getSecondVector() {
        return this.pt2;
    }

    public int getFirstSibling() {
        return this.sibling1;
    }

    public int getSecondSibling() {
        return this.sibling2;
    }

    public void apply(LayoutBox layoutBox) {
        LayoutBox layoutBox2 = layoutBox.getChild(this.getFirstSibling());
        LayoutBox layoutBox3 = layoutBox.getChild(this.getSecondSibling());
        LayoutVector layoutVector = this.getFirstVector();
        LayoutVector layoutVector2 = this.getSecondVector();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        d = layoutBox2.getXorig() + layoutVector.getWidth() * layoutBox2.getWidth() - layoutVector2.getWidth() * layoutBox3.getWidth();
        switch (this.reference) {
            case 1: {
                d2 = layoutBox2.getYorig() + layoutVector.getHeight() * layoutBox2.getHeight() - layoutVector2.getHeight() * layoutBox3.getHeight();
                break;
            }
            case 2: {
                d2 = layoutBox2.getYorig() + layoutBox2.getBaseline() - layoutBox3.getBaseline();
                break;
            }
            case 3: {
                d3 = layoutBox2.getYorig() - layoutBox2.getAdjustedYorig();
                d2 = layoutBox2.getAdjustedYorig() + layoutVector.getHeight() * layoutBox2.getAdjustedHeight() - layoutVector2.getHeight() * (layoutBox3.getAdjustedHeight() - d3);
                break;
            }
            case 4: {
                d3 = layoutBox2.getYorig() - layoutBox2.getAdjustedYorig();
                d2 = layoutBox2.getAdjustedYorig() + layoutVector.getHeight() * layoutBox2.getHeight() - layoutVector2.getHeight() * (layoutBox3.getAdjustedHeight() - d3);
            }
        }
        layoutBox3.setOrigin(d, d2);
    }

    static {
        anchorPool.add(INLINE_01);
        anchorPool.add(INLINE_12);
        anchorPool.add(INLINE_23);
    }
}

