/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.AbstractDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.AbstractLayoutBox;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.linebreaker.StringLineBreaker;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import com.maplesoft.util.WmiByteArrayInputStream;
import com.maplesoft.util.encoder.UnicodeEscapeEncoder;
import java.io.IOException;

public abstract class TextDagFactory
extends AbstractDagFactory {
    protected int type;

    public TextDagFactory(int n) {
        this.type = n;
    }

    public int getPrecedence() {
        return 1;
    }

    public Dag readDotm(WmiByteArrayInputStream wmiByteArrayInputStream) throws IOException {
        String string = "";
        int n = DagBuilder.dagCountPlus();
        int n2 = DagBuilder.parseShortInteger(wmiByteArrayInputStream);
        string = n2 > 0 ? DagBuilder.getName(wmiByteArrayInputStream, n2) : "";
        Dag dag = null;
        boolean bl = true;
        if (this.type == 8 || this.type == 7) {
            dag = DagBuilder.create(wmiByteArrayInputStream);
            if (this.type == 8 && dag == null) {
                bl = false;
            }
        }
        Dag dag2 = Dag.createDag(this.type, null, string, bl);
        dag2.setAttributes(dag);
        DagBuilder.putDag(dag2, n);
        return dag2;
    }

    public void linePrint(StringBuffer stringBuffer, Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        StringBuffer stringBuffer2 = new StringBuffer(dag.getData());
        stringBuffer.append(stringBuffer2.toString());
    }

    static void debug(Object object) {
    }

    protected LayoutBox createBox(LayoutFormatter layoutFormatter, String string) {
        AbstractLayoutBox abstractLayoutBox = null;
        int n = (string = UnicodeEscapeEncoder.convertEscapeSequenceToUnicode(string)).indexOf(10);
        if (n < 0) {
            abstractLayoutBox = NotationLayoutBox.createCustomBox(layoutFormatter, string);
        } else {
            String string2;
            abstractLayoutBox = new InlineLayoutBox();
            int n2 = 0;
            while (n >= 0) {
                string2 = string.substring(n2, n);
                abstractLayoutBox.addChild(NotationLayoutBox.createCustomBox(layoutFormatter, string2));
                n2 = n + 1;
                n = string.indexOf(10, n2);
            }
            if (n2 < string.length()) {
                string2 = string.substring(n2);
                abstractLayoutBox.addChild(NotationLayoutBox.createCustomBox(layoutFormatter, string2));
            }
            abstractLayoutBox.addChild((LayoutBox)new StringLineBreaker.LinebrokenStringTerminatorBox());
        }
        return abstractLayoutBox;
    }

    public LayoutBox createLayout(LayoutFormatter layoutFormatter, Dag dag) {
        String string = dag.getType() == 8 ? dag.getData() : "\"" + dag.getData() + "\"";
        LayoutBox layoutBox = null;
        layoutBox = this.createBox(layoutFormatter, string);
        layoutBox.setLineBreaker(LineBreakerFactory.newLineBreaker((int)8));
        SelectionData selectionData = new SelectionData(2);
        selectionData.setStandardEastWestArray(layoutBox);
        selectionData.setStandardNorthSouthArray();
        layoutBox.setSelectionData(selectionData);
        return layoutBox;
    }

    public LayoutBox createLayout(LayoutFormatter layoutFormatter, int n, String string) {
        LayoutBox layoutBox = super.createLayout(layoutFormatter, n, string);
        layoutBox.setLineBreaker(LineBreakerFactory.newLineBreaker((int)8));
        SelectionData selectionData = new SelectionData(2);
        selectionData.setStandardEastWestArray(layoutBox);
        selectionData.setStandardNorthSouthArray();
        layoutBox.setSelectionData(selectionData);
        return layoutBox;
    }
}

