/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.HybridDag;
import com.maplesoft.client.dag.RtableData;

public class RtableDag
extends HybridDag {
    public static final int RTABLE_NUMDIMS_INDEX = 6;
    public static final int RTABLE_RESERVED_INDEX = 5;
    public static final int RTABLE_READONLY_INDEX = 4;
    public static final int RTABLE_ORDER_INDEX = 3;
    public static final int RTABLE_STORAGE_INDEX = 2;
    public static final int RTABLE_SUBTYPE_INDEX = 1;
    public static final int RTABLE_DATATYPE_INDEX = 0;
    public static final int RTABLE_DAG = 0;
    public static final int RTABLE_CXDAG = 1;
    public static final int RTABLE_INTEGER8 = 2;
    public static final int RTABLE_INTEGER16 = 3;
    public static final int RTABLE_INTEGER32 = 4;
    public static final int RTABLE_INTEGER64 = 5;
    public static final int RTABLE_FLOAT = 6;
    public static final int RTABLE_FLOAT64 = 6;
    public static final int RTABLE_COMPLEX = 7;
    public static final int RTABLE_FLOAT32 = 8;
    public static final int RTABLE_NUM_DATATYPES = 9;
    public static final int RTABLE_ARRAY = 0;
    public static final int RTABLE_MATRIX = 1;
    public static final int RTABLE_COLUMN = 2;
    public static final int RTABLE_ROW = 3;
    public static final int RTABLE_SPARSE = 0;
    public static final int RTABLE_EMPTY = 1;
    public static final int RTABLE_DIAG = 2;
    public static final int RTABLE_BAND = 3;
    public static final int RTABLE_RECT = 4;
    public static final int RTABLE_UPPTRI = 5;
    public static final int RTABLE_UPPTRIMINUS = 6;
    public static final int RTABLE_UPPTRIPLUS = 7;
    public static final int RTABLE_LOWTRI = 8;
    public static final int RTABLE_LOWTRIMINUS = 9;
    public static final int RTABLE_LOWTRIPLUS = 10;
    public static final int RTABLE_SCALAR = 11;
    public static final int RTABLE_FORTRAN = 0;
    public static final int RTABLE_C = 1;
    protected int[] theFlags;
    protected int[] theSizes;
    protected RtableData theTableData;
    protected Dag[] dataDags;

    public RtableDag() {
        super(38, null, null);
    }

    public void setFlags(int[] nArray) {
        this.theFlags = nArray;
    }

    public int[] getFlags() {
        return this.theFlags;
    }

    public int getDataType() {
        return this.theFlags[0];
    }

    public int getSubType() {
        return this.theFlags[1];
    }

    public int getStorage() {
        return this.theFlags[2];
    }

    public int getOrder() {
        return this.theFlags[3];
    }

    public int getReadOnly() {
        return this.theFlags[4];
    }

    public int getReserved() {
        return this.theFlags[5];
    }

    public int getDimensionCount() {
        return this.theFlags[6];
    }

    public boolean isReadOnly() {
        return this.getReadOnly() == 1;
    }

    public boolean isFortranOrder() {
        return this.getOrder() == 1;
    }

    public void setSizes(int[] nArray) {
        this.theSizes = nArray;
    }

    public int[] getSizes() {
        return this.theSizes;
    }

    public int getElementCount() {
        return this.theSizes[0];
    }

    public int getRangeLowerBound(int n) {
        return this.theSizes[n * 2 + 1];
    }

    public int getRangeUpperBound(int n) {
        return this.theSizes[n * 2 + 2];
    }

    private Dag getBandExpSeqDag() {
        Dag dag = this.getChild(2);
        Dag dag2 = dag.getChild(0);
        return dag2.getChild(1);
    }

    public int getBandLowerBound() {
        Dag dag = this.getBandExpSeqDag();
        return DagUtil.parseInt(dag.getChild(0));
    }

    public int getBandUpperBound() {
        Dag dag = this.getBandExpSeqDag();
        return DagUtil.parseInt(dag.getChild(1));
    }

    public void setTableData(RtableData rtableData) {
        this.theTableData = rtableData;
    }

    public RtableData getTableData() {
        return this.theTableData;
    }

    public void setDataDags(Dag[] dagArray) {
        this.dataDags = dagArray;
    }

    public Dag[] getDataDags() {
        return this.dataDags;
    }

    public Dag copy() {
        RtableDag rtableDag = new RtableDag();
        rtableDag.theFlags = this.getFlags();
        rtableDag.theSizes = this.getSizes();
        rtableDag.dataDags = this.getDataDags();
        rtableDag.setTableData(this.theTableData);
        rtableDag.theData = this.theData;
        rtableDag.theDags = this.theDags;
        return rtableDag;
    }

    public Dag getNormalized() {
        if (this.normalized == null) {
            this.normalized = DagBuilder.normalize(this);
        }
        return this.normalized;
    }

    public boolean equals(Object object) {
        int n;
        if (this == object) {
            return true;
        }
        if (!(object instanceof RtableDag)) {
            return false;
        }
        RtableDag rtableDag = (RtableDag)object;
        if (this.theFlags.length != rtableDag.theFlags.length) {
            return false;
        }
        for (n = 0; n < this.theFlags.length; ++n) {
            if (this.theFlags[n] == rtableDag.theFlags[n]) continue;
            return false;
        }
        if (this.theSizes.length != rtableDag.theSizes.length) {
            return false;
        }
        for (n = 0; n < this.theSizes.length; ++n) {
            if (this.theSizes[n] == rtableDag.theSizes[n]) continue;
            return false;
        }
        if (this.dataDags != rtableDag.dataDags && this.dataDags != null) {
            if (this.dataDags.length != rtableDag.dataDags.length) {
                return false;
            }
            for (n = 0; n < this.theSizes.length; ++n) {
                if (this.dataDags[n].equals(rtableDag.dataDags[n])) continue;
                return false;
            }
        }
        if (this.theTableData != rtableDag.theTableData && this.theTableData != null) {
            return this.theTableData.equals(rtableDag.theTableData);
        }
        return true;
    }

    public int computeHashCode() {
        int n = super.computeHashCode();
        if (this.theTableData.getNamedArray() != null) {
            n ^= this.theTableData.getNamedArray().hashCode();
        }
        return n;
    }

    public void dispose() {
        this.theTableData = null;
        super.dispose();
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("*********************\n");
        stringBuffer.append("Type: " + this.theType + " " + DagBuilder.CLASS_NAMES[this.theType] + "\n");
        int n2 = 1;
        int n3 = 0;
        int n4 = 0;
        if (this.theDags != null) {
            for (n = 0; n < this.theDags.length; ++n) {
                if (this.theDags[n] == null) continue;
                stringBuffer.append(this.theDags[n].toString());
            }
            n2 = this.theDags.length;
        }
        if (this.theData instanceof String) {
            stringBuffer.append("Data: " + this.theData + "\n");
            n3 = ((String)this.theData).length();
        }
        n4 = n3 > 0 ? n3 : n2;
        stringBuffer.append("Length: " + n4 + "\n");
        for (n = 0; n < this.theFlags.length; ++n) {
            stringBuffer.append("Flag # " + n + " is " + this.theFlags[n] + "\n");
        }
        for (n = 0; n < this.theSizes.length; ++n) {
            stringBuffer.append("Sizes # " + n + " is " + this.theSizes[n] + "\n");
        }
        stringBuffer.append(this.theTableData);
        stringBuffer.append("\nArray Name is " + this.theTableData.getNamedArray());
        stringBuffer.append("\n(");
        if (this.theData instanceof String && n3 > 0) {
            stringBuffer.append("Leaf Node with Data)\n");
        } else if (n4 == 1) {
            stringBuffer.append("Leaf Node -- no Children)\n");
        } else if (n4 > 1) {
            stringBuffer.append("Branch Node)\n");
        } else if (this.theDags == null && this.theData == null) {
            stringBuffer.append("Leaf Node -- no Children/no Data)\n");
        } else if (this.theData instanceof String && n3 == 0) {
            stringBuffer.append("Leaf Node with no Data)\n");
        }
        stringBuffer.append("End of: " + this.theType + " " + DagBuilder.CLASS_NAMES[this.theType] + "\n");
        stringBuffer.append("*********************\n");
        return stringBuffer.toString();
    }
}

