/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.AbstractDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagConstants;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.PowerDagFactory;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreaker;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.template.BinaryOperationTemplate;
import com.maplesoft.client.prettyprinter.template.BracketTemplate;
import com.maplesoft.client.prettyprinter.template.DivideTemplate;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class ProdDagFactory
extends AbstractDagFactory {
    public static Dag create(Dag[] dagArray) {
        return Dag.createDag(14, dagArray, null, false);
    }

    public static Dag create(Dag dag, int n, Dag dag2, int n2) {
        Dag[] dagArray = new Dag[]{dag, n == 1 ? DagConstants.ONE : DagConstants.MINUS_ONE, dag2, n2 == 1 ? DagConstants.ONE : DagConstants.MINUS_ONE};
        return Dag.createDag(14, dagArray, null, false);
    }

    public static Dag create(Dag dag, Dag dag2) {
        int n = dag.getLength();
        int n2 = dag2.getLength();
        Dag[] dagArray = null;
        if (dag2.getType() == 14) {
            if (dag.getType() == 14) {
                int n3;
                dagArray = new Dag[n + n2];
                int n4 = 0;
                for (n3 = 0; n3 < n; ++n3) {
                    dagArray[n4++] = dag.getChild(n3);
                }
                for (n3 = 0; n3 < n2; ++n3) {
                    dagArray[n4++] = dag2.getChild(n3);
                }
            } else {
                dagArray = new Dag[n2 + 2];
                dagArray[0] = dag;
                dagArray[1] = DagConstants.ONE;
                int n5 = 2;
                for (int i = 0; i < n2; ++i) {
                    dagArray[n5++] = dag2.getChild(i);
                }
            }
        } else {
            dagArray = new Dag[4];
            dagArray[0] = dag;
            dagArray[2] = dag2;
            dagArray[1] = dagArray[3] = DagConstants.ONE;
        }
        return Dag.createDag(14, dagArray, null, false);
    }

    public Dag readDotm(WmiByteArrayInputStream wmiByteArrayInputStream) throws IOException {
        return this.readDotm(wmiByteArrayInputStream, 14, DagBuilder.parseShortInteger(wmiByteArrayInputStream));
    }

    public void writeDotm(StringBuffer stringBuffer, Dag dag) {
        this.writeDotm(stringBuffer, dag, 14, true);
    }

    public int getPrecedence() {
        return 4;
    }

    public StringBuffer toString(Dag dag) {
        StringBuffer stringBuffer = null;
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        int n = 0;
        int n2 = 0;
        int n3 = dag.getLength();
        for (int i = 0; i < n3; i += 2) {
            Dag dag2 = dag.getChild(i);
            Dag dag3 = dag.getChild(i + 1);
            if (dag2.getType() == 2 && dag2.getData().equals("1")) continue;
            if (dag3.getType() == 2) {
                this.infixAppendBuffer(stringBuffer2, dag2, n, new WmiLPrintOptions(), false);
                ++n;
                continue;
            }
            this.infixAppendBuffer(stringBuffer3, dag2, n2, new WmiLPrintOptions(), false);
            ++n2;
        }
        if (n2 == 0) {
            stringBuffer = stringBuffer2;
        } else {
            if (n == 0) {
                stringBuffer = new StringBuffer("1/");
            } else {
                stringBuffer = stringBuffer2;
                stringBuffer.append("/");
            }
            if (n2 > 1) {
                stringBuffer.append("(");
                stringBuffer.append(stringBuffer3);
                stringBuffer.append(")");
            } else {
                stringBuffer.append(stringBuffer3);
            }
        }
        return stringBuffer;
    }

    private void infixLinePrint(StringBuffer stringBuffer, Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        int n = 0;
        int n2 = 0;
        int n3 = dag.getLength();
        boolean bl = false;
        for (int i = 0; i < n3; i += 2) {
            Dag dag2 = dag.getChild(i);
            Dag dag3 = dag.getChild(i + 1);
            if (dag2.getType() == 2 && dag2.getData().equals("1")) continue;
            if (dag2.getType() == 18) {
                Dag dag4 = dag2.getChild(0);
                Dag dag5 = dag2.getChild(1);
                if (dag4.getData() != null && dag4.getData().equals("/") && dag5.getLength() == 1) {
                    if (dag3.getType() == 2) {
                        this.infixAppendBuffer(stringBuffer3, dag5, n2, wmiLPrintOptions, true);
                        ++n2;
                        continue;
                    }
                    this.infixAppendBuffer(stringBuffer2, dag5, n, wmiLPrintOptions, true);
                    if (dag2.getType() == 14) {
                        bl = true;
                    }
                    ++n;
                    continue;
                }
            }
            if (dag3.getType() == 2) {
                this.infixAppendBuffer(stringBuffer2, dag2, n, wmiLPrintOptions, false);
                ++n;
                continue;
            }
            this.infixAppendBuffer(stringBuffer3, dag2, n2, wmiLPrintOptions, false);
            if (dag2.getType() == 14) {
                bl = true;
            }
            ++n2;
        }
        if (n2 == 0) {
            if (stringBuffer2.charAt(0) == '-' && stringBuffer.length() > 0) {
                stringBuffer.setLength(stringBuffer.length() - 1);
            }
            stringBuffer.append(stringBuffer2);
        } else {
            if (n == 0) {
                stringBuffer.append("1/");
            } else {
                stringBuffer.append(stringBuffer2);
                stringBuffer.append("/");
            }
            if (n2 > 1 || bl) {
                stringBuffer.append("(");
                stringBuffer.append(stringBuffer3);
                stringBuffer.append(")");
            } else {
                stringBuffer.append(stringBuffer3);
            }
        }
    }

    private void prefixLinePrint(StringBuffer stringBuffer, Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        int n;
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        int n2 = 0;
        int n3 = 0;
        int n4 = dag.getLength();
        for (n = 0; n < n4; n += 2) {
            Dag dag2 = dag.getChild(n);
            Dag dag3 = dag.getChild(n + 1);
            if (dag2.getType() == 2 && dag2.getData().equals("1")) continue;
            if (dag3.getType() == 2) {
                if (n2 > 0) {
                    stringBuffer2.append(", ");
                }
                stringBuffer2.append("`*`(");
                DagBuilder.linePrint(stringBuffer2, dag2, wmiLPrintOptions);
                ++n2;
                continue;
            }
            if (n3 > 0) {
                stringBuffer3.append(", ");
            }
            stringBuffer3.append("`*`(");
            DagBuilder.linePrint(stringBuffer3, dag2, wmiLPrintOptions);
            ++n3;
        }
        for (n = 0; n < n2; ++n) {
            stringBuffer2.append(")");
        }
        for (n = 0; n < n3; ++n) {
            stringBuffer3.append(")");
        }
        if (n3 == 0) {
            stringBuffer.append(stringBuffer2);
        } else if (n2 == 0) {
            stringBuffer.append("`/`(1, ");
            stringBuffer.append(stringBuffer3);
            stringBuffer.append(")");
        } else {
            stringBuffer.append("`/`(");
            stringBuffer.append(stringBuffer2);
            stringBuffer.append(", ");
            stringBuffer.append(stringBuffer3);
            stringBuffer.append(")");
        }
    }

    public void linePrint(StringBuffer stringBuffer, Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        if (wmiLPrintOptions.isInLineIfPossible()) {
            this.infixLinePrint(stringBuffer, dag, wmiLPrintOptions);
        } else {
            this.prefixLinePrint(stringBuffer, dag, wmiLPrintOptions);
        }
    }

    protected void infixAppendBuffer(StringBuffer stringBuffer, Dag dag, int n, WmiLPrintOptions wmiLPrintOptions, boolean bl) {
        if (n > 0) {
            stringBuffer.append("*");
        }
        if (bl |= DagBuilder.getPrecedence(dag, wmiLPrintOptions) >= 4) {
            stringBuffer.append("(");
        }
        DagBuilder.linePrint(stringBuffer, dag, wmiLPrintOptions);
        if (bl) {
            stringBuffer.append(")");
        }
    }

    public Dag normalize(Dag dag) {
        boolean bl = true;
        Dag dag2 = null;
        if (dag != null) {
            if (!dag.isNormalized()) {
                dag2 = dag.copy();
                int n = dag.getLength();
                for (int i = 0; i < n; i += 2) {
                    Dag dag3 = dag.getChild(i);
                    Dag dag4 = dag.getChild(i + 1);
                    if (dag3.getType() == 16 && DagUtil.isOne(dag4) && dag3.getLength() == 2 && DagUtil.isNegative(dag3.getChild(1))) {
                        bl = !bl;
                        dag3 = DagUtil.negate(dag3);
                    }
                    if (DagUtil.isNegative(dag4)) {
                        if (DagUtil.isMinusOne(dag4)) {
                            dag2.setChild(i, dag3);
                            dag2.setChild(i + 1, dag4);
                            continue;
                        }
                        dag2.setChild(i, PowerDagFactory.create(dag3, DagUtil.negate(dag4)));
                        dag2.setChild(i + 1, DagConstants.MINUS_ONE);
                        continue;
                    }
                    if (DagUtil.isOne(dag4)) {
                        dag2.setChild(i, dag3);
                        dag2.setChild(i + 1, dag4);
                        continue;
                    }
                    dag2.setChild(i, PowerDagFactory.create(dag3, dag4));
                    dag2.setChild(i + 1, DagConstants.ONE);
                }
                if (!bl) {
                    Dag[] dagArray = new Dag[]{dag2, DagConstants.MINUS_ONE};
                    dag2 = Dag.createDag(16, dagArray, null, false);
                }
                dag.setNormalized(dag2);
            } else {
                dag2 = dag.getNormalized();
            }
        }
        return dag2;
    }

    public LayoutBox createLayout(LayoutFormatter layoutFormatter, Dag dag) {
        Object object;
        Dag dag2;
        String string = DagBuilder.ELEMENT_NAME[14];
        int n = dag.getLength();
        Object object2 = new ProdLayoutBox(string, 3);
        int n2 = 1;
        if (dag.getChild(0).getType() == 3) {
            n2 = 3;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Dag> arrayList2 = new ArrayList<Dag>();
        int n3 = 4;
        int n4 = 4;
        for (int i = n2; i < n; i += 2) {
            dag2 = dag.getChild(i - 1);
            object = dag.getChild(i);
            int n5 = DagBuilder.getPrecedence(dag2, layoutFormatter);
            if (((Dag)object).getType() == 2) {
                arrayList.add(dag2);
                arrayList.add(object);
                n3 = Math.max(n5, n3);
                continue;
            }
            arrayList2.add(dag2);
            arrayList2.add(DagConstants.ONE);
            n4 = Math.max(n5, n4);
        }
        if (arrayList2.size() > 0 && dag.getChild(0).getType() == 3) {
            Dag dag3 = dag.getChild(0);
            dag2 = dag3.getChild(0);
            if (!DagUtil.isOne(dag2)) {
                arrayList.add(0, dag2);
                arrayList.add(1, DagConstants.ONE);
            }
            arrayList2.add(0, dag3.getChild(1));
            arrayList2.add(1, DagConstants.ONE);
            n2 = 1;
        }
        Dag dag4 = null;
        dag2 = null;
        if (arrayList.size() > 0) {
            object = arrayList.toArray(new Dag[0]);
            dag4 = ProdDagFactory.create((Dag[])object);
        }
        if (arrayList2.size() > 0) {
            object = arrayList2.toArray(new Dag[0]);
            dag2 = ProdDagFactory.create((Dag[])object);
        }
        object = null;
        LayoutBox layoutBox = null;
        int n6 = layoutFormatter.isInProc() ? 75 : 76;
        object = this.buildNumerator(layoutFormatter, dag4, dag2, n3, n6);
        layoutBox = this.buildDenominator(layoutFormatter, dag2, n4, n6);
        Object object3 = null;
        if (layoutBox == null) {
            object3 = object;
        } else {
            int n7 = this.getLayoutMode(layoutFormatter, arrayList, true) | this.getLayoutMode(layoutFormatter, arrayList2, false);
            double d = layoutFormatter.getSafeBreakWidth();
            object.applyLayout();
            layoutBox.applyLayout();
            if (layoutBox.getWidth() > d || layoutFormatter.isInProc()) {
                n7 |= 1;
            } else if (object.getWidth() > d) {
                ProdLayoutBox prodLayoutBox = new ProdLayoutBox("numereator", 1);
                prodLayoutBox.addChild(DagBuilder.createLayout(layoutFormatter, DagConstants.ONE));
                LayoutBox layoutBox2 = DivideTemplate.apply(layoutFormatter, prodLayoutBox, layoutBox, 0);
                object3 = new InlineLayoutBox();
                object3.addChild(layoutBox2);
                object3.addChild(NotationLayoutBox.createNotationBox(layoutFormatter, 76));
                if ((n7 & 2) != 0) {
                    object = BracketTemplate.apply(layoutFormatter, (LayoutBox)object, 91, 92);
                }
                object3.addChild((LayoutBox)object);
            } else {
                n7 |= 0;
            }
            if (object3 == null) {
                object3 = DivideTemplate.apply(layoutFormatter, (LayoutBox)object, layoutBox, n7);
            }
            if (n2 != 1) {
                object3 = BracketTemplate.apply(layoutFormatter, (LayoutBox)object3);
                object3.setLineBreaker(LineBreakerFactory.newLineBreaker((int)1));
            }
        }
        if (n2 != 1) {
            object2.addChild(DagBuilder.createLayout(layoutFormatter, dag.getChild(0)));
            object2.addChild(NotationLayoutBox.createNotationBox(layoutFormatter, n6));
            object2.addChild((LayoutBox)object3);
        } else {
            object2 = object3;
        }
        return object2;
    }

    private int getLayoutMode(LayoutFormatter layoutFormatter, ArrayList arrayList, boolean bl) {
        int n = 0;
        boolean bl2 = false;
        if (arrayList.size() == 3) {
            int n2 = DagBuilder.getPrecedence((Dag)arrayList.get(1), layoutFormatter);
            if (n2 >= 6) {
                bl2 = true;
            }
        } else {
            bl2 = true;
        }
        if (bl2) {
            n = bl ? 2 : 4;
        }
        return n;
    }

    private LayoutBox buildNumerator(LayoutFormatter layoutFormatter, Dag dag, Dag dag2, int n, int n2) {
        ProdLayoutBox prodLayoutBox = null;
        if (dag != null) {
            int n3 = dag.getLength();
            prodLayoutBox = new ProdLayoutBox("numerator", n3 / 2);
            prodLayoutBox.setDag(dag);
            prodLayoutBox.setPrecedence(n);
            NotationLayoutBox notationLayoutBox = null;
            if (n3 == 2) {
                prodLayoutBox.addChild(DagBuilder.createLayout(layoutFormatter, dag.getChild(0)));
            } else {
                for (int i = 0; i < n3; i += 2) {
                    notationLayoutBox = NotationLayoutBox.createNotationBox(layoutFormatter, n2);
                    BinaryOperationTemplate.apply(layoutFormatter, (LayoutBox)prodLayoutBox, notationLayoutBox, dag.getChild(i), 4);
                }
            }
        } else if (dag2 != null) {
            prodLayoutBox = new ProdLayoutBox("numerator", 1);
            prodLayoutBox.addChild(DagBuilder.createLayout(layoutFormatter, DagConstants.ONE));
        }
        return prodLayoutBox;
    }

    private LayoutBox buildDenominator(LayoutFormatter layoutFormatter, Dag dag, int n, int n2) {
        ProdLayoutBox prodLayoutBox = null;
        if (dag != null) {
            int n3 = dag.getLength();
            prodLayoutBox = new ProdLayoutBox("denominator", n3 / 2);
            prodLayoutBox.setDag(dag);
            prodLayoutBox.setPrecedence(n);
            NotationLayoutBox notationLayoutBox = null;
            if (n3 == 2) {
                prodLayoutBox.addChild(DagBuilder.createLayout(layoutFormatter, dag.getChild(0)));
            } else {
                for (int i = 0; i < n3; i += 2) {
                    notationLayoutBox = NotationLayoutBox.createNotationBox(layoutFormatter, n2);
                    BinaryOperationTemplate.apply(layoutFormatter, (LayoutBox)prodLayoutBox, notationLayoutBox, dag.getChild(i), 4);
                }
            }
        }
        return prodLayoutBox;
    }

    public static boolean isQuotient(Dag dag) {
        int n;
        boolean bl = false;
        if (dag.getType() == 14 && (n = dag.getLength()) > 0) {
            if (dag.getChild(0).getType() == 3) {
                bl = true;
            } else {
                for (int i = 1; i < n; i += 2) {
                    if (dag.getChild(i).getType() != 1) continue;
                    bl = true;
                    break;
                }
            }
        }
        return bl;
    }

    public static class ProdLayoutBox
    extends InlineLayoutBox {
        private static LineBreaker lb = LineBreakerFactory.newLineBreaker((int)10);
        private int precedence = 4;

        public ProdLayoutBox(String string, int n) {
            super(string, n);
        }

        public ProdLayoutBox() {
        }

        public void setLineBreaker(LineBreaker lineBreaker) {
        }

        public LineBreaker getLineBreaker() {
            return lb;
        }

        public void setPrecedence(int n) {
            this.precedence = n;
        }

        public int getPrecedence() {
            return this.precedence;
        }
    }
}

