/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.MapleNumbers;
import com.maplesoft.client.dag.AttributedLeafDag;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagConstructor;
import com.maplesoft.client.dag.DagRenderContext;
import com.maplesoft.client.dag.LeafDag;
import com.maplesoft.client.dag.TextDagFactory;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.AbstractFormatter;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.util.RuntimeLocale;
import com.maplesoft.util.encoder.KernelEncoder;
import java.util.HashSet;

public class NameDagFactory
extends TextDagFactory {
    public static final String NAME_QUOTE = "`";
    private static final DagConstructor constructor = new NameConstructor();
    private static final int DEFAULT_SHOW_ASSUMED = 0;
    private static int showAssumedValue = 0;
    private static HashSet quotedNames = new HashSet();
    private static HashSet nonQuotedNames = new HashSet();
    private static HashSet quotedOnlyInProcs = new HashSet();

    public NameDagFactory() {
        super(8);
    }

    public static Dag createNameDag(String string) {
        return Dag.createDag(8, null, string, true);
    }

    public DagConstructor getConstructor() {
        return constructor;
    }

    public void updateContext(DagRenderContext dagRenderContext) {
        showAssumedValue = dagRenderContext.getInterfaceProperty("showassumed", 0);
    }

    public LayoutBox createLayout(LayoutFormatter layoutFormatter, Dag dag) {
        LayoutBox layoutBox = null;
        if (dag.getLength() == 0) {
            String string = dag.getData();
            if (string.endsWith("~") && string.length() > 1) {
                if (showAssumedValue == 0 || showAssumedValue == 2) {
                    string = string.substring(0, string.length() - 1);
                }
                if (showAssumedValue == 2 && !layoutFormatter.containsJobForIdentifier(string)) {
                    layoutFormatter.addPostLayoutJob(string, new AbstractFormatter.AssumptionLabelJob(layoutFormatter, string));
                }
            }
            if (NameDagFactory.isQuotationNeeded(layoutFormatter, dag)) {
                StringBuffer stringBuffer = new StringBuffer(NAME_QUOTE);
                stringBuffer.append(string);
                stringBuffer.append(NAME_QUOTE);
                string = stringBuffer.toString();
            }
            layoutBox = this.createBox(layoutFormatter, string);
            layoutBox.setLineBreaker(LineBreakerFactory.newLineBreaker((int)8));
        }
        return layoutBox;
    }

    public void writeDotm(StringBuffer stringBuffer, Dag dag) {
        String string = dag.getDataOnly();
        KernelEncoder kernelEncoder = RuntimeLocale.getKernelEncoder();
        if (kernelEncoder != null) {
            string = kernelEncoder.fromUnicode(string, false);
        }
        Dag dag2 = dag.getAttributes();
        char c = '\u0000';
        int n = NameDagFactory.isABackref(dag, this.type);
        if (n > 0) {
            this.writeBackref(stringBuffer, n);
            return;
        }
        if (dag2 == null || dag2.getType() == 57 || dag instanceof AttributedLeafDag && dag == dag2) {
            c = (char)(MapleNumbers.dotMOutputTable[this.type] + 33 - 1);
        } else {
            c = (char)(MapleNumbers.dotMOutputTable[this.type + 57] + 33 - 1);
            if (c == ' ') {
                c = (char)(MapleNumbers.dotMOutputTable[this.type] + 33 - 1);
            }
        }
        stringBuffer.append(c);
        int n2 = string.length();
        DagBuilder.writeShortInteger(stringBuffer, n2);
        DagBuilder.writeNameAsDotm(stringBuffer, string);
        stringBuffer.append((char)(MapleNumbers.dotMOutputTable[57] + 33 - 1));
        if (dag2 != null && dag2.getType() != 57) {
            if (dag instanceof AttributedLeafDag) {
                if (dag != dag2) {
                    DagBuilder.writeDotm(stringBuffer, dag2);
                }
            } else {
                DagBuilder.writeDotm(stringBuffer, dag2);
            }
        }
    }

    public static boolean isQuotationNeeded(Dag dag) {
        return NameDagFactory.isQuotationNeeded(null, dag);
    }

    public static boolean isQuotationNeeded(LayoutFormatter layoutFormatter, Dag dag) {
        boolean bl;
        boolean bl2 = false;
        String string = dag.getDataOnly();
        if (string == null || string.length() == 0) {
            return false;
        }
        if (string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'') {
            return false;
        }
        boolean bl3 = bl = layoutFormatter != null;
        if (quotedNames.contains(string)) {
            return true;
        }
        if (nonQuotedNames.contains(string)) {
            return bl2;
        }
        if (layoutFormatter != null && layoutFormatter.isInProc() && quotedOnlyInProcs.contains(string)) {
            return true;
        }
        if (string.equals("")) {
            bl2 = false;
        } else {
            int n = 0;
            char c = string.charAt(n);
            if (Character.isLetter(c) || c == '_') {
                ++n;
                while (n < string.length() && (Character.isLetterOrDigit(string.charAt(n)) || string.charAt(n) == '_' || string.charAt(n) == '~' || string.charAt(n) == ':')) {
                    ++n;
                }
            } else if (c == '%') {
                ++n;
                while (n < string.length() && (Character.isLetterOrDigit(string.charAt(n)) || string.charAt(n) == '_' || string.charAt(n) == '$' || string.charAt(n) == '?')) {
                    ++n;
                }
            } else if (c == '~' && bl && !layoutFormatter.isInOperatorProc()) {
                ++n;
                while (n < string.length() && (Character.isLetterOrDigit(string.charAt(n)) || string.charAt(n) == '$' || string.charAt(n) == '_')) {
                    ++n;
                }
            }
            if (c == '&') {
                bl2 = true;
                bl2 = bl && layoutFormatter.isInProc() || !bl;
            } else {
                boolean bl4 = bl2 = n != string.length();
                if (bl2 && bl) {
                    bl2 = layoutFormatter.isInProc();
                }
            }
        }
        return bl2;
    }

    public void linePrint(StringBuffer stringBuffer, Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        String string = dag.getDataOnly();
        if (string.length() > 1 && string.lastIndexOf(126) == string.length() - 1) {
            string = string.substring(0, string.length() - 1);
        }
        boolean bl = (string.startsWith("Copyright") || NameDagFactory.isQuotationNeeded(dag) || string.length() == 0) && !wmiLPrintOptions.isDropStringQuotes();
        StringBuffer stringBuffer2 = new StringBuffer();
        if (bl) {
            stringBuffer2.append(NAME_QUOTE);
        }
        stringBuffer2.append(string);
        if (bl) {
            stringBuffer2.append(NAME_QUOTE);
        }
        if (!dag.getDataOnly().equals(dag.getData())) {
            stringBuffer.append(((AttributedLeafDag)dag).getModuleName());
            stringBuffer.append(":-");
        }
        stringBuffer.append(stringBuffer2);
    }

    static {
        quotedNames.add("<,>");
        quotedNames.add("<|>");
        quotedNames.add("and");
        quotedNames.add("assuming");
        quotedNames.add("break");
        quotedNames.add("by");
        quotedNames.add("catch");
        quotedNames.add("description");
        quotedNames.add("do");
        quotedNames.add("done");
        quotedNames.add("elif");
        quotedNames.add("else");
        quotedNames.add("end");
        quotedNames.add("error");
        quotedNames.add("export");
        quotedNames.add("fi");
        quotedNames.add("finally");
        quotedNames.add("for");
        quotedNames.add("from");
        quotedNames.add("global");
        quotedNames.add("if");
        quotedNames.add("implies");
        quotedNames.add("in");
        quotedNames.add("intersect");
        quotedNames.add("local");
        quotedNames.add("minus");
        quotedNames.add("mod");
        quotedNames.add("next");
        quotedNames.add("not");
        quotedNames.add("od");
        quotedNames.add("option");
        quotedNames.add("options");
        quotedNames.add("or");
        quotedNames.add("quit");
        quotedNames.add("read");
        quotedNames.add("return");
        quotedNames.add("save");
        quotedNames.add("stop");
        quotedNames.add("subset");
        quotedNames.add("then");
        quotedNames.add("to");
        quotedNames.add("try");
        quotedNames.add("union");
        quotedNames.add("use");
        quotedNames.add("uses");
        quotedNames.add("while");
        quotedNames.add("xor");
        nonQuotedNames.add(" $");
        quotedOnlyInProcs.add("mod");
        quotedOnlyInProcs.add("RTABLE");
        quotedOnlyInProcs.add("");
    }

    private static class NameConstructor
    extends DagConstructor {
        private NameConstructor() {
        }

        public Dag createDag(int n, Dag[] dagArray, Object object, boolean bl) {
            return bl ? new AttributedLeafDag(n, object) : new LeafDag(n, object);
        }
    }
}

