/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.AbstractCommandDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.template.ProcTemplate;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;

public class ForDagFactory
extends AbstractCommandDagFactory {
    public static final String[] FOR_KEYWORDS = new String[]{"for ", "from ", "by ", "to ", "while ", "in "};

    public Dag readDotm(WmiByteArrayInputStream wmiByteArrayInputStream) throws IOException {
        return this.readDotm(wmiByteArrayInputStream, 42, DagBuilder.parseShortInteger(wmiByteArrayInputStream));
    }

    public void writeDotm(StringBuffer stringBuffer, Dag dag) {
        this.writeDotm(stringBuffer, dag, 42, true);
    }

    public void linePrint(StringBuffer stringBuffer, Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        int n = dag.getLength();
        if (n == 6) {
            stringBuffer.append(this.buildFirstLine(dag, wmiLPrintOptions));
            DagBuilder.linePrint(stringBuffer, dag.getChild(5), wmiLPrintOptions);
            stringBuffer.append(" end do");
        } else {
            stringBuffer.append(this.buildShortFirstLine(dag, wmiLPrintOptions));
            DagBuilder.linePrint(stringBuffer, dag.getChild(3), wmiLPrintOptions);
            stringBuffer.append(" end do");
        }
    }

    public LayoutBox createLayout(LayoutFormatter layoutFormatter, Dag dag) {
        InlineLayoutBox inlineLayoutBox = new InlineLayoutBox(4);
        LayoutBox layoutBox = null;
        int n = 0;
        int n2 = dag.getLength();
        if (n2 == 6) {
            inlineLayoutBox.addChild(this.layoutFirstLine(layoutFormatter, dag));
            n = 5;
        } else {
            inlineLayoutBox.addChild(this.layoutShortFirstLine(layoutFormatter, dag));
            n = 3;
        }
        layoutBox = ProcTemplate.layoutStatement(layoutFormatter, dag.getChild(n));
        if (!(layoutBox.getChild(0) instanceof ProcTemplate.ProcDelimiter)) {
            // empty if block
        }
        inlineLayoutBox.addChild(layoutBox);
        ProcTemplate.addNeededDelimiter(layoutFormatter, inlineLayoutBox);
        inlineLayoutBox.addChild(NotationLayoutBox.createNotationBox(layoutFormatter, longForm ? 70 : 50));
        inlineLayoutBox.addChild(ProcTemplate.createSemiColon(layoutFormatter));
        inlineLayoutBox.addChild(new ProcTemplate.ProcDelimiter(layoutFormatter));
        inlineLayoutBox.setLineBreaker(LineBreakerFactory.newLineBreaker((int)16));
        return inlineLayoutBox;
    }

    private LayoutBox layoutFirstLine(LayoutFormatter layoutFormatter, Dag dag) {
        InlineLayoutBox inlineLayoutBox = new InlineLayoutBox(2);
        Dag dag2 = dag.getChild(0);
        if (!DagUtil.isNull(dag2)) {
            this.appendLayout(layoutFormatter, inlineLayoutBox, 43, dag2);
        }
        if (!DagUtil.isOne(dag2 = dag.getChild(1))) {
            this.appendLayout(layoutFormatter, inlineLayoutBox, 45, dag2);
        }
        if (!DagUtil.isOne(dag2 = dag.getChild(2))) {
            this.appendLayout(layoutFormatter, inlineLayoutBox, 46, dag2);
        }
        if (!DagUtil.isNull(dag2 = dag.getChild(3))) {
            this.appendLayout(layoutFormatter, inlineLayoutBox, 47, dag2);
        }
        if (!DagUtil.isName(dag2 = dag.getChild(4)) || !DagUtil.isTrue(dag2)) {
            this.appendLayout(layoutFormatter, inlineLayoutBox, 48, dag2);
        }
        this.appendLayout(layoutFormatter, inlineLayoutBox, 49, null);
        return inlineLayoutBox;
    }

    private LayoutBox layoutShortFirstLine(LayoutFormatter layoutFormatter, Dag dag) {
        InlineLayoutBox inlineLayoutBox = new InlineLayoutBox();
        Dag dag2 = dag.getChild(0);
        if (!DagUtil.isNull(dag2)) {
            this.appendLayout(layoutFormatter, inlineLayoutBox, 43, dag2);
        }
        if (!DagUtil.isOne(dag2 = dag.getChild(1))) {
            this.appendLayout(layoutFormatter, inlineLayoutBox, 44, dag2);
        }
        if (!DagUtil.isName(dag2 = dag.getChild(2)) || !DagUtil.isTrue(dag2)) {
            this.appendLayout(layoutFormatter, inlineLayoutBox, 48, dag2);
        }
        this.appendLayout(layoutFormatter, inlineLayoutBox, 49, null);
        return inlineLayoutBox;
    }

    private void appendLayout(LayoutFormatter layoutFormatter, LayoutBox layoutBox, int n, Dag dag) {
        layoutBox.addChild(NotationLayoutBox.createNotationBox(layoutFormatter, n));
        layoutBox.addChild(NotationLayoutBox.createCustomBox(layoutFormatter, " "));
        if (dag != null) {
            layoutBox.addChild(DagBuilder.createLayout(layoutFormatter, dag));
            layoutBox.addChild(NotationLayoutBox.createCustomBox(layoutFormatter, " "));
        }
    }

    private String buildFirstLine(Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        StringBuffer stringBuffer = new StringBuffer();
        Dag dag2 = dag.getChild(0);
        if (!DagUtil.isNull(dag2)) {
            stringBuffer.append(FOR_KEYWORDS[0]);
            DagBuilder.linePrint(stringBuffer, dag2, wmiLPrintOptions);
            stringBuffer.append(" ");
        }
        if (!DagUtil.isOne(dag2 = dag.getChild(1))) {
            stringBuffer.append(FOR_KEYWORDS[1]);
            DagBuilder.linePrint(stringBuffer, dag2, wmiLPrintOptions);
            stringBuffer.append(" ");
        }
        if (!DagUtil.isOne(dag2 = dag.getChild(2))) {
            stringBuffer.append(FOR_KEYWORDS[2]);
            DagBuilder.linePrint(stringBuffer, dag2, wmiLPrintOptions);
            stringBuffer.append(" ");
        }
        if (!DagUtil.isNull(dag2 = dag.getChild(3))) {
            stringBuffer.append(FOR_KEYWORDS[3]);
            DagBuilder.linePrint(stringBuffer, dag2, wmiLPrintOptions);
            stringBuffer.append(" ");
        }
        if (!DagUtil.isName(dag2 = dag.getChild(4)) || !DagUtil.isTrue(dag2)) {
            stringBuffer.append(FOR_KEYWORDS[4]);
            DagBuilder.linePrint(stringBuffer, dag2, wmiLPrintOptions);
            stringBuffer.append(" ");
        }
        stringBuffer.append("do ");
        return stringBuffer.toString();
    }

    private String buildShortFirstLine(Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        StringBuffer stringBuffer = new StringBuffer();
        Dag dag2 = dag.getChild(0);
        if (!DagUtil.isNull(dag2)) {
            stringBuffer.append(FOR_KEYWORDS[0]);
            DagBuilder.linePrint(stringBuffer, dag2, wmiLPrintOptions);
            stringBuffer.append(" ");
        }
        if (!DagUtil.isOne(dag2 = dag.getChild(1))) {
            stringBuffer.append(FOR_KEYWORDS[5]);
            DagBuilder.linePrint(stringBuffer, dag2, wmiLPrintOptions);
            stringBuffer.append(" ");
        }
        if (!DagUtil.isName(dag2 = dag.getChild(2)) || !DagUtil.isTrue(dag2)) {
            stringBuffer.append(FOR_KEYWORDS[4]);
            DagBuilder.linePrint(stringBuffer, dag2, wmiLPrintOptions);
            stringBuffer.append(" ");
        }
        stringBuffer.append("do ");
        return stringBuffer.toString();
    }
}

