/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.AbstractBinopDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreaker;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.template.BinaryOperationTemplate;

public class ExpseqDagFactory
extends AbstractBinopDagFactory {
    public static Dag createExpseqDag(Dag[] dagArray) {
        return Dag.createDag(29, dagArray, null, true);
    }

    public int getType() {
        return 29;
    }

    public String getStringOperator(WmiLPrintOptions wmiLPrintOptions) {
        if (wmiLPrintOptions.isNoCommasInExpression()) {
            return " ";
        }
        return ", ";
    }

    public NotationLayoutBox createNotationBox(LayoutFormatter layoutFormatter) {
        return NotationLayoutBox.createNotationBox(layoutFormatter, 14);
    }

    public boolean isVariableLength() {
        return true;
    }

    public LayoutBox createLayout(LayoutFormatter layoutFormatter, Dag dag) {
        int n = dag.getLength();
        ExpSeqLayoutBox expSeqLayoutBox = new ExpSeqLayoutBox(2 * n);
        if (n > 0) {
            int n2 = n;
            for (int i = 0; i < n2; ++i) {
                if (n2 > this.elideThreshold && i == this.leftSample && n2 > this.leftSample + this.rightSample) {
                    NotationLayoutBox notationLayoutBox = NotationLayoutBox.createCustomBox(layoutFormatter, "[..." + (n2 - this.leftSample - this.rightSample) + " terms...]");
                    expSeqLayoutBox.addChild(this.createNotationBox(layoutFormatter));
                    expSeqLayoutBox.addChild(notationLayoutBox);
                    i = n2 - this.rightSample;
                    if (i == n2) break;
                }
                BinaryOperationTemplate.apply(layoutFormatter, (LayoutBox)expSeqLayoutBox, this.createNotationBox(layoutFormatter), dag.getChild(i), this.getPrecedence());
            }
        }
        return expSeqLayoutBox;
    }

    public void linePrint(StringBuffer stringBuffer, Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        this.infixLinePrint(stringBuffer, dag, wmiLPrintOptions);
    }

    static class ExpSeqLayoutBox
    extends InlineLayoutBox {
        private static LineBreaker lb = LineBreakerFactory.newLineBreaker((int)2);

        public ExpSeqLayoutBox(String string, int n) {
            super(string, n);
        }

        public ExpSeqLayoutBox(int n) {
            super(n);
        }

        public void setLineBreaker(LineBreaker lineBreaker) {
        }

        public LineBreaker getLineBreaker() {
            return lb;
        }
    }
}

