/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.BranchDag;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagConstants;
import com.maplesoft.client.dag.HfloatDagFactory;
import com.maplesoft.client.dag.ProcDagFactory;
import com.maplesoft.client.prettyprinter.template.RtableTemplate;
import java.util.ArrayList;

public class DagUtil {
    private static final int MODULECALL = 0;
    private static final int FIRSTARGDAG = 1;
    private static final String FLOAT = "Float";
    private static final String UNDEFINED = "undefined";
    private static final String INFINITY = "infinity";
    private static final String MINUS_INFINITY = "-infinity";
    private static final String RTABLE = "RTABLE";

    public static void getRTables(Dag dag, ArrayList arrayList) {
        if (DagUtil.isBranchDag(dag)) {
            int n = dag.getLength();
            for (int i = 0; i < n; ++i) {
                Dag dag2 = dag.getChild(i);
                long l = DagUtil.identifyRTableFunction(dag2);
                if (l > 0L) {
                    long l2 = RtableTemplate.getCorretedRTableID(l);
                    if (l != l2) {
                        RtableTemplate.updateRTableID(dag2, l2);
                        l = l2;
                    }
                    arrayList.add(new Long(l));
                }
                DagUtil.getRTables(dag2, arrayList);
            }
        }
    }

    public static Dag unwrapExpSeq(Dag dag) {
        Dag dag2 = dag;
        if (dag2 != null && DagUtil.isExpSeq(dag2) && dag2.getLength() == 1) {
            dag2 = dag2.getChild(0);
        }
        return dag2;
    }

    public static String encodeDotmForString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\"' || cArray[i] == '\\') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String decodeDotmForString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            if (cArray[i] == '\\' && i + 1 < n && (cArray[i + 1] == '\"' || cArray[i + 1] == '\\')) {
                ++i;
            }
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    public static Dag searchForAttribute(Dag dag, String string) {
        Dag dag2 = null;
        Dag dag3 = null;
        dag2 = dag.getAttributes();
        if (dag2 != null) {
            int n = dag2.getLength();
            for (int i = 0; i < n; ++i) {
                Dag dag4;
                Dag dag5 = dag2.getChild(i);
                if (dag5 == null || dag5.getType() != 20 || (dag4 = dag5.getChild(0)) == null || dag4.getData() == null || !dag4.getData().equals(string)) continue;
                dag3 = dag5.getChild(1);
                break;
            }
        }
        return dag3;
    }

    public static void releaseRTables(Dag dag) {
        if (DagUtil.isBranchDag(dag)) {
            int n = dag.getLength();
            for (int i = 0; i < n; ++i) {
                Dag dag2 = dag.getChild(i);
                if (dag2 == null) continue;
                long l = DagUtil.identifyRTableFunction(dag2);
                if (l > 0L) {
                    RtableTemplate.release(l);
                }
                DagUtil.releaseRTables(dag2);
            }
        }
    }

    public static boolean isBranchDag(Dag dag) {
        return dag.getLength() > 0;
    }

    public static long identifyRTableFunction(Dag dag) {
        long l = -1L;
        if (dag.getType() == 18) {
            Dag dag2;
            Object object;
            int n = dag.getLength();
            boolean bl = false;
            if (n > 0 && (object = dag.getChild(0).getData()) != null && ((String)object).equals(RTABLE)) {
                bl = true;
            }
            if (bl && ((Dag)(object = dag.getChild(1))).getLength() > 0 && (dag2 = ((Dag)object).getChild(0)).getType() == 2) {
                String string = dag2.getData();
                try {
                    l = Long.parseLong(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return l;
    }

    public static boolean isOneElementList(Dag dag) {
        return dag.getType() == 30 && dag.getLength() == 1;
    }

    public static boolean isGarbage(Dag dag) {
        return dag.getType() == 57;
    }

    public static boolean isZero(Dag dag) {
        return dag != null && dag.equals(DagConstants.ZERO);
    }

    public static boolean isPositive(Dag dag) {
        return DagUtil.isNumeric(dag) && !DagUtil.isZero(dag) && !DagUtil.isNegative(dag);
    }

    public static boolean isOne(Dag dag) {
        return dag != null && dag.equals(DagConstants.ONE);
    }

    public static boolean isMinusOne(Dag dag) {
        return dag != null && dag.equals(DagConstants.MINUS_ONE);
    }

    public static boolean isTwo(Dag dag) {
        return dag != null && dag.equals(DagConstants.TWO);
    }

    public static boolean isOneHalf(Dag dag) {
        return dag != null && dag.equals(DagConstants.ONE_HALF);
    }

    public static boolean isNumeric(Dag dag) {
        return dag != null && dag.getType() <= 6;
    }

    public static boolean isFunction(Dag dag) {
        return dag != null && dag.getType() == 18;
    }

    public static boolean isRange(Dag dag) {
        return dag != null && dag.getType() == 35;
    }

    public static boolean isRational(Dag dag) {
        return dag != null && dag.getType() == 3;
    }

    public static boolean isComplex(Dag dag) {
        return dag != null && dag.getType() == 6;
    }

    public static boolean isExpSeq(Dag dag) {
        return dag != null && dag.getType() == 29;
    }

    public static boolean isString(Dag dag) {
        return dag != null && dag.getType() == 7;
    }

    public static boolean isText(Dag dag) {
        return dag != null && (DagUtil.isString(dag) || DagUtil.isName(dag));
    }

    public static boolean isSum(Dag dag) {
        return dag != null && dag.getType() == 16;
    }

    public static boolean isProd(Dag dag) {
        return dag != null && dag.getType() == 14;
    }

    public static boolean isFunctionNamed(Dag dag, String string) {
        String string2;
        boolean bl = false;
        if (DagUtil.isFunction(dag) && dag.getLength() > 0 && (string2 = dag.getChild(0).getData()) != null) {
            bl = string2.equals(string);
        }
        return bl;
    }

    public static boolean isNegative(Dag dag) {
        boolean bl = false;
        if (DagUtil.isNumeric(dag)) {
            switch (dag.getType()) {
                case 1: {
                    bl = true;
                    break;
                }
                case 3: 
                case 4: {
                    bl = DagUtil.isNegative(dag.getChild(0));
                    break;
                }
                case 6: {
                    bl = DagUtil.isNegative(dag.getChild(0));
                    break;
                }
                case 5: {
                    bl = HfloatDagFactory.getDoubleValue(dag) < 0.0;
                }
            }
        } else if (dag.getType() == 16 && dag.getLength() == 2) {
            bl = DagUtil.isNegative(dag.getChild(1));
        }
        return bl;
    }

    public static boolean isNull(Dag dag) {
        return dag != null && dag.equals(DagConstants.EMPTY);
    }

    public static boolean isTrue(Dag dag) {
        return dag != null && dag.getType() == 8 && dag.getData().equals("true");
    }

    public static boolean isName(Dag dag) {
        return dag != null && dag.getType() == 8;
    }

    public static boolean isNameNamed(Dag dag, String string) {
        String string2;
        boolean bl = false;
        if (DagUtil.isName(dag) && (string2 = dag.getData()) != null) {
            bl = string2.equals(string);
        }
        return bl;
    }

    public static boolean isAssignDag(Dag dag) {
        return dag != null && dag.getType() == 41;
    }

    public static boolean isRTableDag(Dag dag) {
        int n;
        boolean bl = false;
        if (DagUtil.isFunction(dag) && (n = dag.getLength()) > 1) {
            int n2;
            String string;
            Dag dag2 = dag.getChild(0);
            String string2 = string = dag2 != null ? dag2.getData() : null;
            if (string != null && string.equals(RTABLE) && (n2 = (dag2 = dag.getChild(1)).getLength()) > 0) {
                Dag dag3 = dag2.getChild(0);
                bl = dag3 != null && dag3.getType() == 2;
            }
        }
        return bl;
    }

    public static Dag negate(Dag dag) {
        Dag dag2 = null;
        if (DagUtil.isNumeric(dag)) {
            switch (dag.getType()) {
                case 2: {
                    dag2 = Dag.createDag(1, null, dag.getData(), false);
                    break;
                }
                case 1: {
                    dag2 = Dag.createDag(2, null, dag.getData(), false);
                    break;
                }
                case 3: 
                case 4: {
                    Dag[] dagArray = new Dag[]{DagUtil.negate(dag.getChild(0)), dag.getChild(1)};
                    dag2 = Dag.createDag(dag.getType(), dagArray, null, false);
                    break;
                }
                case 5: {
                    double d = -HfloatDagFactory.getDoubleValue(dag);
                    long l = Double.doubleToLongBits(d);
                    dag2 = Dag.createDag(5, null, Long.toString(l), false);
                    break;
                }
                case 6: {
                    int n = dag.getLength();
                    Dag[] dagArray = new Dag[n];
                    for (int i = 0; i < n; ++i) {
                        dagArray[i] = DagUtil.negate(dag.getChild(i));
                    }
                    dag2 = Dag.createDag(dag.getType(), dagArray, null, false);
                }
            }
        } else if (dag.getType() == 16 && dag.getLength() == 2) {
            Dag[] dagArray = new Dag[]{dag.getChild(0), DagUtil.negate(dag.getChild(1))};
            dag2 = Dag.createDag(16, dagArray, null, false);
        }
        return dag2;
    }

    public static int parseInt(Dag dag) {
        return (int)DagUtil.parseLong(dag);
    }

    public static Dag createIntDag(int n) {
        return DagUtil.createIntDag((long)n);
    }

    public static Dag createIntDag(long l) {
        int n = 2;
        if (l < 0L) {
            n = 1;
            l = -l;
        }
        return Dag.createDag(n, null, Long.toString(l), false);
    }

    public static long parseLong(Dag dag) {
        long l = 0L;
        l = DagUtil.isPosInt(dag) ? Long.parseLong(dag.getData()) : (DagUtil.isNegInt(dag) ? 0L - Long.parseLong(dag.getData()) : 0L);
        return l;
    }

    public static float parseFloat(Dag dag) {
        return (float)DagUtil.parseDouble(dag);
    }

    public static Dag createFloatDag(float f) {
        if (Float.isNaN(f)) {
            return DagConstants.NAME_UNDEFINED;
        }
        if (Float.isInfinite(f)) {
            return f < 0.0f ? DagConstants.MINUS_INFINITY : DagConstants.INFINITY;
        }
        return DagUtil.createDoubleDag(f);
    }

    public static Dag createDoubleDag(double d) {
        Dag dag = null;
        if (Double.isNaN(d)) {
            dag = DagConstants.NAME_UNDEFINED;
        } else if (Double.isInfinite(d)) {
            dag = d < 0.0 ? DagConstants.MINUS_INFINITY : DagConstants.INFINITY;
        } else {
            int n;
            boolean bl = d < 0.0;
            int n2 = 0;
            String string = String.valueOf(d);
            if (string.charAt(0) == '-') {
                string = string.substring(1, string.length());
                bl = true;
            }
            if ((n = string.indexOf(69)) > -1) {
                n2 = Integer.parseInt(string.substring(n + 1));
                string = string.substring(0, n);
            }
            if ((n = string.indexOf(46)) > -1) {
                n2 -= string.length() - (n + 1);
                string = string.substring(0, n) + string.substring(n + 1, string.length());
            }
            for (n = -1; n < string.length() - 2 && string.charAt(n + 1) == '0'; ++n) {
            }
            if (n > -1) {
                string = string.substring(n + 1);
            }
            Dag[] dagArray = new Dag[]{Dag.createDag(bl ? 1 : 2, null, string, false), Dag.createDag(n2 < 0 ? 1 : 2, null, String.valueOf(n2 < 0 ? -n2 : n2), false)};
            dag = Dag.createDag(4, dagArray, null, false);
        }
        return dag;
    }

    public static double parseDouble(Dag dag) {
        boolean bl;
        double d;
        block47: {
            if (dag == null) {
                return Double.NaN;
            }
            d = 0.0;
            int n = dag.getType();
            bl = true;
            if (n <= 5) {
                try {
                    if (n == 3) {
                        String string = DagBuilder.lPrint(dag.getChild(0));
                        String string2 = DagBuilder.lPrint(dag.getChild(1));
                        d = Double.parseDouble(string) / Double.parseDouble(string2);
                        break block47;
                    }
                    if (n == 5) {
                        d = HfloatDagFactory.getDoubleValue(dag);
                        break block47;
                    }
                    if (n == 4 && DagUtil.isName(dag.getChild(1))) {
                        Dag dag2 = dag.getChild(0);
                        Dag dag3 = dag.getChild(1);
                        String string = dag3.getData();
                        if (UNDEFINED.equals(string)) {
                            d = Double.NaN;
                        } else if (INFINITY.equals(string)) {
                            d = dag2.getType() == 1 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                        } else {
                            bl = false;
                        }
                        break block47;
                    }
                    String string = DagBuilder.lPrint(dag);
                    d = Double.parseDouble(string);
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                }
            } else if (DagUtil.isFunctionNamed(dag, FLOAT)) {
                Dag[] dagArray = dag.getChild(1).getChildrenAsArray();
                if (dagArray.length == 1) {
                    if (DagUtil.isNameNamed(dagArray[0], UNDEFINED)) {
                        d = Double.NaN;
                    } else if (DagUtil.isNameNamed(dagArray[0], INFINITY)) {
                        d = Double.POSITIVE_INFINITY;
                    } else if (DagUtil.isNameNamed(dagArray[0], MINUS_INFINITY)) {
                        d = Double.NEGATIVE_INFINITY;
                    } else {
                        bl = false;
                    }
                } else {
                    Dag dag4 = dagArray[1];
                    if (DagUtil.isNameNamed(dag4, INFINITY)) {
                        d = dagArray[0].getType() == 1 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                    } else if (DagUtil.isNameNamed(dag4, UNDEFINED)) {
                        d = Double.NaN;
                    } else {
                        try {
                            d = Double.parseDouble(DagBuilder.lPrint(dag));
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl = false;
                        }
                    }
                }
            } else if (dag.getType() == 8) {
                String string = dag.getData();
                if (UNDEFINED.equals(string)) {
                    d = Double.NaN;
                } else if ("FAIL".equals(string) || INFINITY.equals(string)) {
                    d = Double.POSITIVE_INFINITY;
                } else if (MINUS_INFINITY.equals(string)) {
                    d = Double.NEGATIVE_INFINITY;
                } else {
                    bl = false;
                }
            } else if (DagUtil.isNameNamed(dag, "Pi")) {
                d = Math.PI;
            } else if (DagUtil.isNameNamed(dag, UNDEFINED) || DagUtil.isNameNamed(dag, "FAIL") || DagUtil.isFloat(dag) && DagUtil.isNameNamed(dag.getChild(1), UNDEFINED)) {
                d = Double.NaN;
            } else if (DagUtil.isPosInfinity(dag)) {
                d = Double.POSITIVE_INFINITY;
            } else if (DagUtil.isNegInfinity(dag)) {
                d = Double.NEGATIVE_INFINITY;
            } else {
                try {
                    d = Double.parseDouble(DagBuilder.lPrint(dag));
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                }
            }
        }
        if (!bl) {
            d = Double.NaN;
        }
        return d;
    }

    public static boolean isFloatInfinity(Dag dag) {
        boolean bl = false;
        if (dag != null && dag.getLength() > 0) {
            String string;
            Dag dag2 = dag.getChild(1);
            String string2 = string = dag2 != null ? dag2.getData() : null;
            if (string != null) {
                bl = string.equals(INFINITY);
            }
        }
        return bl;
    }

    public static boolean isInfinity(Dag dag) {
        return DagUtil.isPosInfinity(dag) || DagUtil.isNegInfinity(dag);
    }

    public static boolean isNegInfinity(Dag dag) {
        boolean bl = false;
        if (DagUtil.isSum(dag) && DagUtil.isNameNamed(dag.getChild(0), INFINITY)) {
            Dag dag2 = dag.getChild(1);
            if (DagUtil.isInt(dag2) && DagUtil.parseInt(dag2) == -1) {
                bl = true;
            }
        } else {
            bl = DagConstants.MINUS_INFINITY.equals(dag);
        }
        return bl;
    }

    public static boolean isPosInfinity(Dag dag) {
        return DagUtil.isNameNamed(dag, INFINITY);
    }

    public static Dag createErrorDag(String string) {
        Dag[] dagArray = new Dag[]{DagUtil.createNameDag(string)};
        Dag[] dagArray2 = new Dag[]{DagUtil.createExpSeqDag(dagArray)};
        return Dag.createDag(48, dagArray2, null, false);
    }

    public static Dag createExpSeqDag(Dag[] dagArray) {
        return Dag.createDag(29, dagArray, null, false);
    }

    public static boolean isError(Dag dag) {
        return dag != null && dag.getType() == 48;
    }

    public static Dag createStringDag(String string) {
        return Dag.createDag(7, null, string, false);
    }

    public static Dag createNameDag(String string) {
        return Dag.createDag(8, null, string, false);
    }

    public static Dag createEquationDag(Dag dag, Dag dag2) {
        Dag[] dagArray = new Dag[]{dag, dag2};
        return Dag.createDag(20, dagArray, null, false);
    }

    public static Dag createFunctionDag(String string) {
        return DagUtil.createFunctionDag(string, null);
    }

    public static Dag createFunctionDag(String string, Dag[] dagArray) {
        Dag[] dagArray2 = new Dag[]{DagUtil.createNameDag(string), Dag.createDag(29, dagArray, null, false)};
        return Dag.createDag(18, dagArray2, null, false);
    }

    public static Dag createRangeDag(float f, float f2) {
        return DagUtil.createRangeDag((double)f, (double)f2);
    }

    public static Dag createRangeDag(double d, double d2) {
        Dag[] dagArray = new Dag[]{DagUtil.createDoubleDag(d), DagUtil.createDoubleDag(d2)};
        return Dag.createDag(35, dagArray, null, false);
    }

    public static boolean isPosInt(Dag dag) {
        return dag != null && dag.getType() == 2;
    }

    public static boolean isNegInt(Dag dag) {
        return dag != null && dag.getType() == 1;
    }

    public static boolean isInt(Dag dag) {
        return DagUtil.isPosInt(dag) || DagUtil.isNegInt(dag);
    }

    public static boolean isFloat(Dag dag) {
        return dag != null && dag.getType() == 4;
    }

    public static boolean isFloatZero(Dag dag) {
        return DagUtil.isFloat(dag) && DagUtil.isZero(dag.getChild(0));
    }

    public static boolean isList(Dag dag) {
        return dag != null && dag.getType() == 30;
    }

    public static boolean isEquation(Dag dag) {
        return dag != null && dag.getType() == 20;
    }

    public static boolean isNumber(Dag dag) {
        return dag != null && (DagUtil.isInt(dag) || DagUtil.isFloat(dag));
    }

    public static boolean isMember(Dag dag) {
        return dag != null && dag.getType() == 9;
    }

    public static boolean isprintSlash(Dag dag) {
        boolean bl = false;
        if (DagUtil.isFunction(dag) && DagUtil.isMember(dag.getChild(0)) && DagBuilder.lPrint(dag.getChild(0)).equals("Typesetting:-mprintslash")) {
            bl = true;
        }
        return bl;
    }

    public static Dag getDisplayDataFromPrintslash(Dag dag) {
        Dag dag2 = dag;
        if (DagUtil.isExpSeq(dag)) {
            dag = DagUtil.unwrapExpSeq(dag);
        }
        if (DagUtil.isprintSlash(dag)) {
            Dag dag3 = dag.getChild(1);
            Dag dag4 = dag3.getChild(0);
            dag2 = dag4.getLength() > 1 ? Dag.createDag(29, dag4.getChildrenAsArray(), null, false) : (dag4.getLength() == 0 ? DagConstants.EMPTY : dag4.getChild(0));
        }
        return dag2;
    }

    public static Dag getSemanticDataFromPrintslash(Dag dag) {
        Dag dag2 = dag;
        if (DagUtil.isExpSeq(dag)) {
            dag = DagUtil.unwrapExpSeq(dag);
        }
        if (DagUtil.isprintSlash(dag)) {
            Dag dag3 = dag.getChild(1);
            Dag dag4 = dag3.getChild(1);
            dag2 = dag4.getLength() > 1 ? Dag.createDag(29, dag4.getChildrenAsArray(), null, false) : (dag4.getLength() > 0 ? dag4.getChild(0) : null);
        }
        return dag2;
    }

    public static Dag formatProcParams(Dag dag) {
        Dag dag2 = null;
        if (dag != null && dag.getType() == 34) {
            boolean bl;
            Dag dag3 = dag.getChild(0);
            int n = ProcDagFactory.countNormalParams(dag);
            int n2 = dag3.getLength();
            int n3 = n;
            boolean bl2 = bl = n > 0 && DagUtil.isNameNamed(dag3.getChild(n - 1), " $");
            if (bl) {
                --n3;
            }
            if (n2 > n) {
                Dag[] dagArray = dag3.getChildrenAsArray();
                Dag[] dagArray2 = new Dag[n + 1];
                System.arraycopy(dagArray, 0, dagArray2, 0, n3);
                Dag[] dagArray3 = new Dag[n2 - n];
                System.arraycopy(dagArray, n, dagArray3, 0, n2 - n);
                BranchDag branchDag = new BranchDag(36, dagArray3);
                dagArray2[n3] = branchDag;
                if (bl) {
                    dagArray2[n] = dag3.getChild(n3);
                }
                dag2 = new BranchDag(29, dagArray2);
            } else {
                dag2 = dag3;
            }
        }
        return dag2;
    }

    public static Dag createAssignDag(Dag[] dagArray) {
        return Dag.createDag(41, dagArray, null, false);
    }

    public static Dag createMemberDag(String string, String string2) {
        Dag[] dagArray = new Dag[]{DagUtil.createNameDag(string), DagUtil.createNameDag(string2)};
        return Dag.createDag(9, dagArray, null, false);
    }

    public static Dag createEquationDag(Dag[] dagArray) {
        return Dag.createDag(20, dagArray, null, false);
    }

    public static Dag createListDag(Dag[] dagArray) {
        return Dag.createDag(30, dagArray, null, false);
    }

    public static Dag createTableRefDag(Dag dag, Dag dag2) {
        return Dag.createDag(10, new Dag[]{dag, dag2}, null, false);
    }

    public static long countNodes(Dag dag, long l) {
        if (dag instanceof BranchDag) {
            l += (long)dag.getLength();
            for (int i = 0; i < dag.getLength(); ++i) {
                l += DagUtil.countNodes(dag.getChild(i), 0L);
            }
        }
        return l;
    }

    public static boolean isMVerbatim(Dag dag) {
        boolean bl = false;
        if (DagUtil.isFunction(dag) && DagUtil.isName(dag.getChild(0)) && "mverbatim".equals(dag.getChild(0).getDataOnly())) {
            bl = true;
        }
        return bl;
    }

    public static boolean isStatSeq(Dag dag) {
        return dag.getType() == 46;
    }

    public static Dag getRTableFromMParsedDag(Dag dag) {
        Dag dag2;
        Dag dag3 = null;
        Dag dag4 = DagUtil.unwrapExpSeq(dag);
        if (dag4.getLength() > 1 && (dag2 = dag4.getChild(1)).getLength() > 1 && DagUtil.isRTableDag(dag4 = dag2.getChild(1))) {
            dag3 = dag4;
        }
        return dag3;
    }

    public static boolean containsRtable(Dag dag) {
        boolean bl = false;
        if (dag instanceof BranchDag) {
            for (int i = 0; i < dag.getLength() && !(bl |= DagUtil.isRTableDag(dag.getChild(i))); ++i) {
            }
        }
        return bl;
    }

    public static String getFunctionName(Dag dag) {
        String string = null;
        if (DagUtil.isFunction(dag) && dag.getLength() > 0) {
            string = dag.getChild(0).getData();
        }
        return string;
    }
}

