/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.KernelInterfaceProperties;
import com.maplesoft.client.MapleNumbers;
import com.maplesoft.client.dag.AbstractDagFactory;
import com.maplesoft.client.dag.AttributedLeafDag;
import com.maplesoft.client.dag.BackrefBuilder;
import com.maplesoft.client.dag.BranchDag;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagConstants;
import com.maplesoft.client.dag.DagConstructor;
import com.maplesoft.client.dag.DagRenderContext;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.DotMParseError;
import com.maplesoft.client.dag.NameDagFactory;
import com.maplesoft.client.dag.ParamDagFactory;
import com.maplesoft.client.dag.ProcDagFactory;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.preprocessor.PreprocessorSubstitutionTable;
import com.maplesoft.client.prettyprinter.AbstractFormatter;
import com.maplesoft.client.prettyprinter.DefaultLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutAnchor;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.LayoutVector;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.PostLayoutJob;
import com.maplesoft.client.prettyprinter.PostLayoutJobQueue;
import com.maplesoft.client.prettyprinter.SubexpressionLabelLayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import com.maplesoft.util.RuntimeLocale;
import com.maplesoft.util.WmiByteArrayInputStream;
import com.maplesoft.util.encoder.KernelEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DagBuilder {
    String PositiveINT = "INTPOS(1)";
    String NegativeINT = "INTNEG(1)";
    static String DotMParseErrorString = "Input Error at 4: unexpected end of input";
    static HandleAssumptionPostProcessor assumptionHandler = new HandleAssumptionPostProcessor();
    public static HashMap elementToType = new HashMap();
    public static final String[] ELEMENT_NAME = new String[]{"", "intneg", "intpos", "rational", "float", "hfloat", "complex", "string", "name", "member", "tableref", "dcolon", "catenate", "power", "prod", "series", "sum", "zppoly", "function", "uneval", "equation", "inequat", "lesseq", "lessthan", "and", "not", "or", "xor", "implies", "expseq", "list", "local", "param", "lexical", "proc", "range", "set", "table", "rtable", "moddef", "module", "assign", "for", "if", "read", "save", "statseq", "stop", "error", "try", "return", "break", "next", "use", "binary", "hash", "backref", "garbage", "foreign", "control", "debug"};
    public static String[] CLASS_NAMES = new String[]{"", "IntnegDagFactory", "IntposDagFactory", "RationalDagFactory", "FloatDagFactory", "HfloatDagFactory", "ComplexDagFactory", "StringDagFactory", "NameDagFactory", "MemberDagFactory", "TablerefDagFactory", "DcolonDagFactory", "CatenateDagFactory", "PowerDagFactory", "ProdDagFactory", "SeriesDagFactory", "SumDagFactory", "ZppolyDagFactory", "FunctionDagFactory", "UnevalDagFactory", "EquationDagFactory", "InequatDagFactory", "LesseqDagFactory", "LessthanDagFactory", "AndDagFactory", "NotDagFactory", "OrDagFactory", "XorDagFactory", "ImpliesDagFactory", "ExpseqDagFactory", "ListDagFactory", "LocalDagFactory", "ParamDagFactory", "LexicalDagFactory", "ProcDagFactory", "RangeDagFactory", "SetDagFactory", "TableDagFactory", "RtableDagFactory", "ModdefDagFactory", "ModuleDagFactory", "AssignDagFactory", "ForDagFactory", "IfDagFactory", "ReadDagFactory", "SaveDagFactory", "StatseqDagFactory", "StopDagFactory", "ErrorDagFactory", "TryDagFactory", "ReturnDagFactory", "BreakDagFactory", "NextDagFactory", "UseDagFactory", "BinaryDagFactory", "HashTableDagFactory", "BackrefDagFactory", "GarbageDagFactory", "ForeignDagFactory", "ControlDagFactory", "DebugDagFactory"};
    protected static SelectionData assumptionStatementSelectionData = new SelectionData();
    protected static SelectionData assumptionSelectionData = new SelectionData();
    private static final int PROC_LAST_NORMALIZE_DAG = 6;
    public static final String ATTRIBUTE_LENGTH = "length";
    public static final String ATTRIBUTE_DATA = "data";
    private static DocumentBuilder docBuilder;
    private static int currentMark;
    static Dag dagPosIdentity;
    static Dag dagNegIdentity;
    static AbstractDagFactory[] factories;
    static int dagCount;
    static final int ORIGINALBACKREFARRAYSIZE = 400;
    private static Vector theDags;
    private static BackrefBuilder backRefMap;
    private static boolean wantBackRef;
    InputStream sr;
    static boolean inProc;
    private static int depthCount;
    private static final int MAXDEPTH = 600;
    private static final boolean LPrintDebug = false;
    private static final char[] DIGITS;
    private static StringBuffer digitsBuffer;
    private static char[] hexdigits;
    private static StringBuffer moduleNameBuffer;

    static void fillElement2TypeTable() {
        for (int i = 0; i < ELEMENT_NAME.length; ++i) {
            elementToType.put(ELEMENT_NAME[i], new Integer(i));
        }
    }

    static DocumentBuilder getDocBuilder() {
        if (docBuilder == null) {
            try {
                docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return docBuilder;
    }

    static void readClasses() {
        factories = new AbstractDagFactory[CLASS_NAMES.length];
        int n = 0;
        for (int i = 1; i < CLASS_NAMES.length; ++i) {
            try {
                String string = "com.maplesoft.client.dag." + CLASS_NAMES[i];
                Class<?> clazz = Class.forName(string);
                DagBuilder.factories[i] = (AbstractDagFactory)clazz.newInstance();
                ++n;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        dagPosIdentity = DagConstants.ONE;
        dagNegIdentity = DagConstants.MINUS_ONE;
    }

    public static void depthPlus() throws ArrayIndexOutOfBoundsException {
        if (++depthCount > 600) {
            throw new DotMParseError("Too many levels of recursion for display");
        }
    }

    public static void depthMinus() {
        --depthCount;
    }

    public static void putDag(Dag dag, int n) {
        theDags.set(n - 1, dag);
    }

    public static Dag getDag(int n) {
        return (Dag)theDags.get(n - 1);
    }

    public static int dagCountPlus() {
        theDags.add(DagConstants.EMPTY);
        return ++dagCount;
    }

    public static int getCount() {
        return dagCount;
    }

    public static synchronized Dag createDag(String string) throws IOException {
        return DagBuilder.createDag(string.getBytes());
    }

    public static synchronized Dag createDag(byte[] byArray) throws IOException {
        dagCount = 0;
        WmiByteArrayInputStream wmiByteArrayInputStream = new WmiByteArrayInputStream(byArray);
        Dag dag = null;
        try {
            dag = DagBuilder.create(wmiByteArrayInputStream);
            int n = wmiByteArrayInputStream.available();
        }
        catch (DotMParseError dotMParseError) {
            dag = NameDagFactory.createNameDag(dotMParseError.getMessage());
        }
        if (theDags.size() > 400) {
            theDags.setSize(400);
        }
        theDags.clear();
        depthCount = 0;
        return dag;
    }

    public static Dag create(WmiByteArrayInputStream wmiByteArrayInputStream) throws IOException {
        Dag dag = null;
        int n = wmiByteArrayInputStream.read();
        if (n == -1) {
            return DagConstants.EMPTY;
        }
        int n2 = n - 33 + 1;
        ProcDagFactory.setActiveProcSubtype((char)n);
        int n3 = 0;
        if (n2 > 0) {
            try {
                if (n2 == 84 || n2 == 74) {
                    n3 = 34;
                } else if (n2 >= MapleNumbers.dotMInputTable.length) {
                    dag = ParamDagFactory.createParamDag(n2);
                    n3 = 0;
                } else {
                    n3 = MapleNumbers.dotMInputTable[n2];
                }
                boolean bl = false;
                if (n3 > 60) {
                    switch (n3) {
                        case 105: {
                            dag = factories[31].readDotm(wmiByteArrayInputStream);
                            dag.setType(33);
                            n3 = 0;
                            break;
                        }
                        case 106: {
                            n3 = 31;
                            break;
                        }
                        case 107: {
                            n3 = 32;
                            break;
                        }
                        case 104: {
                            dag = factories[34].readDotm(wmiByteArrayInputStream, 8);
                            n3 = 0;
                            break;
                        }
                        case 109: {
                            dag = factories[34].readDotm(wmiByteArrayInputStream, 9);
                            n3 = 0;
                            break;
                        }
                        case 108: {
                            dag = factories[38].readDotm(wmiByteArrayInputStream, 0);
                            n3 = 0;
                            break;
                        }
                        default: {
                            bl = true;
                            n3 -= 57;
                        }
                    }
                }
                if (n3 > 0) {
                    dag = factories[n3].readDotm(wmiByteArrayInputStream);
                }
                if (bl) {
                    dag.setAttributes(DagBuilder.create(wmiByteArrayInputStream));
                }
            }
            catch (NullPointerException nullPointerException) {
                dag = DagConstants.EMPTY;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new DotMParseError("...");
            }
        }
        return dag;
    }

    public static synchronized String createDotm(Dag dag) {
        return DagBuilder.createDotm(dag, true);
    }

    public static synchronized String createDotm(Dag dag, boolean bl) {
        wantBackRef = bl;
        backRefMap = wantBackRef && (dag.getLength() > 1 || dag.getAttributes() != null) ? (backRefMap = new BackrefBuilder(dag)) : null;
        dag.clearHash();
        StringBuffer stringBuffer = new StringBuffer();
        DagBuilder.writeDotm(stringBuffer, dag);
        backRefMap = null;
        return stringBuffer.toString();
    }

    public static boolean getBackRefFlag() {
        return wantBackRef;
    }

    public static BackrefBuilder getBackrefs() {
        return backRefMap;
    }

    public static void writeDotm(StringBuffer stringBuffer, Dag dag) {
        if (dag != null && stringBuffer != null) {
            int n = dag.getType();
            factories[n].writeDotm(stringBuffer, dag);
        }
    }

    public static String writeDotm(Dag dag) {
        StringBuffer stringBuffer = new StringBuffer();
        DagBuilder.writeDotm(stringBuffer, dag);
        return stringBuffer.toString();
    }

    public static Dag createDag(Document document) {
        Dag dag = null;
        dag = DagBuilder.dagFromXML(document.getDocumentElement());
        return dag;
    }

    static Dag dagFromXML(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        NodeList nodeList = node.getChildNodes();
        String string = node.getNodeName();
        int n = -1;
        n = (Integer)elementToType.get(string);
        Node node2 = namedNodeMap.getNamedItem(ATTRIBUTE_DATA);
        int n2 = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof Element)) continue;
            ++n2;
        }
        Dag[] dagArray = null;
        dagArray = new Dag[n2];
        int n3 = 0;
        for (int i = 0; i <= nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof Element)) continue;
            dagArray[n3++] = DagBuilder.dagFromXML(nodeList.item(i));
        }
        if (node2 != null && n2 == 0) {
            dagArray = null;
        }
        return Dag.createDag(n, dagArray, node2 != null ? node2.getNodeValue() : null, true);
    }

    public static int getPrecedence(Dag dag) {
        int n = 20;
        if (dag != null) {
            int n2 = dag.getType();
            n = factories[n2].getPrecedence(dag);
        }
        return n;
    }

    public static int getPrecedence(Dag dag, LayoutFormatter layoutFormatter) {
        int n = 20;
        if (dag != null) {
            int n2 = dag.getType();
            n = factories[n2].getPrecedence(dag, layoutFormatter);
        }
        return n;
    }

    public static int getPrecedence(Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        int n = 20;
        if (dag != null) {
            int n2 = dag.getType();
            n = factories[n2].getPrecedence(dag, wmiLPrintOptions);
        }
        return n;
    }

    public static DagConstructor getConstructor(int n) {
        AbstractDagFactory abstractDagFactory = factories != null ? factories[n] : null;
        return abstractDagFactory != null ? abstractDagFactory.getConstructor() : null;
    }

    public static void updateContext(int n, DagRenderContext dagRenderContext) {
        AbstractDagFactory abstractDagFactory;
        AbstractDagFactory abstractDagFactory2 = abstractDagFactory = factories != null ? factories[n] : null;
        if (abstractDagFactory != null) {
            abstractDagFactory.updateContext(dagRenderContext);
        }
    }

    public static String getName(InputStream inputStream, int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            char c = (char)DagBuilder.getNextChar(inputStream);
            if (c > ' ' && c < '{') {
                stringBuffer.append(c);
                continue;
            }
            if (c == '~') {
                stringBuffer.append(' ');
                continue;
            }
            if (c != '|') continue;
            stringBuffer.append((char)DagBuilder.parseShortInteger(inputStream));
        }
        String string = null;
        string = stringBuffer.toString();
        KernelEncoder kernelEncoder = RuntimeLocale.getKernelEncoder();
        if (kernelEncoder != null) {
            string = kernelEncoder.toUnicode(string, true);
        }
        return string;
    }

    public static void writeNameAsDotm(StringBuffer stringBuffer, String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c > ' ' && c < '{') {
                stringBuffer.append(c);
                continue;
            }
            if (c == ' ') {
                stringBuffer.append("~");
                continue;
            }
            stringBuffer.append("|");
            DagBuilder.writeShortInteger(stringBuffer, c);
        }
    }

    public static int getNextChar(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String parseDigits(InputStream inputStream, int n) throws IOException {
        String string = null;
        StringBuffer stringBuffer = digitsBuffer;
        synchronized (stringBuffer) {
            DagBuilder.parseDigitsIntoBuffer(inputStream, n, digitsBuffer);
            string = digitsBuffer.toString();
            if (digitsBuffer.capacity() > 1000) {
                digitsBuffer.setLength(0);
            }
        }
        return string;
    }

    public static void parseDigitsIntoBuffer(InputStream inputStream, int n, StringBuffer stringBuffer) throws IOException {
        stringBuffer.setLength(n);
        int n2 = 0;
        while (n > 0) {
            n2 = DagBuilder.getNextChar(inputStream);
            if (n2 >= 33 && n2 < 43) {
                stringBuffer.setCharAt(--n, DIGITS[n2 - 33]);
                continue;
            }
            int n3 = (n2 -= 43) * 52429 >>> 19;
            int n4 = n2 - ((n3 << 3) + (n3 << 1));
            stringBuffer.setCharAt(--n, DIGITS[n4]);
            n2 = n3;
            if (n2 > 0) {
                n3 = n2 * 52429 >>> 19;
                n4 = n2 - ((n3 << 3) + (n3 << 1));
                if (n > 0) {
                    stringBuffer.setCharAt(--n, DIGITS[n4]);
                    continue;
                }
                stringBuffer.insert(0, DIGITS[n4]);
                break;
            }
            if (n > 0) {
                stringBuffer.setCharAt(--n, '0');
                continue;
            }
            stringBuffer.insert(0, '0');
            break;
        }
    }

    public static int skipShortInteger(String string, int n) {
        int n2 = n;
        char c = string.charAt(n2);
        if (c == '~') {
            c = string.charAt(++n2);
        }
        ++n2;
        if (c >= '!' && c <= 'Z') {
            return n2;
        }
        while (c >= '[' && c <= 'k') {
            c = string.charAt(n2);
            ++n2;
        }
        return n2;
    }

    public static int parseShortInteger(InputStream inputStream) throws IOException {
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        int n4 = DagBuilder.getNextChar(inputStream);
        if (n4 == 126) {
            n = -1;
            n4 = DagBuilder.getNextChar(inputStream);
        }
        if (n4 >= 33 && n4 <= 90) {
            return n * (n4 - 33);
        }
        n2 = 0;
        n3 = 0;
        while (n4 >= 91 && n4 <= 107) {
            if (n2 > 32) {
                throw new IOException("short integer too large for this system");
            }
            n3 += n4 - 91 << n2;
            n2 += 4;
            n4 = DagBuilder.getNextChar(inputStream);
        }
        if (n4 < 107 || n4 >= 123) {
            throw new DotMParseError("invalid character in short integer encoding " + n4 + " " + (char)n4);
        }
        return (n3 += n4 - 107 << n2) * n;
    }

    public static double parseDouble(InputStream inputStream) throws IOException {
        long l = 0L;
        for (int i = 0; i < 16; ++i) {
            int n = inputStream.read();
            if (n <= 57) {
                n -= 48;
            } else {
                n -= 65;
                n += 10;
            }
            l = (l << 4) + (long)n;
        }
        return Double.longBitsToDouble(l);
    }

    public static void doubleToHex(double d, StringBuffer stringBuffer) {
        long l = Double.doubleToRawLongBits(d);
        for (int i = 15; i >= 0; --i) {
            int n = (int)(l >> i * 4 & 0xFL);
            stringBuffer.append(hexdigits[n]);
        }
    }

    static void pBinLong(long l) {
    }

    static void FillInputTable() {
        for (int i = 1; i < MapleNumbers.dotMOutputTable.length; ++i) {
            MapleNumbers.dotMInputTable[MapleNumbers.dotMOutputTable[i]] = (byte)i;
        }
        MapleNumbers.dotMInputTable[26] = 104;
        MapleNumbers.dotMInputTable[51] = 105;
        MapleNumbers.dotMInputTable[53] = 106;
        MapleNumbers.dotMInputTable[54] = 107;
        MapleNumbers.dotMInputTable[55] = 108;
        MapleNumbers.dotMInputTable[50] = 109;
    }

    public static LayoutBox createNewLayoutBox(LayoutFormatter layoutFormatter, Dag dag) {
        DefaultLayoutBox defaultLayoutBox = null;
        boolean bl = true;
        PreprocessorSubstitutionTable preprocessorSubstitutionTable = null;
        DefaultLayoutBox defaultLayoutBox2 = null;
        DagRenderContext dagRenderContext = layoutFormatter.getContext();
        KernelInterfaceProperties kernelInterfaceProperties = dagRenderContext != null ? dagRenderContext.getInterfaceProperties() : null;
        boolean bl2 = false;
        int n = 20;
        if (kernelInterfaceProperties != null) {
            int n2 = 2;
            boolean bl3 = true;
            n2 = (Integer)kernelInterfaceProperties.getValue("prettyprint");
            bl3 = (Boolean)kernelInterfaceProperties.getValue("labelling");
            boolean bl4 = bl2 = bl3 && (n2 == 2 || n2 == 1);
            if (bl2) {
                n = (Integer)kernelInterfaceProperties.getValue("labelwidth");
            }
            preprocessorSubstitutionTable = kernelInterfaceProperties.getSubstitutionTable();
        }
        assumptionHandler.init(layoutFormatter);
        PostLayoutJobQueue postLayoutJobQueue = layoutFormatter.getPostLayoutJobQueue();
        if (bl2) {
            postLayoutJobQueue.locateDuplicates(dag);
            postLayoutJobQueue.setLabelAllowed(bl2);
            postLayoutJobQueue.setLabelWidth(n);
        }
        LayoutBox layoutBox = DagBuilder.createLayout(layoutFormatter, dag);
        layoutBox.setDag(dag);
        while (!postLayoutJobQueue.isEmpty()) {
            PostLayoutJob postLayoutJob = postLayoutJobQueue.removeFirstJob();
            if (postLayoutJob instanceof AbstractFormatter.SubexpressionLabelJob) {
                if (bl && preprocessorSubstitutionTable != null) {
                    preprocessorSubstitutionTable.flush();
                    bl = false;
                }
                if (defaultLayoutBox2 == null) {
                    defaultLayoutBox2 = new DefaultLayoutBox();
                }
                AbstractFormatter.SubexpressionLabelJob subexpressionLabelJob = (AbstractFormatter.SubexpressionLabelJob)postLayoutJob;
                defaultLayoutBox2.addChild(subexpressionLabelJob.getLegendItem());
                SubexpressionLabelLayoutBox subexpressionLabelLayoutBox = subexpressionLabelJob.getSubexpressionBox();
                if (preprocessorSubstitutionTable == null) continue;
                preprocessorSubstitutionTable.addCommand(subexpressionLabelLayoutBox.getLabel(), subexpressionLabelLayoutBox.getLPrint());
                continue;
            }
            if (!(postLayoutJob instanceof AbstractFormatter.AssumptionLabelJob)) continue;
            assumptionHandler.handleAssumptionJob((AbstractFormatter.AssumptionLabelJob)postLayoutJob);
        }
        if (defaultLayoutBox2 != null) {
            defaultLayoutBox = new DefaultLayoutBox();
            defaultLayoutBox.addChild(layoutBox);
            for (int i = 0; i < defaultLayoutBox2.numChildren() - 1; ++i) {
                defaultLayoutBox2.addLayoutAnchor(LayoutAnchor.createTopToBottomAnchor(i));
            }
            defaultLayoutBox.addChild(defaultLayoutBox2);
        }
        assumptionHandler.completeAssumptions();
        LayoutBox layoutBox2 = assumptionHandler.getAssumptionsLayout();
        if (layoutBox2 != null) {
            if (defaultLayoutBox == null) {
                defaultLayoutBox = new DefaultLayoutBox();
                defaultLayoutBox.addChild(layoutBox);
            }
            defaultLayoutBox.setSelectionData(assumptionSelectionData);
            defaultLayoutBox.addChild(layoutBox2);
        }
        if (defaultLayoutBox != null) {
            layoutBox = defaultLayoutBox;
            for (int i = 0; i < layoutBox.numChildren() - 1; ++i) {
                layoutBox.addLayoutAnchor(new LayoutAnchor(i, LayoutVector.SOUTH, i + 1, LayoutVector.NORTH));
            }
        }
        if (defaultLayoutBox2 != null || layoutBox2 != null) {
            layoutBox.setLineBreaker(LineBreakerFactory.newLineBreaker((int)15));
        }
        assumptionHandler.releaseResources();
        return layoutBox;
    }

    public static LayoutBox createLayout(LayoutFormatter layoutFormatter, Dag dag) {
        Dag dag2 = dag.getNormalized();
        PostLayoutJobQueue postLayoutJobQueue = layoutFormatter.getPostLayoutJobQueue();
        if (dag2 == null) {
            dag2 = dag;
        }
        int n = dag2.getType();
        LayoutBox layoutBox = factories[n].createLayout(layoutFormatter, dag2);
        layoutBox.setDag(dag);
        if (postLayoutJobQueue.getLabelAllowed()) {
            layoutBox = postLayoutJobQueue.subexpressionLabel(layoutFormatter, layoutBox, dag);
        }
        return layoutBox;
    }

    public static String lPrintRTable(Dag dag) {
        dag = DagUtil.unwrapExpSeq(dag);
        StringBuffer stringBuffer = new StringBuffer();
        Dag dag2 = dag.getChild(1);
        String string = dag2.getChild(0).getData();
        stringBuffer.append("Matrix");
        stringBuffer.append("(%id = ");
        stringBuffer.append(string);
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }

    public static synchronized String lPrint(Dag dag) {
        return DagBuilder.lPrint(dag, new WmiLPrintOptions());
    }

    public static synchronized String lPrint(Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        StringBuffer stringBuffer = new StringBuffer();
        if (dag != null) {
            int n = dag.getType();
            Dag dag2 = null;
            inProc = false;
            if (n == 29 && dag.getLength() == 1) {
                dag2 = dag.getChild(0).getNormalized();
                return DagBuilder.lPrint(dag2, wmiLPrintOptions);
            }
            dag2 = dag.getNormalized();
            if (dag2 == null) {
                dag2 = dag;
            }
            DagBuilder.linePrint(stringBuffer, dag2, wmiLPrintOptions);
        }
        return stringBuffer.toString();
    }

    public static void linePrint(StringBuffer stringBuffer, Dag dag) {
        DagBuilder.linePrint(stringBuffer, dag, new WmiLPrintOptions());
    }

    public static void linePrint(StringBuffer stringBuffer, Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        if (dag == null) {
            return;
        }
        Dag dag2 = dag.getNormalized();
        if (dag2 == null) {
            dag2 = dag;
        }
        factories[dag2.getType()].linePrint(stringBuffer, dag2, wmiLPrintOptions);
    }

    public static String toMathML(Dag dag) {
        int n = dag.getType();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(factories[n].toMathML(dag));
        return stringBuffer.toString();
    }

    public static void writeShortInteger(StringBuffer stringBuffer, int n) {
        int n2 = 0;
        char c = '\u0000';
        if (n < 0) {
            stringBuffer.append('~');
            n = -n;
        }
        if (n < 58) {
            c = (char)(n + 33);
            stringBuffer.append(c);
        } else {
            while (n != 0) {
                n2 = n & 0xF;
                if ((n >>= 4) == 0) {
                    stringBuffer.append((char)(n2 + 107));
                    continue;
                }
                stringBuffer.append((char)(n2 + 91));
            }
        }
    }

    public static void writeDigits(StringBuffer stringBuffer, String string, int n) {
        int n2 = n;
        while (n2 > 0) {
            int n3;
            if (n2 == 1) {
                n3 = Integer.parseInt(string.substring(n2 - 1, n2));
                n2 -= DagBuilder.writeOneOrTwoDigits(-1, n3, stringBuffer);
                continue;
            }
            n3 = Integer.parseInt(string.substring(n2 - 2, n2));
            int n4 = n3 / 10;
            int n5 = n3 % 10;
            n2 -= DagBuilder.writeOneOrTwoDigits(n4, n5, stringBuffer);
        }
    }

    public static void writeDigits1(StringBuffer stringBuffer, String string, int n) {
        int n2 = n;
        while (n2 > 0) {
            int n3;
            if (n2 == 1) {
                n3 = Integer.parseInt(string.substring(n2 - 1, n2));
                n2 -= DagBuilder.writeOneOrTwoDigits(-1, n3, stringBuffer);
                continue;
            }
            n3 = Integer.parseInt(string.substring(n2 - 2, n2));
            int n4 = n3 / 10;
            int n5 = n3 % 10;
            n2 -= DagBuilder.writeOneOrTwoDigits(n4, n5, stringBuffer);
        }
    }

    private static int writeOneOrTwoDigits(int n, int n2, StringBuffer stringBuffer) {
        int n3;
        if (n > -1 && (n3 = 10 * n + n2) <= 79) {
            stringBuffer.append((char)(43 + n3));
            return 2;
        }
        stringBuffer.append((char)(33 + n2));
        return 1;
    }

    public static int getCurrentMarkID() {
        return currentMark;
    }

    public static synchronized Dag normalize(Dag dag) {
        Dag dag2 = null;
        int n = 0;
        Dag dag3 = dag2 = dag.isNormalized() ? dag.getNormalized() : null;
        if (dag2 == null) {
            n = dag.getLength();
            int n2 = dag.getType();
            if (n2 == 34) {
                ProcDagFactory.addToStacks(dag);
                n = 6;
            } else if (n2 == 39) {
                n = 6;
                ProcDagFactory.addToStacks(dag.getChild(0), dag.getChild(1), dag.getChild(7), dag.getChild(3));
            }
            Dag dag4 = null;
            Dag dag5 = null;
            Dag dag6 = null;
            if (dag.getLength() > 0) {
                for (int i = 0; i < n; ++i) {
                    dag6 = dag.getChild(i);
                    int n3 = dag6.getType();
                    if (n3 == 32 || n3 == 31 || n3 == 33) {
                        dag6 = Dag.createDag(n3, dag6.getChildrenAsArray(), dag6.getData(), false);
                    }
                    if (dag6 == null || (dag5 = DagBuilder.normalize(dag6)) == dag6) continue;
                    if (dag4 == null) {
                        dag4 = dag.copy();
                    }
                    dag4.setChild(i, dag5);
                }
                if (dag4 != null) {
                    dag = dag4;
                }
            }
            dag2 = factories[dag.getType()].normalize(dag);
            if (dag.getType() == 34) {
                ProcDagFactory.removeStacks(dag);
            } else if (dag.getType() == 39) {
                ProcDagFactory.removeStacks();
            }
            if (dag2 == null) {
                dag2 = dag;
            }
        }
        return dag2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getModuleName(Dag dag) {
        String string = null;
        StringBuffer stringBuffer = moduleNameBuffer;
        synchronized (stringBuffer) {
            DagBuilder.createModuleName(dag, moduleNameBuffer);
            string = moduleNameBuffer.toString();
            moduleNameBuffer.setLength(0);
        }
        return string;
    }

    private static void createModuleName(Dag dag, StringBuffer stringBuffer) {
        if (dag instanceof BranchDag) {
            int n = dag.getLength();
            for (int i = 0; i < n; ++i) {
                Dag dag2;
                Dag dag3 = dag.getChild(i);
                if (dag3.getType() != 20 || !((dag2 = dag3.getChild(0)) instanceof AttributedLeafDag) || !dag2.getData().equals("modulename")) continue;
                Dag dag4 = dag3.getChild(1);
                if (stringBuffer.length() > 0) {
                    stringBuffer.insert(0, ":-");
                }
                String string = null;
                string = dag4 instanceof AttributedLeafDag ? ((AttributedLeafDag)dag4).getDataOnly() : dag4.getData();
                stringBuffer.insert(0, string);
                DagBuilder.createModuleName(dag4.getAttributes(), stringBuffer);
                break;
            }
        }
    }

    static {
        DagBuilder.FillInputTable();
        DagBuilder.readClasses();
        DagBuilder.fillElement2TypeTable();
        assumptionSelectionData.setFirstCaretPosition(0);
        assumptionSelectionData.setLastCaretPosition(1);
        assumptionSelectionData.setContextHelpAvailable(false);
        assumptionSelectionData.setSelectionCode(4);
        assumptionSelectionData.setTraversalNorthSouth(new int[]{0, 1, -10});
        assumptionSelectionData.setTraversalEastWest(new int[]{0, 1, -10});
        assumptionStatementSelectionData.setContextHelpAvailable(false);
        assumptionStatementSelectionData.setSelectionCode(4);
        assumptionStatementSelectionData.setTraversalNorthSouth(new int[]{-10});
        assumptionStatementSelectionData.setTraversalEastWest(new int[]{-10});
        theDags = new Vector(400);
        wantBackRef = true;
        inProc = false;
        DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        digitsBuffer = new StringBuffer();
        hexdigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        moduleNameBuffer = new StringBuffer();
    }

    private static class HandleAssumptionPostProcessor {
        LayoutBox assumptions;
        LinkedList assumpList = new LinkedList();
        LayoutFormatter f;

        public LayoutBox getAssumptionsLayout() {
            return this.assumptions;
        }

        public void init(LayoutFormatter layoutFormatter) {
            this.assumptions = null;
            this.assumpList.clear();
            this.f = layoutFormatter;
        }

        public void releaseResources() {
            this.assumptions = null;
            this.assumpList.clear();
            this.f = null;
        }

        protected void handleAssumptionJob(AbstractFormatter.AssumptionLabelJob assumptionLabelJob) {
            if (this.assumptions == null) {
                this.assumptions = new DefaultLayoutBox();
                NotationLayoutBox notationLayoutBox = NotationLayoutBox.createCustomBox(this.f, "with ");
                NotationLayoutBox notationLayoutBox2 = NotationLayoutBox.createCustomBox(this.f, "assumptions ");
                NotationLayoutBox notationLayoutBox3 = NotationLayoutBox.createCustomBox(this.f, "on ");
                notationLayoutBox.setLineBreaker(LineBreakerFactory.newLineBreaker((int)8));
                notationLayoutBox2.setLineBreaker(LineBreakerFactory.newLineBreaker((int)8));
                notationLayoutBox3.setLineBreaker(LineBreakerFactory.newLineBreaker((int)8));
                this.assumptions.addChild(notationLayoutBox);
                this.assumptions.addChild(notationLayoutBox2);
                this.assumptions.addChild(notationLayoutBox3);
                this.assumptions.setSelectionData(assumptionStatementSelectionData);
            }
            this.assumpList.add(assumptionLabelJob.getVariable());
        }

        protected void completeAssumptions() {
            if (this.assumptions != null) {
                int n;
                for (n = 0; n < this.assumpList.size(); ++n) {
                    if (n != 0) {
                        if (n == this.assumpList.size() - 1) {
                            this.assumptions.addChild(NotationLayoutBox.createCustomBox(this.f, " and "));
                        } else {
                            this.assumptions.addChild(NotationLayoutBox.createCustomBox(this.f, ", "));
                        }
                    }
                    this.assumptions.addChild((LayoutBox)this.assumpList.get(n));
                }
                for (n = 0; n < this.assumptions.numChildren() - 1; ++n) {
                    this.assumptions.addLayoutAnchor(LayoutAnchor.createLeftToRightAnchor(n));
                }
            }
        }
    }
}

