/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.AttributedBranchDag;
import com.maplesoft.client.dag.AttributedLeafDag;
import com.maplesoft.client.dag.BranchDag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagConstructor;
import com.maplesoft.client.dag.HybridDag;
import com.maplesoft.client.dag.LeafDag;

public abstract class Dag {
    protected int theType;
    protected Dag normalized;
    protected int hash;

    protected Dag(int n) {
        this.theType = n;
    }

    public static Dag createDag(int n, Dag[] dagArray, Object object, boolean bl) {
        Dag dag = null;
        DagConstructor dagConstructor = DagBuilder.getConstructor(n);
        dag = dagConstructor == null ? (dagArray != null && object == null ? (bl ? new AttributedBranchDag(n, dagArray) : new BranchDag(n, dagArray)) : (object != null && dagArray == null ? (bl ? new AttributedLeafDag(n, object) : new LeafDag(n, object)) : new HybridDag(n, dagArray, object))) : dagConstructor.createDag(n, dagArray, object, bl);
        return dag;
    }

    public void setType(int n) {
        this.theType = n;
    }

    public int getType() {
        return this.theType;
    }

    public void addChild(Dag dag) {
        this.insertChild(this.getLength(), dag);
    }

    public abstract void insertChild(int var1, Dag var2);

    public abstract void insertChildren(int var1, Dag[] var2);

    public abstract int getLength();

    public abstract void setLength(int var1);

    public abstract void setChild(int var1, Dag var2);

    public abstract void replaceChildren(int var1, int var2, Dag var3);

    public abstract void replaceChildren(int var1, int var2, Dag[] var3);

    public abstract void removeChild(int var1);

    public abstract Dag getChild(int var1);

    public abstract Dag copy();

    public Dag deepCopy() {
        return this.copy();
    }

    public abstract void setChildren(Dag[] var1);

    public abstract void setDags(Dag[] var1);

    public abstract void setData(Object var1);

    public abstract String getData();

    public String getDataOnly() {
        return this.getData();
    }

    public void setAttributes(Dag dag) {
    }

    public Dag getAttributes() {
        return null;
    }

    public boolean isNormalized() {
        return this.normalized != null;
    }

    public Dag getNormalized() {
        if (this.normalized == null) {
            this.normalized = DagBuilder.normalize(this);
        }
        return this.normalized;
    }

    public void setNormalized(Dag dag) {
        if (dag != null) {
            this.normalized = dag;
            dag.normalized = dag;
        }
    }

    public Dag[] getChildrenAsArray() {
        return null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Dag)) {
            return false;
        }
        Dag dag = (Dag)object;
        if (this.hashCode() != object.hashCode()) {
            return false;
        }
        if (dag.getType() != this.theType) {
            return false;
        }
        String string = this.getData();
        if (string != null && !string.equals(dag.getData())) {
            return false;
        }
        if (string == null && dag.getData() != null) {
            return false;
        }
        int n = this.getLength();
        if (dag.getLength() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            Dag dag2 = this.getChild(i);
            Dag dag3 = dag.getChild(i);
            if (dag2.hashCode() != dag3.hashCode()) {
                return false;
            }
            if (dag2.equals(dag3)) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        if (this.hash == 0) {
            this.hash = this.computeHashCode();
            if (this.hash < 0) {
                this.hash = -this.hash;
            }
        }
        return this.hash;
    }

    public abstract int computeHashCode();

    public void clearHash() {
        this.hash = 0;
        int n = this.getLength();
        for (int i = 0; i < n; ++i) {
            Dag dag = this.getChild(i);
            if (dag == null) continue;
            dag.clearHash();
        }
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        String string2 = "";
        String string3 = this.getDataOnly();
        int n = this.getLength();
        string2 = string2 + DagBuilder.CLASS_NAMES[this.theType] + "#" + this.theType + " {" + System.identityHashCode(this) + "} |" + string3 + "| - ";
        if (n > 0) {
            string2 = string2 + " (" + n + ")";
            for (int i = 0; i < n; ++i) {
                string2 = string2 + "\n" + string + ".   " + (i + 1) + "  ";
                Dag dag = this.getChild(i);
                string2 = dag == null ? string2 + "--> null" : string2 + dag.toString(string + ".   ");
            }
        } else if (this instanceof AttributedLeafDag && !this.equals(this.getAttributes()) && this.getAttributes() != null) {
            string2 = string2 + "\n" + string + ".   *" + this.getAttributes().toString(string + ".   ");
        }
        return string2;
    }

    public void dispose() {
    }
}

