/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client;

import com.maplesoft.client.ClientReady;
import com.maplesoft.client.CommandQueue;
import com.maplesoft.client.KernelCommunicationError;
import com.maplesoft.client.KernelConnectionEvent;
import com.maplesoft.client.KernelConnectionListener;
import com.maplesoft.client.KernelInterfaceProperties;
import com.maplesoft.client.KernelListener;
import com.maplesoft.client.KernelPortReady;
import com.maplesoft.client.KernelProxy;
import com.maplesoft.client.MapleClientSocket;
import com.maplesoft.client.MapleServerSocket;
import com.maplesoft.client.RedirectedKernelListener;
import com.maplesoft.client.preprocessor.KernelInputPreprocessor;
import com.maplesoft.util.RuntimeLocale;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class KernelConnection {
    private static final boolean DEBUG_PRINT = false;
    private KernelProxy kernelProxy;
    MapleClientSocket clientSocket;
    MapleServerSocket serverSocket;
    private CommandQueue commandQueue;
    private Vector listeners;
    private KernelInterfaceProperties interfaceProperties;
    private RedirectedKernelListener redirectedListener = null;
    private static int startupPort = -1;

    public KernelConnection(KernelProxy kernelProxy) {
        this.kernelProxy = kernelProxy;
        this.commandQueue = new CommandQueue();
        this.listeners = new Vector();
        this.interfaceProperties = new KernelInterfaceProperties(this);
    }

    CommandQueue getQueue() {
        return this.commandQueue;
    }

    public void queueCommand(KernelProxy.KernelTransaction kernelTransaction) {
        this.commandQueue.push(kernelTransaction);
    }

    void queueUrgentCommand(KernelProxy.KernelTransaction kernelTransaction) {
        this.commandQueue.urgent(kernelTransaction);
    }

    public void sendCommand(KernelListener kernelListener, String string, int n) {
        int n2;
        string = string.trim();
        if (this.redirectedListener != null) {
            this.redirectedListener.writeInput(string);
        }
        if ((n2 = string.length()) >= 1) {
            String[] stringArray = KernelInputPreprocessor.preprocess((String)string, (KernelConnection)this);
            for (int i = 0; i < stringArray.length; ++i) {
                KernelProxy.KernelTransaction kernelTransaction = this.kernelProxy.createTransaction(kernelListener, stringArray[i], n);
                this.queueCommand(kernelTransaction);
            }
        }
    }

    public void sendUrgentCommand(KernelListener kernelListener, String string, int n) {
        int n2;
        string = string.trim();
        if (this.redirectedListener != null) {
            this.redirectedListener.writeInput(string);
        }
        if ((n2 = string.length()) >= 1) {
            String[] stringArray = KernelInputPreprocessor.preprocess((String)string, (KernelConnection)this);
            for (int i = 0; i < stringArray.length; ++i) {
                KernelProxy.KernelTransaction kernelTransaction = this.kernelProxy.createTransaction(kernelListener, stringArray[i], n);
                this.queueUrgentCommand(kernelTransaction);
            }
        }
    }

    public void sendInternalCommand(KernelListener kernelListener, String string, int n) {
        int n2;
        string = string.trim();
        if (this.redirectedListener != null) {
            this.redirectedListener.writeInput(string);
        }
        if ((n2 = string.length()) >= 1) {
            String[] stringArray = KernelInputPreprocessor.preprocess((String)string, (KernelConnection)this);
            for (int i = 0; i < stringArray.length; ++i) {
                KernelProxy.KernelTransaction kernelTransaction = this.kernelProxy.createTransaction(kernelListener, stringArray[i], n, true);
                this.queueCommand(kernelTransaction);
            }
        }
    }

    public void sendUrgentInternalCommand(KernelListener kernelListener, String string, int n) {
        int n2;
        string = string.trim();
        if (this.redirectedListener != null) {
            this.redirectedListener.writeInput(string);
        }
        if ((n2 = string.length()) >= 1) {
            String[] stringArray = KernelInputPreprocessor.preprocess((String)string, (KernelConnection)this);
            for (int i = 0; i < stringArray.length; ++i) {
                KernelProxy.KernelTransaction kernelTransaction = this.kernelProxy.createTransaction(kernelListener, stringArray[i], n, true);
                this.queueUrgentCommand(kernelTransaction);
            }
        }
    }

    public void setRedirectedListener(RedirectedKernelListener redirectedKernelListener) {
        if (this.redirectedListener != null && this.redirectedListener != redirectedKernelListener) {
            try {
                this.redirectedListener.getRedirector().closeFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.redirectedListener = redirectedKernelListener;
    }

    public boolean hasEvaluationPending() {
        return !this.commandQueue.isEmpty();
    }

    public RedirectedKernelListener getRedirectedListener() {
        return this.redirectedListener;
    }

    public int getKernelID() {
        return ((KernelConnectionListener)this.listeners.get(0)).getKernelID();
    }

    public KernelInterfaceProperties getInterfaceProperties() {
        return this.interfaceProperties;
    }

    public void setInterfaceProperties(KernelInterfaceProperties kernelInterfaceProperties) {
        this.interfaceProperties = kernelInterfaceProperties;
    }

    public void addKernelConnectionListener(KernelConnectionListener kernelConnectionListener) {
        this.listeners.add(kernelConnectionListener);
    }

    public KernelConnectionListener removeKernelConnectionListener(KernelConnectionListener kernelConnectionListener) {
        KernelConnectionListener kernelConnectionListener2 = null;
        int n = 0;
        n = this.listeners.indexOf(kernelConnectionListener);
        if (n > -1) {
            kernelConnectionListener2 = (KernelConnectionListener)this.listeners.remove(n);
        }
        return kernelConnectionListener2;
    }

    void confirmListener(KernelConnectionListener kernelConnectionListener) {
        if (this.listeners.indexOf(kernelConnectionListener) == -1) {
            this.listeners.add(kernelConnectionListener);
            kernelConnectionListener.setConnection(this);
            kernelConnectionListener.processConnection(new KernelConnectionEvent(1, 2, this, kernelConnectionListener));
        }
    }

    public int getNumberKernelConnectionListeners() {
        return this.listeners.size();
    }

    public KernelConnectionListener[] getListeners() {
        return this.listeners.toArray(new KernelConnectionListener[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryShutdown(int n) {
        boolean bl = false;
        if (this.getNumberKernelConnectionListeners() < 1) {
            KernelProxy.getInstance().shutdownConnection(n);
            bl = true;
            if (this.commandQueue != null) {
                CommandQueue commandQueue = this.commandQueue;
                synchronized (commandQueue) {
                    this.commandQueue.clear();
                    this.commandQueue.notifyAll();
                }
                this.commandQueue = null;
            }
            if (this.listeners != null) {
                this.listeners.clear();
                this.listeners = null;
            }
            this.interfaceProperties = null;
            this.redirectedListener = null;
        }
        return bl;
    }

    public static void setServerPort(int n) {
        startupPort = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startSockets() throws KernelCommunicationError {
        int n = -1;
        if (startupPort > 0) {
            n = startupPort;
            startupPort = -1;
        } else {
            KernelPortReady kernelPortReady = new KernelPortReady();
            this.serverSocket = new MapleServerSocket(kernelPortReady);
            this.serverSocket.setLanguage(RuntimeLocale.getDisplayEnvVariableName());
            Thread thread = new Thread(this.serverSocket);
            thread.start();
            KernelPortReady kernelPortReady2 = kernelPortReady;
            synchronized (kernelPortReady2) {
                try {
                    while (!kernelPortReady.ready && !kernelPortReady.error) {
                        kernelPortReady.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            int n2 = n = this.serverSocket != null ? this.serverSocket.getKernelPort() : -1;
        }
        if (n <= 0) {
            throw new KernelCommunicationError("Unable to open mserver");
        }
        this.startSockets(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startSockets(int n) {
        ClientReady clientReady = new ClientReady();
        this.clientSocket = new MapleClientSocket(n, clientReady);
        this.clientSocket.setKernelProxy(this.kernelProxy);
        this.clientSocket.setKernelConnection(this);
        Thread thread = new Thread((Runnable)this.clientSocket, "WMI:MapleClientSocket:Kernel Connection ");
        try {
            thread.setDaemon(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        thread.start();
        ClientReady clientReady2 = clientReady;
        synchronized (clientReady2) {
            try {
                while (!clientReady.ready && !clientReady.failed) {
                    clientReady.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (clientReady.failed) {
                throw new KernelCommunicationError(this.clientSocket.errorState());
            }
        }
    }

    public int getPort() {
        int n = -1;
        if (this.clientSocket != null) {
            n = this.clientSocket.getPort();
        }
        return n;
    }

    public void stopSockets() {
        this.clientSocket.shutdown();
        if (this.serverSocket != null) {
            this.serverSocket.Shutdown(true);
        }
    }

    public synchronized boolean interrupt() throws KernelCommunicationError {
        return this.interrupt(true);
    }

    public synchronized boolean interrupt(boolean bl) throws KernelCommunicationError {
        this.clearQueue();
        return this.clientSocket.interrupt(bl);
    }

    public synchronized void toDebugMode() throws KernelCommunicationError {
        this.clientSocket.toDebugMode();
    }

    public synchronized void clearQueue() {
        if (this.commandQueue != null) {
            this.commandQueue.clear();
        }
    }

    public InputStream getClientInputStream() {
        return this.clientSocket.getSocketInputStream();
    }

    public OutputStream getClientOutputStream() {
        return this.clientSocket.getSocketOutputStream();
    }

    public String toString() {
        String string = "no listener";
        if (this.listeners.size() > 0) {
            string = String.valueOf(((KernelConnectionListener)this.listeners.get(0)).getKernelID() + 1);
        }
        return "KernelConnection: Server " + string;
    }

    public void setClientSocket(MapleClientSocket mapleClientSocket) {
        this.clientSocket = mapleClientSocket;
    }
}

