/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client;

import com.maplesoft.client.KernelEvent;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class JavaCallbackListener {
    public static final String ERROR_CLASS_ACCESS = "Access to this class is not allowed.";
    public static final String ERROR_NUM_ARGS = "Number of actual arguments does not match signature.";
    public static final String ERROR_ARG_TYPE = "Argument type doesn't match signature.";
    public static final String ERROR_UNEXPECTED = "An unexpected error occurred: ";

    public static boolean processJava(KernelEvent kernelEvent) {
        Dag dag = kernelEvent.getDag();
        String string = dag.getChild(0).getData();
        String string2 = dag.getChild(1).getData();
        String string3 = dag.getChild(2).getData();
        Dag dag2 = dag.getChild(3);
        if (!string.startsWith("com.maplesoft.")) {
            kernelEvent.setResponseAsDag(DagUtil.createErrorDag(ERROR_CLASS_ACCESS));
            return true;
        }
        try {
            Class<?> clazz = Class.forName(string);
            Class[] classArray = JavaCallbackListener.getClassObjects(string3);
            Method method = clazz.getMethod(string2, classArray);
            Object[] objectArray = new Object[classArray.length];
            if (dag2.getLength() != classArray.length) {
                kernelEvent.setResponseAsDag(DagUtil.createErrorDag(ERROR_NUM_ARGS));
                return true;
            }
            if (classArray != null) {
                for (int i = 0; i < classArray.length; ++i) {
                    objectArray[i] = JavaCallbackListener.getObjectFromDag(dag2.getChild(i), classArray[i]);
                    if (objectArray[i] != null) continue;
                    kernelEvent.setResponseAsDag(DagUtil.createErrorDag(ERROR_ARG_TYPE));
                    return true;
                }
            }
            Object object = method.invoke(clazz, objectArray);
            Object var11_13 = null;
            Dag dag3 = null;
            if (object instanceof String) {
                dag3 = DagUtil.createStringDag((String)object);
            } else if (object instanceof Boolean) {
                dag3 = DagUtil.createNameDag(((Boolean)object).toString());
            } else if (object instanceof Byte) {
                dag3 = DagUtil.createIntDag(((Byte)object).intValue());
            } else if (object instanceof Character) {
                dag3 = DagUtil.createStringDag(((Character)object).toString());
            } else if (object instanceof Short) {
                dag3 = DagUtil.createIntDag(((Short)object).intValue());
            } else if (object instanceof Integer) {
                dag3 = DagUtil.createIntDag((Integer)object);
            } else if (object instanceof Long) {
                dag3 = DagUtil.createIntDag((Long)object);
            } else if (object instanceof Float) {
                dag3 = DagUtil.createFloatDag(((Float)object).floatValue());
            } else if (object instanceof Double) {
                dag3 = DagUtil.createDoubleDag((Double)object);
            }
            if (dag3 != null) {
                String string4 = DagBuilder.createDotm(dag3);
                kernelEvent.setResponseAsDotM(string4);
            }
        }
        catch (Exception exception) {
            kernelEvent.setResponseAsDag(DagUtil.createErrorDag(ERROR_UNEXPECTED + exception));
            return true;
        }
        return true;
    }

    public static Class[] getClassObjects(String string) {
        int n;
        Object object;
        if (string.charAt(0) != '(' || string.length() < 2) {
            return null;
        }
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        boolean bl = false;
        int n2 = 1;
        while (true) {
            object = null;
            char c = string.charAt(n2);
            switch (c) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    object = JavaCallbackListener.getClassObject(Character.toString(c));
                    ++n2;
                    break;
                }
                case 'L': {
                    n = string.indexOf(59, n2);
                    if (n == -1) {
                        return null;
                    }
                    object = JavaCallbackListener.getClassObject(string.substring(n2, n + 1));
                    n2 = n + 1;
                    break;
                }
                case '[': {
                    return null;
                }
                case ')': {
                    bl = true;
                    object = JavaCallbackListener.getClassObject(string.substring(n2 + 1, string.length()));
                    n2 = string.length();
                    break;
                }
                default: {
                    return null;
                }
            }
            if (n2 == string.length()) break;
            if (object == null) {
                return null;
            }
            arrayList.add((Object[])object);
        }
        if (!bl) {
            return null;
        }
        object = arrayList.toArray();
        if (((Object[])object).length == 0) {
            Class[] classArray = new Class[]{};
            return classArray;
        }
        Class[] classArray = new Class[((Object[])object).length];
        for (n = 0; n < ((Object[])object).length; ++n) {
            classArray[n] = (Class)object[n];
        }
        return classArray;
    }

    public static Class getClassObject(String string) {
        try {
            if (string == null || string.length() == 0) {
                return Class.forName("void");
            }
            char c = string.charAt(0);
            switch (c) {
                case 'Z': {
                    return Boolean.TYPE;
                }
                case 'B': {
                    return Byte.TYPE;
                }
                case 'C': {
                    return Character.TYPE;
                }
                case 'S': {
                    return Short.TYPE;
                }
                case 'I': {
                    return Integer.TYPE;
                }
                case 'J': {
                    return Long.TYPE;
                }
                case 'F': {
                    return Float.TYPE;
                }
                case 'D': {
                    return Double.TYPE;
                }
                case 'L': {
                    return Class.forName(string.substring(1, string.length() - 1).replace('/', '.'));
                }
                case '[': {
                    return null;
                }
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object getObjectFromDag(Dag dag, Class clazz) {
        String string = dag.getData();
        if (clazz.equals(String.class)) {
            return string;
        }
        if (clazz.equals(Boolean.TYPE)) {
            if (dag.getType() == 2 || dag.getType() == 1) {
                if (DagUtil.parseInt(dag) == 0) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            if (dag.getType() == 7 || dag.getType() == 8) {
                return Boolean.valueOf(string);
            }
            return null;
        }
        if (clazz.equals(Byte.TYPE)) {
            if (dag.getType() == 2 || dag.getType() == 1) {
                return new Byte((byte)DagUtil.parseInt(dag));
            }
            if (dag.getType() == 7 || dag.getType() == 8) {
                return Byte.valueOf(string.substring(0, 1));
            }
            return null;
        }
        if (clazz.equals(Character.TYPE)) {
            return new Character(string.charAt(0));
        }
        if (clazz.equals(Short.TYPE)) {
            if (dag.getType() == 2 || dag.getType() == 1) {
                return new Short((short)DagUtil.parseInt(dag));
            }
            if (dag.getType() == 7 || dag.getType() == 8) {
                return Short.valueOf(string.substring(0, 1));
            }
            return null;
        }
        if (clazz.equals(Integer.TYPE)) {
            if (dag.getType() == 2 || dag.getType() == 1) {
                return new Integer(DagUtil.parseInt(dag));
            }
            if (dag.getType() == 7 || dag.getType() == 8) {
                return Integer.valueOf(string.substring(0, 1));
            }
            return null;
        }
        if (clazz.equals(Long.TYPE)) {
            if (dag.getType() == 2 || dag.getType() == 1) {
                return new Long(DagUtil.parseLong(dag));
            }
            if (dag.getType() == 7 || dag.getType() == 8) {
                return Long.valueOf(string.substring(0, 1));
            }
            return null;
        }
        if (clazz.equals(Float.TYPE)) {
            if (dag.getType() == 4) {
                long l = DagUtil.parseLong(dag.getChild(0));
                long l2 = DagUtil.parseLong(dag.getChild(1));
                return new Float((float)((double)l * Math.pow(10.0, l2)));
            }
            if (dag.getType() == 3) {
                long l = DagUtil.parseLong(dag.getChild(0));
                long l3 = DagUtil.parseLong(dag.getChild(1));
                return new Float((float)l / (float)l3);
            }
            return null;
        }
        if (clazz.equals(Double.TYPE)) {
            if (dag.getType() == 4) {
                long l = DagUtil.parseLong(dag.getChild(0));
                long l4 = DagUtil.parseLong(dag.getChild(1));
                return new Double((double)l * Math.pow(10.0, l4));
            }
            if (dag.getType() == 3) {
                long l = DagUtil.parseLong(dag.getChild(0));
                long l5 = DagUtil.parseLong(dag.getChild(1));
                return new Double((double)l / (double)l5);
            }
            return null;
        }
        return string;
    }
}

