<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"
	language="java"%>
<%@ page import="com.maplesoft.mapleta.classadmin.Constants"%>

<%@ page import="com.maplesoft.mapleta.configuration.MapleTASystemConfiguration"%>


<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles"%>
<%@ taglib uri="http://displaytag.sf.net" prefix="display"%>

<tiles:useAttribute name="changeInstructor" />
<tiles:useAttribute name="no_buttons" ignore="true" />

	<% if( MapleTASystemConfiguration.isOPENUW() ){ %>
<link rel="stylesheet"
	href="<%=request.getContextPath()%>/modules/repository-src/css/index.css">

<script
	src="<%=request.getContextPath()%>/modules/scripts/backbone/backbone-optamd3-min.js"></script>
<script
	src="<%=request.getContextPath()%>/modules/scripts/jquery/jquery-ui-nestedSortable.js"></script>
		
<script
	data-main="<%=request.getContextPath()%>/modules/repository/js/main"
	src="<%=request.getContextPath()%>/modules/scripts/require/require.js"></script>
	
<script type="text/javascript">
var browseMode = "class";
</script>
<% } %>

<c:set var="contextPath" value="<%=request.getContextPath()%>" />

<c:set var="delete"><%=Constants.LIST_DELETE%></c:set>
<c:set var="restore"><%=Constants.LIST_RESTORE%></c:set>


<em class="title"> <c:if test="${not empty error}">${error}</c:if>
</em>

<fmt:bundle
	basename="com.maplesoft.mapleta.application.ApplicationResources">

	<html:messages id="msg" message="false">
		<span class="errorStyle1"><c:out value='${msg}' /></span>
		<br>
	</html:messages>

	<div class="row section">
		<div class="span3 sectionName">
			<h3>
				<fmt:message key="ClassAdmin.class.label" />
			</h3>
			<ul>

				<c:if
					test="${sessionScope.context.currentRole.editClass && (empty no_buttons)}">
					<li><a
						href="<%=request.getContextPath()%>/classmanager/ChangeInstructor.do?classid=${InfoForm.classId}"><fmt:message
								key='InfoForm.chooseinstructor.label' /></a></li>
				</c:if>

				<c:if
					test="${(empty no_buttons)}">

					<c:if test="${sessionScope.context.currentRole.editClass}">
						<li><a
							href="<%=request.getContextPath()%>/classmanager/ClassEdit.do?classid=${InfoForm.classId}"><fmt:message
								key='InfoForm.edit.label' /></a></li>
					</c:if>
					<c:if test="${sessionScope.context.currentRole.deleteClass}">
						<li>
						<c:choose>
							<c:when test="${InfoForm.deleted != 'true'}">
								<a
									href="${contextPath}/classmanager/ConfirmDelete.do?classid=${InfoForm.classId}"><fmt:message
										key='InfoForm.delete.label' /></a>
							</c:when>
							<c:otherwise>
								<a
									href="${contextPath}/classmanager/ConfirmRestore.do?classid=${InfoForm.classId}"><fmt:message
										key='InfoForm.restore.label' /></a>
							</c:otherwise>
						</c:choose>
						</li>
					</c:if>

				</c:if>
			</ul>
		</div>

		<div class="span9 sectionMain">

			<table>

				<tr>
					<td valign=top class="title" width=30%><b><fmt:message
								key="ClassAdmin.classname.label" /></b></td>
					<td><c:out
							value="${InfoForm.className}" escapeXml="false"/></td>
				</tr>

				<tr>
					<td valign=top class="title" width=30%><b><fmt:message
								key="ClassAdmin.classShortName.label" /></b></td>
					<td><c:out
							value="${InfoForm.classShortName}" escapeXml="false"/></td>
				</tr>
				
				<tr>
					<td valign=top class="title" width=30%><b><fmt:message
								key="ClassAdmin.classDescription.label" /></b></td>
					<td><c:out
							value="${InfoForm.description}" escapeXml="false"/></td>
				</tr>
				
				
				<tr>
					<td class="title" width=30%><b><fmt:message
								key="ClassAdmin.instructor.label" /></b></td>
					<td><c:out value="${UserForm.givenName}" /> <c:out
							value="${UserForm.sn}"  escapeXml="false"/></td>
				</tr>
				<tr>
					<td class="title" width=30%><b><fmt:message
								key="ClassAdmin.instructoremail.label" /></b></td>
					<td><c:out value="${UserForm.email}"  escapeXml="false"/></td>
				</tr>


				<tr>
					<td class="title" width=30%><b><fmt:message
								key="ClassAdmin.courseid.label" /></b></td>
					<td><c:out value="${InfoForm.courseId}"  escapeXml="false"/></td>
				</tr>
				<tr>
					<td class="title"><b>
					<% if( MapleTASystemConfiguration.isOPENUW() ){ %>
						Subheading
					<% }else{ %>
					<fmt:message
								key="ClassAdmin.school.label" />
					<% } %>
								</b></td>
					<td><c:out value="${InfoForm.school}"  escapeXml="false"/></td>
				</tr>
				<tr>
					<td><b><fmt:message key="ClassAdmin.parentname.label" /></b></td>
					<td><c:out value="${InfoForm.parentName}"  escapeXml="false"/></td>
				</tr>
				<tr>
					<td class="title"><b><fmt:message
								key="ClassAdmin.creationdate.label" /></b></td>
					<td><fmt:formatDate value="${InfoForm.creationDate}"
							type="date" dateStyle="full" /></td>
				</tr>
				<tr>
					<td class="title"><b><fmt:message
								key="ClassAdmin.featured.label" /></b></td>
					<td><c:out value="${InfoForm.featuredDescription}"  escapeXml="false"/></td>
				</tr>
				<tr>
					<td class="title"><b><fmt:message
								key="ClassAdmin.anonymousaccess.label" /></b></td>
					<td><c:out value="${InfoForm.anonymousAccess}" /></td>
				</tr>
				<tr>
					<td class="title"><b><fmt:message
								key="ClassAdmin.allowdrop.label" /></b></td>
					<td><c:out value="${InfoForm.allowDrop}" /></td>
				</tr>
				
				<% if( MapleTASystemConfiguration.isENABLE_ASSIGNMENT_REPOSITORY() ){ %>
				<tr>
					<td class="title" width="40%"><b><fmt:message key="ClassAdmin.assignmentDisplayMode.label" /></b></td>
					<td><c:out value="${InfoForm.assignmentDisplayModeMessage}" /></td>
				</tr>
				<% } %>
				
				
				</table>
<c:if test="${ empty no_buttons }">
		</div>
	</div>
	
	<% if( MapleTASystemConfiguration.isOPENUW() ){ %>
	<div class="row section">
		<div class="span3 sectionName">
			<h3>
				<fmt:message key="ClassAdmin.class.subjects.label" />
			</h3>
			<ul>
				<li><a id="editSubjects"><fmt:message key="ClassAdmin.class.subjects.edit.label" /><a id="editDone" class="hidden"><fmt:message key="ClassAdmin.class.subjects.editDone.label" /></a>
			</ul>
		</div>

		<div class="span9 sectionMain">
			<ul id="classSubjects" data-classid="${ InfoForm.classId }">
			</ul>
		</div>
	</div>
	<% } %>
</c:if>


</fmt:bundle>
